/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import androidx.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.model.mutation.TransformOperation;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.Value;

public class NumericIncrementTransformOperation
implements TransformOperation {
    private Value operand;

    public NumericIncrementTransformOperation(Value operand) {
        Assert.hardAssert(Values.isNumber(operand), "NumericIncrementTransformOperation expects a NumberValue operand", new Object[0]);
        this.operand = operand;
    }

    @Override
    public Value applyToLocalView(@Nullable Value previousValue, Timestamp localWriteTime) {
        Value baseValue = this.computeBaseValue(previousValue);
        if (Values.isInteger(baseValue) && Values.isInteger(this.operand)) {
            long sum = this.safeIncrement(baseValue.getIntegerValue(), this.operandAsLong());
            return (Value)Value.newBuilder().setIntegerValue(sum).build();
        }
        if (Values.isInteger(baseValue)) {
            double sum = (double)baseValue.getIntegerValue() + this.operandAsDouble();
            return (Value)Value.newBuilder().setDoubleValue(sum).build();
        }
        Assert.hardAssert(Values.isDouble(baseValue), "Expected NumberValue to be of type DoubleValue, but was ", previousValue.getClass().getCanonicalName());
        double sum = baseValue.getDoubleValue() + this.operandAsDouble();
        return (Value)Value.newBuilder().setDoubleValue(sum).build();
    }

    @Override
    public Value applyToRemoteDocument(@Nullable Value previousValue, Value transformResult) {
        return transformResult;
    }

    public Value getOperand() {
        return this.operand;
    }

    @Override
    public Value computeBaseValue(@Nullable Value previousValue) {
        return Values.isNumber(previousValue) ? previousValue : (Value)Value.newBuilder().setIntegerValue(0L).build();
    }

    private long safeIncrement(long x, long y) {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) >= 0L) {
            return r;
        }
        if (r >= 0L) {
            return Long.MIN_VALUE;
        }
        return Long.MAX_VALUE;
    }

    private double operandAsDouble() {
        if (Values.isDouble(this.operand)) {
            return this.operand.getDoubleValue();
        }
        if (Values.isInteger(this.operand)) {
            return this.operand.getIntegerValue();
        }
        throw Assert.fail("Expected 'operand' to be of Number type, but was " + this.operand.getClass().getCanonicalName(), new Object[0]);
    }

    private long operandAsLong() {
        if (Values.isDouble(this.operand)) {
            return (long)this.operand.getDoubleValue();
        }
        if (Values.isInteger(this.operand)) {
            return this.operand.getIntegerValue();
        }
        throw Assert.fail("Expected 'operand' to be of Number type, but was " + this.operand.getClass().getCanonicalName(), new Object[0]);
    }
}

