/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.Value;

public class NotInFilter
extends FieldFilter {
    NotInFilter(FieldPath field, Value value) {
        super(field, FieldFilter.Operator.NOT_IN, value);
        Assert.hardAssert(Values.isArray(value), "NotInFilter expects an ArrayValue", new Object[0]);
    }

    @Override
    public boolean matches(Document doc) {
        if (Values.contains(this.getValue().getArrayValue(), Values.NULL_VALUE)) {
            return false;
        }
        Value other = doc.getField(this.getField());
        return other != null && !Values.contains(this.getValue().getArrayValue(), other);
    }
}

