/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.util;

import com.google.firebase.firestore.util.ApiUtil;

public class Assert {
    public static void hardAssert(boolean condition, String messageFormat, Object ... args) {
        if (!condition) {
            throw Assert.fail(messageFormat, args);
        }
    }

    public static <T> T hardAssertNonNull(T obj, String messageFormat, Object ... args) {
        if (obj == null) {
            throw Assert.fail(messageFormat, args);
        }
        return obj;
    }

    public static AssertionError fail(String messageFormat, Object ... args) {
        throw new AssertionError((Object)Assert.format(messageFormat, args));
    }

    public static AssertionError fail(Throwable cause, String messageFormat, Object ... args) {
        throw ApiUtil.newAssertionError(Assert.format(messageFormat, args), cause);
    }

    private static String format(String messageFormat, Object ... args) {
        return "INTERNAL ASSERTION FAILED: " + String.format(messageFormat, args);
    }
}

