/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.functions;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.security.ProviderInstaller;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.functions.ContextProvider;
import com.google.firebase.functions.FirebaseFunctions$$Lambda$1;
import com.google.firebase.functions.FirebaseFunctions$$Lambda$2;
import com.google.firebase.functions.FirebaseFunctions$$Lambda$3;
import com.google.firebase.functions.FirebaseFunctionsException;
import com.google.firebase.functions.FunctionsMultiResourceComponent;
import com.google.firebase.functions.HttpsCallOptions;
import com.google.firebase.functions.HttpsCallableContext;
import com.google.firebase.functions.HttpsCallableReference;
import com.google.firebase.functions.HttpsCallableResult;
import com.google.firebase.functions.Serializer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class FirebaseFunctions {
    private static final TaskCompletionSource<Void> providerInstalled = new TaskCompletionSource();
    private static boolean providerInstallStarted = false;
    private final OkHttpClient client = new OkHttpClient();
    private final Serializer serializer = new Serializer();
    private final ContextProvider contextProvider;
    private final String projectId;
    private final String region;
    private String urlFormat = "https://%1$s-%2$s.cloudfunctions.net/%3$s";

    FirebaseFunctions(Context context, String projectId, String region, ContextProvider contextProvider) {
        this.contextProvider = (ContextProvider)Preconditions.checkNotNull((Object)contextProvider);
        this.projectId = (String)Preconditions.checkNotNull((Object)projectId);
        this.region = (String)Preconditions.checkNotNull((Object)region);
        FirebaseFunctions.maybeInstallProviders(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void maybeInstallProviders(Context context) {
        TaskCompletionSource<Void> taskCompletionSource = providerInstalled;
        synchronized (taskCompletionSource) {
            if (providerInstallStarted) {
                return;
            }
            providerInstallStarted = true;
        }
        Runnable runnable = FirebaseFunctions$$Lambda$1.lambdaFactory$(context);
        Handler handler = new Handler(context.getMainLooper());
        handler.post(runnable);
    }

    public static FirebaseFunctions getInstance(FirebaseApp app, String region) {
        Preconditions.checkNotNull((Object)app, (Object)"You must call FirebaseApp.initializeApp first.");
        Preconditions.checkNotNull((Object)region);
        FunctionsMultiResourceComponent component = (FunctionsMultiResourceComponent)app.get(FunctionsMultiResourceComponent.class);
        Preconditions.checkNotNull((Object)component, (Object)"Functions component does not exist.");
        return component.get(region);
    }

    public static FirebaseFunctions getInstance(FirebaseApp app) {
        return FirebaseFunctions.getInstance(app, "us-central1");
    }

    public static FirebaseFunctions getInstance(String region) {
        return FirebaseFunctions.getInstance(FirebaseApp.getInstance(), region);
    }

    public static FirebaseFunctions getInstance() {
        return FirebaseFunctions.getInstance(FirebaseApp.getInstance(), "us-central1");
    }

    public HttpsCallableReference getHttpsCallable(String name) {
        return new HttpsCallableReference(this, name);
    }

    @VisibleForTesting
    URL getURL(String function) {
        String str = String.format(this.urlFormat, this.region, this.projectId, function);
        try {
            return new URL(str);
        }
        catch (MalformedURLException mfe) {
            throw new IllegalStateException(mfe);
        }
    }

    public void useFunctionsEmulator(@NonNull String origin) {
        Preconditions.checkNotNull((Object)origin, (Object)"origin cannot be null");
        this.urlFormat = origin + "/%2$s/%1$s/%3$s";
    }

    Task<HttpsCallableResult> call(String name, @Nullable Object data, HttpsCallOptions options) {
        return providerInstalled.getTask().continueWithTask(FirebaseFunctions$$Lambda$2.lambdaFactory$(this)).continueWithTask(FirebaseFunctions$$Lambda$3.lambdaFactory$(this, name, data, options));
    }

    private Task<HttpsCallableResult> call(@NonNull String name, @Nullable Object data, HttpsCallableContext context, HttpsCallOptions options) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        URL url = this.getURL(name);
        HashMap<String, Object> body = new HashMap<String, Object>();
        Object encoded = this.serializer.encode(data);
        body.put("data", encoded);
        JSONObject bodyJSON = new JSONObject(body);
        MediaType contentType = MediaType.parse((String)"application/json");
        RequestBody requestBody = RequestBody.create((MediaType)contentType, (String)bodyJSON.toString());
        Request.Builder request = new Request.Builder().url(url).post(requestBody);
        if (context.getAuthToken() != null) {
            request = request.header("Authorization", "Bearer " + context.getAuthToken());
        }
        if (context.getInstanceIdToken() != null) {
            request = request.header("Firebase-Instance-ID-Token", context.getInstanceIdToken());
        }
        OkHttpClient callClient = options.apply(this.client);
        Call call = callClient.newCall(request.build());
        final TaskCompletionSource tcs = new TaskCompletionSource();
        call.enqueue(new Callback(){

            public void onFailure(Call ignored, IOException e) {
                if (e instanceof InterruptedIOException) {
                    FirebaseFunctionsException exception = new FirebaseFunctionsException(FirebaseFunctionsException.Code.DEADLINE_EXCEEDED.name(), FirebaseFunctionsException.Code.DEADLINE_EXCEEDED, null, e);
                    tcs.setException((Exception)((Object)exception));
                } else {
                    FirebaseFunctionsException exception = new FirebaseFunctionsException(FirebaseFunctionsException.Code.INTERNAL.name(), FirebaseFunctionsException.Code.INTERNAL, null, e);
                    tcs.setException((Exception)((Object)exception));
                }
            }

            public void onResponse(Call ignored, Response response) throws IOException {
                JSONObject bodyJSON;
                String body;
                FirebaseFunctionsException.Code code = FirebaseFunctionsException.Code.fromHttpStatus(response.code());
                FirebaseFunctionsException exception = FirebaseFunctionsException.fromResponse(code, body = response.body().string(), FirebaseFunctions.this.serializer);
                if (exception != null) {
                    tcs.setException((Exception)((Object)exception));
                    return;
                }
                try {
                    bodyJSON = new JSONObject(body);
                }
                catch (JSONException je) {
                    FirebaseFunctionsException e = new FirebaseFunctionsException("Response is not valid JSON object.", FirebaseFunctionsException.Code.INTERNAL, null, je);
                    tcs.setException((Exception)((Object)e));
                    return;
                }
                Object dataJSON = bodyJSON.opt("data");
                if (dataJSON == null) {
                    dataJSON = bodyJSON.opt("result");
                }
                if (dataJSON == null) {
                    FirebaseFunctionsException e = new FirebaseFunctionsException("Response is missing data field.", FirebaseFunctionsException.Code.INTERNAL, null);
                    tcs.setException((Exception)((Object)e));
                    return;
                }
                HttpsCallableResult result = new HttpsCallableResult(FirebaseFunctions.this.serializer.decode(dataJSON));
                tcs.setResult((Object)result);
            }
        });
        return tcs.getTask();
    }

    static /* synthetic */ Task lambda$call$2(FirebaseFunctions this_, String name, Object data, HttpsCallOptions options, Task task) throws Exception {
        if (!task.isSuccessful()) {
            return Tasks.forException((Exception)task.getException());
        }
        HttpsCallableContext context = (HttpsCallableContext)task.getResult();
        return this_.call(name, data, context, options);
    }

    static /* synthetic */ Task lambda$call$1(FirebaseFunctions this_, Task task) throws Exception {
        return this_.contextProvider.getContext();
    }

    static /* synthetic */ void lambda$maybeInstallProviders$0(Context context) {
        ProviderInstaller.installIfNeededAsync((Context)context, (ProviderInstaller.ProviderInstallListener)new ProviderInstaller.ProviderInstallListener(){

            public void onProviderInstalled() {
                providerInstalled.setResult(null);
            }

            public void onProviderInstallFailed(int i, Intent intent) {
                Log.d((String)"FirebaseFunctions", (String)"Failed to update ssl context");
                providerInstalled.setResult(null);
            }
        });
    }
}

