/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzb;
import com.google.firebase.iid.zzd;
import com.google.firebase.iid.zze;
import com.google.firebase.iid.zzf;
import com.google.firebase.iid.zzg;
import com.google.firebase.iid.zzh;
import java.io.IOException;

public class FirebaseInstanceIdService
extends zzb {
    private static BroadcastReceiver zzcln;
    @VisibleForTesting
    static final Object zzclo;
    @VisibleForTesting
    static boolean zzclp;
    private boolean zzclq = false;

    public boolean zzE(Intent intent) {
        this.zzclq = Log.isLoggable((String)"FirebaseInstanceId", (int)3);
        if (intent.getStringExtra("error") != null || intent.getStringExtra("registration_id") != null) {
            String string = this.zzG(intent);
            if (this.zzclq) {
                String string2 = String.valueOf(string);
                Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Register result in service ".concat(string2) : new String("Register result in service ")));
            }
            this.zzjw(string).zzabR().zzs(intent);
            return true;
        }
        return false;
    }

    public void handleIntent(Intent intent) {
        String string = intent.getAction();
        if (string == null) {
            string = "";
        }
        switch (string) {
            case "ACTION_TOKEN_REFRESH_RETRY": {
                this.zza(intent, false, false);
                return;
            }
        }
        this.zzF(intent);
    }

    protected Intent zzD(Intent intent) {
        return zzg.zzabU().zzabV();
    }

    public void zzF(Intent intent) {
        String string = this.zzG(intent);
        zzd zzd2 = this.zzjw(string);
        String string2 = intent.getStringExtra("CMD");
        if (this.zzclq) {
            String string3 = String.valueOf(intent.getExtras());
            Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Service command ").append(string).append(" ").append(string2).append(" ").append(string3).toString());
        }
        if (null != intent.getStringExtra("unregistered")) {
            zzd2.zzabQ().zzeK(string == null ? "" : string);
            zzd2.zzabR().zzs(intent);
            return;
        }
        if ("gcm.googleapis.com/refresh".equals(intent.getStringExtra("from"))) {
            zzd2.zzabQ().zzeK(string);
            this.zza(intent, false, true);
            return;
        }
        if ("RST".equals(string2)) {
            zzd2.zzHi();
            this.zza(intent, true, true);
        } else if ("RST_FULL".equals(string2)) {
            if (!zzd2.zzabQ().isEmpty()) {
                zzd2.zzHi();
                zzd2.zzabQ().zzHo();
                this.zza(intent, true, true);
            }
        } else if ("SYNC".equals(string2)) {
            zzd2.zzabQ().zzeK(string);
            this.zza(intent, false, true);
        } else if ("PING".equals(string2)) {
            this.zza(zzd2.zzabR(), intent.getExtras());
        }
    }

    private String zzG(Intent intent) {
        String string = intent.getStringExtra("subtype");
        return string == null ? "" : string;
    }

    private zzd zzjw(String string) {
        if (string == null) {
            return zzd.zzb((Context)this, null);
        }
        Bundle bundle = new Bundle();
        bundle.putString("subtype", string);
        return zzd.zzb((Context)this, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(Intent intent, boolean bl, boolean bl2) {
        Object object = zzclo;
        synchronized (object) {
            zzclp = false;
        }
        if (zzf.zzbA((Context)this) == null) {
            return;
        }
        object = FirebaseInstanceId.getInstance();
        zzh.zza zza2 = ((FirebaseInstanceId)object).zzabN();
        if (zza2 == null || zza2.zzjB(zzd.zzbhN)) {
            try {
                String string = ((FirebaseInstanceId)object).zzabO();
                if (string != null) {
                    if (this.zzclq) {
                        Log.d((String)"FirebaseInstanceId", (String)"get master token succeeded");
                    }
                    FirebaseInstanceIdService.zza((Context)this, (FirebaseInstanceId)object);
                    if (bl2 || zza2 == null || zza2 != null && !string.equals(zza2.zzbxT)) {
                        this.onTokenRefresh();
                    }
                    return;
                }
                this.zzd(intent, "returned token is null");
            }
            catch (IOException iOException) {
                this.zzd(intent, iOException.getMessage());
            }
            catch (SecurityException securityException) {
                Log.e((String)"FirebaseInstanceId", (String)"Unable to get master token", (Throwable)securityException);
                return;
            }
            return;
        }
        zze zze2 = ((FirebaseInstanceId)object).zzabP();
        String string = zze2.zzabS();
        while (string != null) {
            String[] stringArray = string.split("!");
            if (stringArray.length == 2) {
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                try {
                    switch (string2) {
                        case "S": {
                            FirebaseInstanceId.getInstance().zzju(string3);
                            if (!this.zzclq) break;
                            Log.d((String)"FirebaseInstanceId", (String)"subscribe operation succeeded");
                            break;
                        }
                        case "U": {
                            FirebaseInstanceId.getInstance().zzjv(string3);
                            if (!this.zzclq) break;
                            Log.d((String)"FirebaseInstanceId", (String)"unsubscribe operation succeeded");
                        }
                    }
                }
                catch (IOException iOException) {
                    this.zzd(intent, iOException.getMessage());
                    return;
                }
            }
            zze2.zzjx(string);
            string = zze2.zzabS();
        }
        Log.d((String)"FirebaseInstanceId", (String)"topic sync succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzd(Intent intent, String string) {
        boolean bl = FirebaseInstanceIdService.zzct((Context)this);
        final int n = this.zza(intent, bl);
        Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(47 + String.valueOf(string).length()).append("background sync failed: ").append(string).append(", retry in ").append(n).append("s").toString());
        Object object = zzclo;
        synchronized (object) {
            this.zzqG(n);
            zzclp = true;
        }
        if (!bl) {
            if (this.zzclq) {
                Log.d((String)"FirebaseInstanceId", (String)"device not connected. Connectivity change received registered");
            }
            if (zzcln == null) {
                zzcln = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        if (FirebaseInstanceIdService.zzct(context)) {
                            if (FirebaseInstanceIdService.this.zzclq) {
                                Log.d((String)"FirebaseInstanceId", (String)"connectivity changed. starting background sync.");
                            }
                            FirebaseInstanceIdService.this.getApplicationContext().unregisterReceiver((BroadcastReceiver)this);
                            zzg.zzabU().zzf(context, FirebaseInstanceIdService.zzqF(n));
                        }
                    }
                };
            }
            this.getApplicationContext().registerReceiver(zzcln, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Context context, FirebaseInstanceId firebaseInstanceId) {
        Object object = zzclo;
        synchronized (object) {
            if (zzclp) {
                return;
            }
        }
        object = firebaseInstanceId.zzabN();
        if (object == null || ((zzh.zza)object).zzjB(zzd.zzbhN) || firebaseInstanceId.zzabP().zzabS() != null) {
            FirebaseInstanceIdService.zzcs(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zzcs(Context context) {
        if (zzf.zzbA(context) == null) {
            return;
        }
        Object object = zzclo;
        synchronized (object) {
            if (!zzclp) {
                zzg.zzabU().zzf(context, FirebaseInstanceIdService.zzqF(0));
                zzclp = true;
            }
        }
    }

    private static Intent zzqF(int n) {
        Intent intent = new Intent("ACTION_TOKEN_REFRESH_RETRY");
        intent.putExtra("next_retry_delay_in_seconds", n);
        return intent;
    }

    private void zzqG(int n) {
        AlarmManager alarmManager = (AlarmManager)this.getSystemService("alarm");
        PendingIntent pendingIntent = zzg.zza((Context)this, 0, FirebaseInstanceIdService.zzqF(n * 2), 0x8000000);
        alarmManager.set(3, SystemClock.elapsedRealtime() + (long)(n * 1000), pendingIntent);
    }

    private int zza(Intent intent, boolean bl) {
        int n = intent == null ? 10 : intent.getIntExtra("next_retry_delay_in_seconds", 0);
        if (n < 10 && !bl) {
            n = 30;
        } else if (n < 10) {
            n = 10;
        } else if (n > 28800) {
            n = 28800;
        }
        return n;
    }

    private static boolean zzct(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    private void zza(zzf zzf2, Bundle bundle) {
        String string = zzf.zzbA((Context)this);
        if (string == null) {
            Log.w((String)"FirebaseInstanceId", (String)"Unable to respond to ping due to missing target package");
            return;
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        intent.setPackage(string);
        intent.putExtras(bundle);
        zzf2.zzp(intent);
        intent.putExtra("google.to", "google.com/iid");
        intent.putExtra("google.message_id", zzf.zzHn());
        this.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    @WorkerThread
    public void onTokenRefresh() {
    }

    static {
        zzclo = new Object();
        zzclp = false;
    }
}

