/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.support.v4.util.SimpleArrayMap;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceIdInternalReceiver;
import java.util.LinkedList;
import java.util.Queue;

public final class zzq {
    private static zzq zzcnG;
    private final SimpleArrayMap<String, String> zzcnH = new SimpleArrayMap();
    private Boolean zzcnI = null;
    @VisibleForTesting
    final Queue<Intent> zzcnJ = new LinkedList<Intent>();
    @VisibleForTesting
    private Queue<Intent> zzcnK = new LinkedList<Intent>();

    public static synchronized zzq zzKm() {
        if (zzcnG == null) {
            zzcnG = new zzq();
        }
        return zzcnG;
    }

    private zzq() {
    }

    public static PendingIntent zza(Context context, int n, Intent intent, int n2) {
        return zzq.zza(context, 0, "com.google.firebase.INSTANCE_ID_EVENT", intent, 0x8000000);
    }

    public static PendingIntent zzb(Context context, int n, Intent intent, int n2) {
        return zzq.zza(context, n, "com.google.firebase.MESSAGING_EVENT", intent, 0x40000000);
    }

    private static PendingIntent zza(Context context, int n, String string, Intent intent, int n2) {
        Intent intent2 = new Intent(context, FirebaseInstanceIdInternalReceiver.class);
        intent2.setAction(string);
        intent2.putExtra("wrapped_intent", (Parcelable)intent);
        return PendingIntent.getBroadcast((Context)context, (int)n, (Intent)intent2, (int)n2);
    }

    public final Intent zzKn() {
        return this.zzcnK.poll();
    }

    public final void zze(Context context, Intent intent) {
        this.zza(context, "com.google.firebase.INSTANCE_ID_EVENT", intent);
    }

    public final int zza(Context context, String string, Intent intent) {
        switch (string) {
            case "com.google.firebase.INSTANCE_ID_EVENT": {
                this.zzcnJ.offer(intent);
                break;
            }
            case "com.google.firebase.MESSAGING_EVENT": {
                this.zzcnK.offer(intent);
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                Log.w((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Unknown service action: ".concat(string2) : new String("Unknown service action: ")));
                return 500;
            }
        }
        String string3 = new Intent(string);
        string3.setPackage(context.getPackageName());
        return this.zzf(context, (Intent)string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final int zzf(Context var1_1, Intent var2_2) {
        var7_3 = var2_2;
        var6_4 = var1_1;
        var5_5 = this;
        var9_6 = var5_5.zzcnH;
        synchronized (var9_6) {
            var8_7 = (String)var5_5.zzcnH.get((Object)var7_3.getAction());
        }
        if (var8_7 != null) ** GOTO lbl40
        var9_6 = var6_4.getPackageManager().resolveService(var7_3, 0);
        if (var9_6 == null || var9_6.serviceInfo == null) {
            Log.e((String)"FirebaseInstanceId", (String)"Failed to resolve target intent service, skipping classname enforcement");
        } else {
            var10_9 = var9_6.serviceInfo;
            if (!var6_4.getPackageName().equals(var10_9.packageName) || var10_9.name == null) {
                var11_10 = String.valueOf(var10_9.packageName);
                var12_12 = String.valueOf(var10_9.name);
                Log.e((String)"FirebaseInstanceId", (String)new StringBuilder(94 + String.valueOf(var11_10).length() + String.valueOf(var12_12).length()).append("Error resolving target intent service, skipping classname enforcement. Resolved service was: ").append(var11_10).append("/").append(var12_12).toString());
            } else {
                var8_7 = var10_9.name;
                if (var8_7.startsWith(".")) {
                    v0 = String.valueOf(var6_4.getPackageName());
                    v1 = String.valueOf(var8_7);
                    v2 = v1.length() != 0 ? v0.concat(v1) : new String(v0);
                } else {
                    v2 = var8_7;
                }
                var8_7 = v2;
                var11_11 = var5_5.zzcnH;
                synchronized (var11_11) {
                    var5_5.zzcnH.put((Object)var7_3.getAction(), (Object)var8_7);
                }
lbl40:
                // 2 sources

                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    v3 = String.valueOf(var8_7);
                    Log.d((String)"FirebaseInstanceId", (String)(v3.length() != 0 ? "Restricting intent to a specific service: ".concat(v3) : new String("Restricting intent to a specific service: ")));
                }
                var7_3.setClassName(var6_4.getPackageName(), var8_7);
            }
        }
        try {
            var6_4 = var1_1;
            var5_5 = this;
            if (var5_5.zzcnI == null) {
                var5_5.zzcnI = var6_4.checkCallingOrSelfPermission("android.permission.WAKE_LOCK") == 0;
            }
            if (var5_5.zzcnI.booleanValue()) {
                var3_14 = WakefulBroadcastReceiver.startWakefulService((Context)var1_1, (Intent)var2_2);
            } else {
                var3_14 = var1_1.startService(var2_2);
                Log.d((String)"FirebaseInstanceId", (String)"Missing wake lock permission, service start may be delayed");
            }
            if (var3_14 == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Error while delivering the message: ServiceIntent not found.");
                return 404;
            }
            return -1;
        }
        catch (SecurityException var3_15) {
            Log.e((String)"FirebaseInstanceId", (String)"Error while delivering the message to the serviceIntent", (Throwable)var3_15);
            return 401;
        }
        catch (IllegalStateException var3_16) {
            var4_17 = String.valueOf(var3_16);
            Log.e((String)"FirebaseInstanceId", (String)new StringBuilder(45 + String.valueOf(var4_17).length()).append("Failed to start service while in background: ").append(var4_17).toString());
            return 402;
        }
    }
}

