/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceIdService;
import com.google.firebase.iid.zzj;
import com.google.firebase.iid.zzk;
import com.google.firebase.iid.zzq;
import com.google.firebase.iid.zzr;
import com.google.firebase.iid.zzs;
import java.io.IOException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class FirebaseInstanceId {
    private static Map<String, FirebaseInstanceId> zzbgQ = new ArrayMap();
    private static zzk zzckv;
    private final FirebaseApp zzckw;
    private final zzj zzckx;
    private final String zzcky;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static synchronized FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        FirebaseInstanceId firebaseInstanceId = zzbgQ.get(firebaseApp.getOptions().getApplicationId());
        if (firebaseInstanceId == null) {
            zzj zzj2 = zzj.zzb(firebaseApp.getApplicationContext(), null);
            if (zzckv == null) {
                zzckv = new zzk(zzj.zzJT());
            }
            firebaseInstanceId = new FirebaseInstanceId(firebaseApp, zzj2);
            zzbgQ.put(firebaseApp.getOptions().getApplicationId(), firebaseInstanceId);
        }
        return firebaseInstanceId;
    }

    private FirebaseInstanceId(FirebaseApp firebaseApp, zzj zzj2) {
        String string;
        String[] stringArray;
        String string2;
        this.zzckw = firebaseApp;
        this.zzckx = zzj2;
        FirebaseInstanceId firebaseInstanceId = this;
        String string3 = firebaseInstanceId.zzckw.getOptions().getGcmSenderId();
        Object object = string3 != null ? string3 : ((string2 = firebaseInstanceId.zzckw.getOptions().getApplicationId()).startsWith("1:") ? ((stringArray = string2.split(":")).length < 2 ? null : ((string = stringArray[1]).isEmpty() ? null : string)) : (this.zzcky = string2));
        if (this.zzcky == null) {
            throw new IllegalStateException("IID failing to initialize, FirebaseApp is missing project ID");
        }
        FirebaseInstanceIdService.zza(this.zzckw.getApplicationContext(), this);
    }

    public String getId() {
        return FirebaseInstanceId.zza(this.zzckx.zzvK());
    }

    public long getCreationTime() {
        return this.zzckx.getCreationTime();
    }

    public void deleteInstanceId() throws IOException {
        this.zzckx.zzb("*", "*", null);
        this.zzckx.zzvL();
    }

    @Nullable
    public String getToken() {
        zzs zzs2 = this.zzJQ();
        if (zzs2 == null || zzs2.zzhp(zzj.zzbgW)) {
            FirebaseInstanceIdService.zzbI(this.zzckw.getApplicationContext());
        }
        if (zzs2 != null) {
            return zzs2.zzbPJ;
        }
        return null;
    }

    @Nullable
    final zzs zzJQ() {
        return zzj.zzJT().zzp("", this.zzcky, "*");
    }

    final String zzJR() throws IOException {
        return this.getToken(this.zzcky, "*");
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        Bundle bundle = new Bundle();
        this.zzF(bundle);
        return this.zzckx.getToken(string, string2, bundle);
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        Bundle bundle = new Bundle();
        this.zzF(bundle);
        this.zzckx.zzb(string, string2, bundle);
    }

    public final void zzhf(String string) {
        zzckv.zzhf(string);
        FirebaseInstanceIdService.zzbI(this.zzckw.getApplicationContext());
    }

    static zzk zzJS() {
        return zzckv;
    }

    final void zzhg(String string) throws IOException {
        zzs zzs2 = this.zzJQ();
        if (zzs2 == null || zzs2.zzhp(zzj.zzbgW)) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        Bundle bundle2 = bundle;
        String string6 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        String string7 = zzs2.zzbPJ;
        FirebaseInstanceId firebaseInstanceId = this;
        firebaseInstanceId.zzF(bundle2);
        firebaseInstanceId.zzckx.zzc(string7, string6, bundle2);
    }

    final void zzhh(String string) throws IOException {
        zzs zzs2 = this.zzJQ();
        if (zzs2 == null || zzs2.zzhp(zzj.zzbgW)) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zzckx.zzb(zzs2.zzbPJ, string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    private final void zzF(Bundle bundle) {
        bundle.putString("gmp_app_id", this.zzckw.getOptions().getApplicationId());
    }

    static String zzj(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)11);
    }

    static String zza(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA1").digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)n;
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"FirebaseInstanceId", (String)"Unexpected error, device missing required alghorithms");
            return null;
        }
    }

    static int zzbF(Context context) {
        return FirebaseInstanceId.zzO(context, context.getPackageName());
    }

    static int zzO(Context context, String string) {
        try {
            return context.getPackageManager().getPackageInfo((String)string, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Failed to find package ").append(string2).toString());
            return 0;
        }
    }

    static String zzbb(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return null;
        }
    }

    static void zza(Context context, zzr zzr2) {
        zzr2.zzvP();
        Intent intent = new Intent();
        intent.putExtra("CMD", "RST");
        zzq.zzJX().zze(context, intent);
    }

    static void zzbG(Context context) {
        Intent intent = new Intent();
        intent.putExtra("CMD", "SYNC");
        zzq.zzJX().zze(context, intent);
    }
}

