/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.zzac;
import com.google.firebase.iid.zzad;
import com.google.firebase.iid.zzi;
import com.google.firebase.iid.zzj;
import java.io.IOException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FirebaseInstanceId {
    private static final long zznuj = TimeUnit.HOURS.toSeconds(8L);
    private static Map<String, FirebaseInstanceId> zzicu = new ArrayMap();
    private static zzj zznuk;
    private static ScheduledThreadPoolExecutor zznul;
    private final FirebaseApp zzmfu;
    private final zzi zznum;
    private final String zznun;
    private boolean zznuo = false;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static synchronized FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        FirebaseInstanceId firebaseInstanceId = zzicu.get(firebaseApp.getOptions().getApplicationId());
        if (firebaseInstanceId == null) {
            zzi zzi2 = zzi.zza(firebaseApp.getApplicationContext(), null);
            if (zznuk == null) {
                zznuk = new zzj(zzi.zzchc());
            }
            firebaseInstanceId = new FirebaseInstanceId(firebaseApp, zzi2);
            zzicu.put(firebaseApp.getOptions().getApplicationId(), firebaseInstanceId);
        }
        return firebaseInstanceId;
    }

    private FirebaseInstanceId(FirebaseApp firebaseApp, zzi zzi2) {
        String string;
        String[] stringArray;
        String string2;
        this.zzmfu = firebaseApp;
        this.zznum = zzi2;
        FirebaseInstanceId firebaseInstanceId = this;
        String string3 = firebaseInstanceId.zzmfu.getOptions().getGcmSenderId();
        Object object = string3 != null ? string3 : ((string2 = firebaseInstanceId.zzmfu.getOptions().getApplicationId()).startsWith("1:") ? ((stringArray = string2.split(":")).length < 2 ? null : ((string = stringArray[1]).isEmpty() ? null : string)) : (this.zznun = string2));
        if (this.zznun == null) {
            throw new IllegalStateException("IID failing to initialize, FirebaseApp is missing project ID");
        }
        zzac zzac2 = this.zzcgy();
        if (zzac2 == null || zzac2.zzqz(zzi.zzida) || zznuk.zzchg() != null) {
            this.startSync();
        }
    }

    final FirebaseApp getApp() {
        return this.zzmfu;
    }

    final synchronized void zzco(boolean bl) {
        this.zznuo = bl;
    }

    final synchronized void startSync() {
        if (!this.zznuo) {
            this.zzcb(0L);
        }
    }

    final synchronized void zzcb(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zznuj);
        FirebaseInstanceId.zzb(new zzad(this, l2), l);
        this.zznuo = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zzb(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zznul == null) {
                zznul = new ScheduledThreadPoolExecutor(1);
            }
            zznul.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    public String getId() {
        return FirebaseInstanceId.zza(this.zznum.zzaut());
    }

    public long getCreationTime() {
        return this.zznum.getCreationTime();
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        this.zznum.zza("*", "*", null);
        this.zznum.zzauu();
    }

    @Nullable
    public String getToken() {
        zzac zzac2 = this.zzcgy();
        if (zzac2 == null || zzac2.zzqz(zzi.zzida)) {
            this.startSync();
        }
        if (zzac2 != null) {
            return zzac2.zzlax;
        }
        return null;
    }

    @Nullable
    final zzac zzcgy() {
        return zzi.zzchc().zzo("", this.zznun, "*");
    }

    final String zzcgz() throws IOException {
        return this.getToken(this.zznun, "*");
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        Bundle bundle = new Bundle();
        this.zzac(bundle);
        return this.zznum.getToken(string, string2, bundle);
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        Bundle bundle = new Bundle();
        this.zzac(bundle);
        this.zznum.zza(string, string2, bundle);
    }

    public final synchronized void zzqq(String string) {
        zznuk.zzqq(string);
        this.startSync();
    }

    static zzj zzcha() {
        return zznuk;
    }

    final void zzqr(String string) throws IOException {
        zzac zzac2 = this.zzcgy();
        if (zzac2 == null || zzac2.zzqz(zzi.zzida)) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        Bundle bundle2 = bundle;
        String string6 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        String string7 = zzac2.zzlax;
        FirebaseInstanceId firebaseInstanceId = this;
        firebaseInstanceId.zzac(bundle2);
        firebaseInstanceId.zznum.zzb(string7, string6, bundle2);
    }

    final void zzqs(String string) throws IOException {
        zzac zzac2 = this.zzcgy();
        if (zzac2 == null || zzac2.zzqz(zzi.zzida)) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zznum.zza(zzac2.zzlax, string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    private final void zzac(Bundle bundle) {
        bundle.putString("gmp_app_id", this.zzmfu.getOptions().getApplicationId());
    }

    static String zzn(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)11);
    }

    static String zza(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA1").digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)n;
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"FirebaseInstanceId", (String)"Unexpected error, device missing required algorithms");
            return null;
        }
    }

    static int zzes(Context context) {
        return FirebaseInstanceId.zzam(context, context.getPackageName());
    }

    static int zzam(Context context, String string) {
        try {
            return context.getPackageManager().getPackageInfo((String)string, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Failed to find package ").append(string2).toString());
            return 0;
        }
    }

    static String zzdk(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return null;
        }
    }

    static boolean zzchb() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }
}

