/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.util.zzv;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zza;
import com.google.firebase.iid.zzac;
import com.google.firebase.iid.zzi;
import java.io.File;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

final class zzab {
    final SharedPreferences zzids;
    private Context zzaif;

    public zzab(Context context) {
        this(context, "com.google.android.gms.appid");
    }

    private zzab(Context context, String string) {
        block4: {
            this.zzaif = context;
            this.zzids = context.getSharedPreferences(string, 0);
            String string2 = String.valueOf(string);
            String string3 = String.valueOf("-no-backup");
            String string4 = string3.length() != 0 ? string2.concat(string3) : new String(string2);
            zzab zzab2 = this;
            File file = zzv.getNoBackupFilesDir((Context)zzab2.zzaif);
            File file2 = new File(file, string4);
            if (!file2.exists()) {
                try {
                    if (file2.createNewFile() && !zzab2.isEmpty()) {
                        Log.i((String)"InstanceID/Store", (String)"App restored, clearing state");
                        zzab2.zzauy();
                        zzi.zza(zzab2.zzaif, null).zzche();
                    }
                    return;
                }
                catch (IOException iOException) {
                    if (!Log.isLoggable((String)"InstanceID/Store", (int)3)) break block4;
                    String string5 = String.valueOf(iOException.getMessage());
                    Log.d((String)"InstanceID/Store", (String)(string5.length() != 0 ? "Error creating file in no backup dir: ".concat(string5) : new String("Error creating file in no backup dir: ")));
                }
            }
        }
    }

    public final synchronized long zzqu(String string) {
        String string2 = zzab.zzbm(string, "cre");
        String string3 = this.zzids.getString(string2, null);
        if (string3 != null) {
            try {
                return Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0L;
    }

    public final synchronized boolean isEmpty() {
        return this.zzids.getAll().isEmpty();
    }

    private static String zzn(String string, String string2, String string3) {
        String string4 = "|T|";
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string4).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string4).append(string2).append("|").append(string3).toString();
    }

    private static String zzbm(String string, String string2) {
        String string3 = "|S|";
        return new StringBuilder(String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string).append(string3).append(string2).toString();
    }

    private final void zzhu(String string) {
        SharedPreferences.Editor editor = this.zzids.edit();
        for (String string2 : this.zzids.getAll().keySet()) {
            if (!string2.startsWith(string)) continue;
            editor.remove(string2);
        }
        editor.commit();
    }

    public final synchronized void zzauy() {
        this.zzids.edit().clear().commit();
    }

    public final synchronized zzac zzo(String string, String string2, String string3) {
        return zzac.zzqy(this.zzids.getString(zzab.zzn(string, string2, string3), null));
    }

    public final synchronized void zza(String string, String string2, String string3, String string4, String string5) {
        String string6 = zzac.zzc(string4, string5, System.currentTimeMillis());
        if (string6 == null) {
            return;
        }
        SharedPreferences.Editor editor = this.zzids.edit();
        editor.putString(zzab.zzn(string, string2, string3), string6);
        editor.commit();
    }

    public final synchronized void zzf(String string, String string2, String string3) {
        String string4 = zzab.zzn(string, string2, string3);
        SharedPreferences.Editor editor = this.zzids.edit();
        editor.remove(string4);
        editor.commit();
    }

    final synchronized KeyPair zzqv(String string) {
        KeyPair keyPair = zza.zzaur();
        long l = System.currentTimeMillis();
        SharedPreferences.Editor editor = this.zzids.edit();
        editor.putString(zzab.zzbm(string, "|P|"), FirebaseInstanceId.zzn(keyPair.getPublic().getEncoded()));
        editor.putString(zzab.zzbm(string, "|K|"), FirebaseInstanceId.zzn(keyPair.getPrivate().getEncoded()));
        editor.putString(zzab.zzbm(string, "cre"), Long.toString(l));
        editor.commit();
        return keyPair;
    }

    final synchronized void zzqw(String string) {
        this.zzhu(String.valueOf(string).concat("|"));
    }

    public final synchronized void zzhv(String string) {
        this.zzhu(String.valueOf(string).concat("|T|"));
    }

    public final synchronized KeyPair zzqx(String string) {
        String string2 = this.zzids.getString(zzab.zzbm(string, "|P|"), null);
        String string3 = this.zzids.getString(zzab.zzbm(string, "|K|"), null);
        if (string2 == null || string3 == null) {
            return null;
        }
        try {
            byte[] byArray = Base64.decode((String)string2, (int)8);
            byte[] byArray2 = Base64.decode((String)string3, (int)8);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            String string4 = String.valueOf(generalSecurityException);
            Log.w((String)"InstanceID/Store", (String)new StringBuilder(19 + String.valueOf(string4).length()).append("Invalid key stored ").append(string4).toString());
            zzi.zza(this.zzaif, null).zzche();
            return null;
        }
    }
}

