/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.iid.MessengerCompat;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzi;
import com.google.firebase.iid.zzk;
import com.google.firebase.iid.zzu;
import com.google.firebase.iid.zzx;
import com.google.firebase.iid.zzy;
import com.google.firebase.iid.zzz;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.util.List;
import java.util.concurrent.ExecutionException;

public final class zzw {
    private static int zznvi = 0;
    private static int zzidh = 0;
    private static PendingIntent zziab;
    private static int zznvj;
    private static long zzidq;
    private final SimpleArrayMap<String, zzz> zznvk = new SimpleArrayMap();
    private Context zzaif;
    private Messenger zziaf;
    private Messenger zzidk;
    private MessengerCompat zzidl;

    public zzw(Context context) {
        this.zzaif = context.getApplicationContext();
        this.zziaf = new Messenger((Handler)new zzx(this, Looper.getMainLooper()));
    }

    public static boolean zzeu(Context context) {
        return zzw.zzev(context) != 0;
    }

    @VisibleForTesting
    private static synchronized int zzev(Context context) {
        List list;
        Intent intent;
        if (zznvi != 0) {
            return zznvi;
        }
        PackageManager packageManager = context.getPackageManager();
        if (packageManager.checkPermission("com.google.android.c2dm.permission.SEND", "com.google.android.gms") == -1) {
            Log.e((String)"FirebaseInstanceId", (String)"Google Play services missing or without correct permission.");
            return 0;
        }
        if (!zzq.isAtLeastO()) {
            intent = new Intent("com.google.android.c2dm.intent.REGISTER");
            intent.setPackage("com.google.android.gms");
            list = packageManager.queryIntentServices(intent, 0);
            if (list != null && list.size() > 0) {
                zznvi = 1;
                return 1;
            }
        }
        intent = new Intent("com.google.iid.TOKEN_REQUEST");
        intent.setPackage("com.google.android.gms");
        list = packageManager.queryBroadcastReceivers(intent, 0);
        if (list != null && list.size() > 0) {
            zznvi = 2;
            return 2;
        }
        Log.w((String)"FirebaseInstanceId", (String)"Failed to resolve IID implementation package, falling back");
        zznvi = zzq.isAtLeastO() ? 2 : 1;
        return zznvi;
    }

    private static String zza(KeyPair keyPair, String ... stringArray) {
        byte[] byArray;
        try {
            byArray = TextUtils.join((CharSequence)"\n", (Object[])stringArray).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"FirebaseInstanceId", (String)"Unable to encode string", (Throwable)unsupportedEncodingException);
            return null;
        }
        try {
            PrivateKey privateKey = keyPair.getPrivate();
            Signature signature = Signature.getInstance(privateKey instanceof RSAPrivateKey ? "SHA256withRSA" : "SHA256withECDSA");
            signature.initSign(privateKey);
            signature.update(byArray);
            return FirebaseInstanceId.zzn(signature.sign());
        }
        catch (GeneralSecurityException generalSecurityException) {
            Log.e((String)"FirebaseInstanceId", (String)"Unable to sign registration request", (Throwable)generalSecurityException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    final void zzc(Message var1_1) {
        block28: {
            block29: {
                if (var1_1 == null) {
                    return;
                }
                if (!(var1_1.obj instanceof Intent)) break block28;
                var2_2 = (Intent)var1_1.obj;
                var2_2.setExtrasClassLoader(MessengerCompat.class.getClassLoader());
                if (var2_2.hasExtra("google.messenger")) {
                    var3_3 = var2_2.getParcelableExtra("google.messenger");
                    if (var3_3 instanceof MessengerCompat) {
                        this.zzidl = (MessengerCompat)var3_3;
                    }
                    if (var3_3 instanceof Messenger) {
                        this.zzidk = (Messenger)var3_3;
                    }
                }
                var5_4 = (Intent)var1_1.obj;
                var4_5 = this;
                if (var5_4 == null) {
                    if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                        Log.d((String)"FirebaseInstanceId", (String)"Unexpected response: null");
                    }
                    return;
                }
                var6_6 = var5_4.getAction();
                if (!"com.google.android.c2dm.intent.REGISTRATION".equals(var6_6)) {
                    if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                        v0 = String.valueOf(var5_4.getAction());
                        Log.d((String)"FirebaseInstanceId", (String)(v0.length() != 0 ? "Unexpected response ".concat(v0) : new String("Unexpected response ")));
                    }
                    return;
                }
                var7_7 = var5_4.getStringExtra("registration_id");
                if (var7_7 == null) {
                    var7_7 = var5_4.getStringExtra("unregistered");
                }
                if (var7_7 == null) {
                    var11_8 = var5_4;
                    var10_9 = var4_5;
                    var12_10 = var11_8.getStringExtra("error");
                    if (var12_10 == null) {
                        var13_11 = String.valueOf(var11_8.getExtras());
                        Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(49 + String.valueOf(var13_11).length()).append("Unexpected response, no error or registration id ").append(var13_11).toString());
                        return;
                    }
                    if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                        v1 = String.valueOf(var12_10);
                        Log.d((String)"FirebaseInstanceId", (String)(v1.length() != 0 ? "Received InstanceID error ".concat(v1) : new String("Received InstanceID error ")));
                    }
                    var13_12 = null;
                    if (var12_10.startsWith("|")) {
                        var14_13 = var12_10.split("\\|");
                        if (!"ID".equals(var14_13[1])) {
                            v2 = String.valueOf(var12_10);
                            Log.w((String)"FirebaseInstanceId", (String)(v2.length() != 0 ? "Unexpected structured response ".concat(v2) : new String("Unexpected structured response ")));
                        }
                        if (var14_13.length > 2) {
                            var13_12 = var14_13[2];
                            var12_10 = var14_13[3];
                            if (var12_10.startsWith(":")) {
                                var12_10 = var12_10.substring(1);
                            }
                        } else {
                            var12_10 = "UNKNOWN";
                        }
                        var11_8.putExtra("error", var12_10);
                    }
                    var10_9.zzbl(var13_12, var12_10);
                    var14_14 = var11_8.getLongExtra("Retry-After", 0L);
                    if (var14_14 > 0L) {
                        zzw.zznvj = (int)var14_14 * 1000;
                        zzw.zzidq = SystemClock.elapsedRealtime() + (long)zzw.zznvj;
                        var16_15 = zzw.zznvj;
                        Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(52).append("Explicit request from server to backoff: ").append(var16_15).toString());
                    }
                    return;
                }
                zzw.zzidq = 0L;
                zzw.zznvj = 0;
                var8_16 = null;
                if (!var7_7.startsWith("|")) ** GOTO lbl90
                var9_17 = var7_7.split("\\|");
                if (!"ID".equals(var9_17[1])) {
                    v3 = String.valueOf(var7_7);
                    Log.w((String)"FirebaseInstanceId", (String)(v3.length() != 0 ? "Unexpected structured response ".concat(v3) : new String("Unexpected structured response ")));
                }
                var8_16 = var9_17[2];
                if (var9_17.length <= 4) ** GOTO lbl-1000
                if (!"SYNC".equals(var9_17[3])) break block29;
                zzi.zza(var4_5.zzaif, null).zzchf();
                ** GOTO lbl-1000
            }
            if ("RST".equals(var9_17[3])) {
                zzi.zza(var4_5.zzaif, null).zzchd();
                var5_4.removeExtra("registration_id");
            } else lbl-1000:
            // 3 sources

            {
                if ((var7_7 = var9_17[var9_17.length - 1]).startsWith(":")) {
                    var7_7 = var7_7.substring(1);
                }
                var5_4.putExtra("registration_id", var7_7);
lbl90:
                // 2 sources

                if (var8_16 == null) {
                    if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                        Log.d((String)"FirebaseInstanceId", (String)"Ignoring response without a request ID");
                    }
                    return;
                }
            }
            var19_18 = var5_4.getExtras();
            var18_19 = var8_16;
            var17_20 = var4_5;
            var20_21 = var17_20.zznvk;
            synchronized (var20_21) {
                var21_22 = (zzz)var17_20.zznvk.remove((Object)var18_19);
                if (var21_22 == null) {
                    v4 = String.valueOf(var18_19);
                    Log.w((String)"FirebaseInstanceId", (String)(v4.length() != 0 ? "Missing callback for ".concat(v4) : new String("Missing callback for ")));
                    return;
                }
                var21_22.zzag(var19_18);
                return;
            }
        }
        Log.w((String)"FirebaseInstanceId", (String)"Dropping invalid message");
    }

    public static synchronized void zzc(Context context, Intent intent) {
        if (zziab == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            zziab = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)zziab);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzbl(String string, String string2) {
        SimpleArrayMap<String, zzz> simpleArrayMap = this.zznvk;
        synchronized (simpleArrayMap) {
            if (string == null) {
                for (int i = 0; i < this.zznvk.size(); ++i) {
                    ((zzz)this.zznvk.valueAt(i)).onError(string2);
                }
                this.zznvk.clear();
            } else {
                zzz zzz2 = (zzz)this.zznvk.remove((Object)string);
                if (zzz2 == null) {
                    String string3 = String.valueOf(string);
                    Log.w((String)"FirebaseInstanceId", (String)(string3.length() != 0 ? "Missing callback for ".concat(string3) : new String("Missing callback for ")));
                    return;
                }
                zzz2.onError(string2);
            }
            return;
        }
    }

    final Bundle zzc(Bundle bundle, KeyPair keyPair) throws IOException {
        int n;
        int n2 = n = FirebaseInstanceId.zzam(this.zzaif, "com.google.android.gms");
        KeyPair keyPair2 = keyPair;
        Bundle bundle2 = bundle;
        zzw zzw2 = this;
        bundle2.putString("gmsv", Integer.toString(n2));
        bundle2.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle2.putString("app_ver", Integer.toString(FirebaseInstanceId.zzes(zzw2.zzaif)));
        bundle2.putString("app_ver_name", FirebaseInstanceId.zzdk(zzw2.zzaif));
        bundle2.putString("cliv", "fiid-11717000");
        bundle2.putString("appid", FirebaseInstanceId.zza(keyPair2));
        String string = FirebaseInstanceId.zzn(keyPair2.getPublic().getEncoded());
        bundle2.putString("pub2", string);
        bundle2.putString("sig", zzw.zza(keyPair2, zzw2.zzaif.getPackageName(), string));
        if (n >= 12000000) {
            Task<Bundle> task = zzk.zzet(this.zzaif).zzi(1, bundle);
            try {
                return (Bundle)Tasks.await(task);
            }
            catch (InterruptedException | ExecutionException exception) {
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    String string2 = String.valueOf(exception);
                    Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(22 + String.valueOf(string2).length()).append("Error making request: ").append(string2).toString());
                }
                if (exception.getCause() instanceof zzu && ((zzu)exception.getCause()).getErrorCode() == 4) {
                    return this.zzae(bundle);
                }
                return null;
            }
        }
        return this.zzae(bundle);
    }

    private final Bundle zzae(Bundle bundle) throws IOException {
        Bundle bundle2 = this.zzaf(bundle);
        if (bundle2 != null && bundle2.containsKey("google.messenger") && (bundle2 = this.zzaf(bundle)) != null && bundle2.containsKey("google.messenger")) {
            bundle2 = null;
        }
        return bundle2;
    }

    private static synchronized String zzaux() {
        return Integer.toString(zzidh++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle zzaf(Bundle bundle) throws IOException {
        Bundle bundle2;
        zzy zzy2;
        String string;
        block24: {
            zzw zzw2;
            Intent intent;
            block25: {
                String string2;
                string = zzw.zzaux();
                zzy2 = new zzy(null);
                bundle2 = this.zznvk;
                synchronized (bundle2) {
                    this.zznvk.put((Object)string, (Object)zzy2);
                }
                String string3 = string;
                Bundle bundle3 = bundle;
                zzw zzw3 = this;
                long l = SystemClock.elapsedRealtime();
                if (zzidq != 0L && l <= zzidq) {
                    long l2 = zzidq - l;
                    int n = zznvj;
                    Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(78).append("Backoff mode, next request attempt: ").append(l2).append(" interval: ").append(n).toString());
                    throw new IOException("RETRY_LATER");
                }
                if (zzw.zzev(zzw3.zzaif) == 0) {
                    throw new IOException("MISSING_INSTANCEID_SERVICE");
                }
                Intent intent2 = new Intent();
                intent2.setPackage("com.google.android.gms");
                if (zzw.zzev(zzw3.zzaif) == 2) {
                    intent2.setAction("com.google.iid.TOKEN_REQUEST");
                } else {
                    intent2.setAction("com.google.android.c2dm.intent.REGISTER");
                }
                intent2.putExtras(bundle3);
                zzw.zzc(zzw3.zzaif, intent2);
                String string4 = string3;
                intent = intent2;
                zzw2 = zzw3;
                intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string4).length()).append("|ID|").append(string4).append("|").toString());
                intent.putExtra("X-kid", new StringBuilder(5 + String.valueOf(string4).length()).append("|ID|").append(string4).append("|").toString());
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    string2 = String.valueOf(intent.getExtras());
                    Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
                }
                intent.putExtra("google.messenger", (Parcelable)zzw2.zziaf);
                if (zzw2.zzidk != null || zzw2.zzidl != null) {
                    string2 = Message.obtain();
                    Message.obtain().obj = intent;
                    try {
                        if (zzw2.zzidk != null) {
                            zzw2.zzidk.send((Message)string2);
                        } else {
                            zzw2.zzidl.send((Message)string2);
                        }
                        break block24;
                    }
                    catch (RemoteException remoteException) {
                        if (!Log.isLoggable((String)"FirebaseInstanceId", (int)3)) break block25;
                        Log.d((String)"FirebaseInstanceId", (String)"Messenger failed, fallback to startService");
                    }
                }
            }
            if (zzw.zzev(zzw2.zzaif) == 2) {
                zzw2.zzaif.sendBroadcast(intent);
            } else {
                zzw2.zzaif.startService(intent);
            }
        }
        try {
            bundle2 = zzy2.zzchm();
            return bundle2;
        }
        finally {
            SimpleArrayMap<String, zzz> simpleArrayMap = this.zznvk;
            synchronized (simpleArrayMap) {
                this.zznvk.remove((Object)string);
            }
        }
    }
}

