/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.zzac;
import com.google.firebase.iid.zzad;
import com.google.firebase.iid.zzi;
import com.google.firebase.iid.zzj;
import java.io.IOException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FirebaseInstanceId {
    private static final long zznts = TimeUnit.HOURS.toSeconds(8L);
    private static Map<String, FirebaseInstanceId> zzick = new ArrayMap();
    private static zzj zzntt;
    private static ScheduledThreadPoolExecutor zzntu;
    private final FirebaseApp zzmfl;
    private final zzi zzntv;
    private final String zzntw;
    private boolean zzntx = false;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static synchronized FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        FirebaseInstanceId firebaseInstanceId = zzick.get(firebaseApp.getOptions().getApplicationId());
        if (firebaseInstanceId == null) {
            zzi zzi2 = zzi.zza(firebaseApp.getApplicationContext(), null);
            if (zzntt == null) {
                zzntt = new zzj(zzi.zzcha());
            }
            firebaseInstanceId = new FirebaseInstanceId(firebaseApp, zzi2);
            zzick.put(firebaseApp.getOptions().getApplicationId(), firebaseInstanceId);
        }
        return firebaseInstanceId;
    }

    private FirebaseInstanceId(FirebaseApp firebaseApp, zzi zzi2) {
        String string;
        String[] stringArray;
        String string2;
        this.zzmfl = firebaseApp;
        this.zzntv = zzi2;
        FirebaseInstanceId firebaseInstanceId = this;
        String string3 = firebaseInstanceId.zzmfl.getOptions().getGcmSenderId();
        Object object = string3 != null ? string3 : ((string2 = firebaseInstanceId.zzmfl.getOptions().getApplicationId()).startsWith("1:") ? ((stringArray = string2.split(":")).length < 2 ? null : ((string = stringArray[1]).isEmpty() ? null : string)) : (this.zzntw = string2));
        if (this.zzntw == null) {
            throw new IllegalStateException("IID failing to initialize, FirebaseApp is missing project ID");
        }
        zzac zzac2 = this.zzcgw();
        if (zzac2 == null || zzac2.zzqy(zzi.zzicq) || zzntt.zzche() != null) {
            this.startSync();
        }
    }

    final FirebaseApp getApp() {
        return this.zzmfl;
    }

    final synchronized void zzco(boolean bl) {
        this.zzntx = bl;
    }

    final synchronized void startSync() {
        if (!this.zzntx) {
            this.zzcb(0L);
        }
    }

    final synchronized void zzcb(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zznts);
        FirebaseInstanceId.zzb(new zzad(this, l2), l);
        this.zzntx = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zzb(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzntu == null) {
                zzntu = new ScheduledThreadPoolExecutor(1);
            }
            zzntu.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    public String getId() {
        return FirebaseInstanceId.zza(this.zzntv.zzaus());
    }

    public long getCreationTime() {
        return this.zzntv.getCreationTime();
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        this.zzntv.zza("*", "*", null);
        this.zzntv.zzaut();
    }

    @Nullable
    public String getToken() {
        zzac zzac2 = this.zzcgw();
        if (zzac2 == null || zzac2.zzqy(zzi.zzicq)) {
            this.startSync();
        }
        if (zzac2 != null) {
            return zzac2.zzlan;
        }
        return null;
    }

    @Nullable
    final zzac zzcgw() {
        return zzi.zzcha().zzo("", this.zzntw, "*");
    }

    final String zzcgx() throws IOException {
        return this.getToken(this.zzntw, "*");
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        Bundle bundle = new Bundle();
        this.zzac(bundle);
        return this.zzntv.getToken(string, string2, bundle);
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        Bundle bundle = new Bundle();
        this.zzac(bundle);
        this.zzntv.zza(string, string2, bundle);
    }

    public final synchronized void zzqp(String string) {
        zzntt.zzqp(string);
        this.startSync();
    }

    static zzj zzcgy() {
        return zzntt;
    }

    final void zzqq(String string) throws IOException {
        zzac zzac2 = this.zzcgw();
        if (zzac2 == null || zzac2.zzqy(zzi.zzicq)) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        Bundle bundle2 = bundle;
        String string6 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        String string7 = zzac2.zzlan;
        FirebaseInstanceId firebaseInstanceId = this;
        firebaseInstanceId.zzac(bundle2);
        firebaseInstanceId.zzntv.zzb(string7, string6, bundle2);
    }

    final void zzqr(String string) throws IOException {
        zzac zzac2 = this.zzcgw();
        if (zzac2 == null || zzac2.zzqy(zzi.zzicq)) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zzntv.zza(zzac2.zzlan, string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    private final void zzac(Bundle bundle) {
        bundle.putString("gmp_app_id", this.zzmfl.getOptions().getApplicationId());
    }

    static String zzn(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)11);
    }

    static String zza(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA1").digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)n;
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"FirebaseInstanceId", (String)"Unexpected error, device missing required algorithms");
            return null;
        }
    }

    static int zzes(Context context) {
        return FirebaseInstanceId.zzam(context, context.getPackageName());
    }

    static int zzam(Context context, String string) {
        try {
            return context.getPackageManager().getPackageInfo((String)string, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Failed to find package ").append(string2).toString());
            return 0;
        }
    }

    static String zzdk(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return null;
        }
    }

    static boolean zzcgz() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }
}

