/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.stats.zza;
import com.google.firebase.iid.zzd;
import com.google.firebase.iid.zzf;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public final class zzh
implements ServiceConnection {
    private final Context zzaif;
    private final Intent zzicf;
    private final ScheduledExecutorService zzicg;
    private final Queue<zzd> zzich = new LinkedList<zzd>();
    private zzf zzntr;
    private boolean zzicj = false;

    public zzh(Context context, String string) {
        this(context, string, new ScheduledThreadPoolExecutor(0));
    }

    @VisibleForTesting
    private zzh(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
        this.zzaif = context.getApplicationContext();
        this.zzicf = new Intent(string).setPackage(this.zzaif.getPackageName());
        this.zzicg = scheduledExecutorService;
    }

    public final synchronized void zza(Intent intent, BroadcastReceiver.PendingResult pendingResult) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"new intent queued in the bind-strategy delivery");
        }
        this.zzich.add(new zzd(intent, pendingResult, this.zzicg));
        this.zzaur();
    }

    private final synchronized void zzaur() {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"flush queue called");
        }
        while (!this.zzich.isEmpty()) {
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                Log.d((String)"EnhancedIntentService", (String)"found intent to be delivered");
            }
            if (this.zzntr != null && this.zzntr.isBinderAlive()) {
                if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                    Log.d((String)"EnhancedIntentService", (String)"binder is alive, sending the intent.");
                }
                zzd zzd2 = this.zzich.poll();
                this.zzntr.zza(zzd2);
                continue;
            }
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                boolean bl = !this.zzicj;
                Log.d((String)"EnhancedIntentService", (String)new StringBuilder(39).append("binder is dead. start connection? ").append(bl).toString());
            }
            if (!this.zzicj) {
                this.zzicj = true;
                try {
                    if (zza.zzalq().zza(this.zzaif, this.zzicf, (ServiceConnection)this, 65)) {
                        return;
                    }
                    Log.e((String)"EnhancedIntentService", (String)"binding to the service failed");
                }
                catch (SecurityException securityException) {
                    Log.e((String)"EnhancedIntentService", (String)"Exception while binding the service", (Throwable)securityException);
                }
                while (!this.zzich.isEmpty()) {
                    this.zzich.poll().finish();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzh zzh2 = this;
        synchronized (zzh2) {
            this.zzicj = false;
            this.zzntr = (zzf)iBinder;
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                String string = String.valueOf(componentName);
                Log.d((String)"EnhancedIntentService", (String)new StringBuilder(20 + String.valueOf(string).length()).append("onServiceConnected: ").append(string).toString());
            }
            this.zzaur();
            return;
        }
    }

    public final void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            String string = String.valueOf(componentName);
            Log.d((String)"EnhancedIntentService", (String)new StringBuilder(23 + String.valueOf(string).length()).append("onServiceDisconnected: ").append(string).toString());
        }
        this.zzaur();
    }
}

