/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.stats.zza;
import com.google.firebase.iid.zzk;
import com.google.firebase.iid.zzl;
import com.google.firebase.iid.zzn;
import com.google.firebase.iid.zzo;
import com.google.firebase.iid.zzp;
import com.google.firebase.iid.zzr;
import com.google.firebase.iid.zzt;
import com.google.firebase.iid.zzu;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

final class zzm
implements ServiceConnection {
    int state = 0;
    final Messenger zznuh = new Messenger(new Handler(Looper.getMainLooper(), (Handler.Callback)new zzn(this)));
    zzr zznui;
    final Queue<zzt<?>> zznuj = new LinkedList();
    final SparseArray<zzt<?>> zznuk = new SparseArray();
    final /* synthetic */ zzk zznul;

    private zzm(zzk zzk2) {
        this.zznul = zzk2;
    }

    final synchronized boolean zzb(zzt zzt2) {
        switch (this.state) {
            case 0: {
                this.zznuj.add(zzt2);
                zzm zzm2 = this;
                zzbq.checkState((zzm2.state == 0 ? 1 : 0) != 0);
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
                }
                zzm2.state = 1;
                Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
                intent.setPackage("com.google.android.gms");
                if (!zza.zzalq().zza(zzk.zza(zzm2.zznul), intent, (ServiceConnection)zzm2, 1)) {
                    zzm2.zzm(0, "Unable to bind to service");
                } else {
                    zzk.zzb(zzm2.zznul).schedule(new zzo(zzm2), 30L, TimeUnit.SECONDS);
                }
                return true;
            }
            case 1: {
                this.zznuj.add(zzt2);
                return true;
            }
            case 2: {
                this.zznuj.add(zzt2);
                this.zzchg();
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        int n = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zzd(Message message) {
        zzt zzt2;
        int n = message.arg1;
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            Log.d((String)"MessengerIpcClient", (String)new StringBuilder(41).append("Received response to request: ").append(n).toString());
        }
        zzm zzm2 = this;
        synchronized (zzm2) {
            zzt2 = (zzt)this.zznuk.get(n);
            if (zzt2 == null) {
                Log.w((String)"MessengerIpcClient", (String)new StringBuilder(50).append("Received response for unknown request: ").append(n).toString());
                return true;
            }
            this.zznuk.remove(n);
            this.zzchh();
        }
        Bundle bundle = message.getData();
        zzt zzt3 = zzt2;
        if (bundle.getBoolean("unsupported", false)) {
            zzt3.zzb(new zzu(4, "Not supported by GmsCore"));
        } else {
            zzt3.zzad(bundle);
        }
        return true;
    }

    public final synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service connected");
        }
        if (iBinder == null) {
            this.zzm(0, "Null service connection");
            return;
        }
        try {
            this.zznui = new zzr(iBinder);
        }
        catch (RemoteException remoteException) {
            this.zzm(0, remoteException.getMessage());
            return;
        }
        this.state = 2;
        this.zzchg();
    }

    private final void zzchg() {
        zzk.zzb(this.zznul).execute(new zzp(this));
    }

    public final synchronized void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
        }
        this.zzm(2, "Service disconnected");
    }

    final synchronized void zzm(int n, String string) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"MessengerIpcClient", (String)(string2.length() != 0 ? "Disconnected: ".concat(string2) : new String("Disconnected: ")));
        }
        switch (this.state) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: 
            case 2: {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                }
                this.state = 4;
                zza.zzalq();
                zzm zzm2 = this;
                Context context = zzk.zza(this.zznul);
                context.unbindService((ServiceConnection)zzm2);
                this.zza(new zzu(n, string));
                return;
            }
            case 3: {
                this.state = 4;
                return;
            }
            case 4: {
                return;
            }
        }
        int n2 = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n2).toString());
    }

    private final void zza(zzu zzu2) {
        Iterator iterator = this.zznuj.iterator();
        while (iterator.hasNext()) {
            ((zzt)iterator.next()).zzb(zzu2);
        }
        this.zznuj.clear();
        for (int i = 0; i < this.zznuk.size(); ++i) {
            ((zzt)this.zznuk.valueAt(i)).zzb(zzu2);
        }
        this.zznuk.clear();
    }

    final synchronized void zzchh() {
        if (this.state == 2 && this.zznuj.isEmpty() && this.zznuk.size() == 0) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
            }
            this.state = 3;
            zza.zzalq();
            zzm zzm2 = this;
            Context context = zzk.zza(this.zznul);
            context.unbindService((ServiceConnection)zzm2);
        }
    }

    final synchronized void zzchi() {
        if (this.state == 1) {
            this.zzm(1, "Timed out while binding");
        }
    }

    final synchronized void zzht(int n) {
        zzt zzt2 = (zzt)this.zznuk.get(n);
        if (zzt2 != null) {
            Log.w((String)"MessengerIpcClient", (String)new StringBuilder(31).append("Timing out request: ").append(n).toString());
            this.zznuk.remove(n);
            zzt2.zzb(new zzu(3, "Timed out waiting for response"));
            this.zzchh();
        }
    }

    /* synthetic */ zzm(zzk zzk2, zzl zzl2) {
        this(zzk2);
    }
}

