/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.zzaa;
import com.google.firebase.iid.zzu;
import com.google.firebase.iid.zzv;
import com.google.firebase.iid.zzy;
import com.google.firebase.iid.zzz;
import java.io.IOException;
import java.security.KeyPair;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FirebaseInstanceId {
    private static final long zznyp = TimeUnit.HOURS.toSeconds(8L);
    private static Map<String, FirebaseInstanceId> zzifg = new ArrayMap();
    private static zzy zznyq;
    private static ScheduledThreadPoolExecutor zznyr;
    private final FirebaseApp zzmki;
    private final zzu zznys;
    private final zzv zznyt;
    private KeyPair zzifj;
    private boolean zznyu = false;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static synchronized FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        FirebaseInstanceId firebaseInstanceId = zzifg.get(firebaseApp.getOptions().getApplicationId());
        if (firebaseInstanceId == null) {
            if (zznyq == null) {
                zznyq = new zzy(firebaseApp.getApplicationContext());
            }
            firebaseInstanceId = new FirebaseInstanceId(firebaseApp);
            zzifg.put(firebaseApp.getOptions().getApplicationId(), firebaseInstanceId);
        }
        return firebaseInstanceId;
    }

    private FirebaseInstanceId(FirebaseApp firebaseApp) {
        this.zzmki = firebaseApp;
        if (zzu.zzf(firebaseApp) == null) {
            throw new IllegalStateException("FirebaseInstanceId failed to initialize, FirebaseApp is missing project ID");
        }
        this.zznys = new zzu(firebaseApp.getApplicationContext());
        this.zznyt = new zzv(firebaseApp.getApplicationContext(), this.zznys);
        zzz zzz2 = this.zzciu();
        if (zzz2 == null || zzz2.zzro(this.zznys.zzcjg()) || zznyq.zzcjm() != null) {
            this.startSync();
        }
    }

    final FirebaseApp getApp() {
        return this.zzmki;
    }

    final synchronized void zzcr(boolean bl) {
        this.zznyu = bl;
    }

    private final synchronized void startSync() {
        if (!this.zznyu) {
            this.zzcc(0L);
        }
    }

    final synchronized void zzcc(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zznyp);
        FirebaseInstanceId.zzb(new zzaa(this, this.zznys, l2), l);
        this.zznyu = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zzb(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zznyr == null) {
                zznyr = new ScheduledThreadPoolExecutor(1);
            }
            zznyr.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    public String getId() {
        FirebaseInstanceId firebaseInstanceId = this;
        if (firebaseInstanceId.zzifj == null) {
            firebaseInstanceId.zzifj = zznyq.zzrm("");
        }
        if (firebaseInstanceId.zzifj == null) {
            firebaseInstanceId.zzifj = zznyq.zzrk("");
        }
        return zzu.zzb(firebaseInstanceId.zzifj);
    }

    public long getCreationTime() {
        return zznyq.zzrj("");
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        this.deleteToken("*", "*");
        this.zzavf();
    }

    @Nullable
    public String getToken() {
        zzz zzz2 = this.zzciu();
        if (zzz2 == null || zzz2.zzro(this.zznys.zzcjg())) {
            this.startSync();
        }
        if (zzz2 != null) {
            return zzz2.zzldj;
        }
        return null;
    }

    @Nullable
    final zzz zzciu() {
        return zznyq.zzp("", zzu.zzf(this.zzmki), "*");
    }

    final String zzciv() throws IOException {
        return this.getToken(zzu.zzf(this.zzmki), "*");
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        zzz zzz2 = zznyq.zzp("", string, string2);
        if (zzz2 != null && !zzz2.zzro(this.zznys.zzcjg())) {
            return zzz2.zzldj;
        }
        String string3 = this.zzb(string, string2, new Bundle());
        if (string3 != null) {
            zznyq.zza("", string, string2, string3, this.zznys.zzcjg());
        }
        return string3;
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        Bundle bundle = new Bundle();
        bundle.putString("delete", "1");
        this.zzb(string, string2, bundle);
        zznyq.zzf("", string, string2);
    }

    public final synchronized void zzrf(String string) {
        zznyq.zzrf(string);
        this.startSync();
    }

    static zzy zzciw() {
        return zznyq;
    }

    final void zzrg(String string) throws IOException {
        zzz zzz2 = this.zzciu();
        if (zzz2 == null || zzz2.zzro(this.zznys.zzcjg())) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zzb(zzz2.zzldj, string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    final void zzrh(String string) throws IOException {
        zzz zzz2 = this.zzciu();
        if (zzz2 == null || zzz2.zzro(this.zznys.zzcjg())) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        bundle.putString("delete", "1");
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zzb(zzz2.zzldj, string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    private final String zzb(String string, String string2, Bundle bundle) throws IOException {
        String string3;
        bundle.putString("scope", string2);
        bundle.putString("sender", string);
        bundle.putString("subtype", string);
        bundle.putString("appid", this.getId());
        bundle.putString("gmp_app_id", this.zzmki.getOptions().getApplicationId());
        bundle.putString("gmsv", Integer.toString(this.zznys.zzcji()));
        bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle.putString("app_ver", this.zznys.zzcjg());
        bundle.putString("app_ver_name", this.zznys.zzcjh());
        bundle.putString("cliv", "fiid-11910000");
        Bundle bundle2 = this.zznyt.zzad(bundle);
        if (bundle2 == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string4 = bundle2.getString("registration_id");
        if (string4 != null) {
            string3 = string4;
        } else {
            String string5 = bundle2.getString("unregistered");
            if (string5 != null) {
                string3 = string5;
            } else {
                String string6 = bundle2.getString("error");
                if (string6 != null) {
                    throw new IOException(string6);
                }
                String string7 = String.valueOf(bundle2);
                Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(20 + String.valueOf(string7).length()).append("Unexpected response ").append(string7).toString(), (Throwable)new Throwable());
                throw new IOException("SERVICE_NOT_AVAILABLE");
            }
        }
        String string8 = string3;
        if ("RST".equals(string8) || string8.startsWith("RST|")) {
            this.zzciy();
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        return string8;
    }

    static boolean zzcix() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }

    private final void zzavf() {
        zznyq.zzrl("");
        this.zzifj = null;
    }

    final void zzciy() {
        zznyq.zzavj();
        this.zzavf();
        this.startSync();
    }

    final void zzciz() {
        zznyq.zzia("");
        this.startSync();
    }
}

