/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Parcelable;
import android.os.PowerManager;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdReceiver;
import com.google.firebase.iid.zzab;
import com.google.firebase.iid.zzu;
import com.google.firebase.iid.zzz;
import java.io.IOException;

final class zzaa
implements Runnable {
    private final long zznzv;
    private final PowerManager.WakeLock zznzw;
    private final FirebaseInstanceId zznzx;
    private final zzu zznys;

    zzaa(FirebaseInstanceId firebaseInstanceId, zzu zzu2, long l) {
        this.zznzx = firebaseInstanceId;
        this.zznys = zzu2;
        this.zznzv = l;
        PowerManager powerManager = (PowerManager)this.getContext().getSystemService("power");
        this.zznzw = powerManager.newWakeLock(1, "fiid-sync");
        this.zznzw.setReferenceCounted(false);
    }

    @Override
    public final void run() {
        this.zznzw.acquire();
        try {
            this.zznzx.zzcr(true);
            if (!(this.zznys.zzcjf() != 0)) {
                this.zznzx.zzcr(false);
                return;
            }
            if (!this.zzcjp()) {
                new zzab(this).zzcjq();
                return;
            }
            if (this.zzcjn() && this.zzcjo()) {
                this.zznzx.zzcr(false);
            } else {
                this.zznzx.zzcc(this.zznzv);
            }
            return;
        }
        finally {
            this.zznzw.release();
        }
    }

    private final boolean zzcjn() {
        zzz zzz2 = this.zznzx.zzciu();
        if (zzz2 != null && !zzz2.zzro(this.zznys.zzcjg())) {
            return true;
        }
        try {
            String string = this.zznzx.zzciv();
            if (string == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Token retrieval failed: null");
                return false;
            }
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Token successfully retrieved");
            }
            if (zzz2 == null || zzz2 != null && !string.equals(zzz2.zzldj)) {
                Context context = this.getContext();
                Intent intent = new Intent("com.google.firebase.iid.TOKEN_REFRESH");
                Intent intent2 = new Intent("com.google.firebase.INSTANCE_ID_EVENT");
                intent2.setClass(context, FirebaseInstanceIdReceiver.class);
                intent2.putExtra("wrapped_intent", (Parcelable)intent);
                context.sendBroadcast(intent2);
            }
            return true;
        }
        catch (IOException | SecurityException exception) {
            String string = String.valueOf(exception.getMessage());
            Log.e((String)"FirebaseInstanceId", (String)(string.length() != 0 ? "Token retrieval failed: ".concat(string) : new String("Token retrieval failed: ")));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzcjo() {
        while (true) {
            String string;
            FirebaseInstanceId firebaseInstanceId = this.zznzx;
            synchronized (firebaseInstanceId) {
                string = FirebaseInstanceId.zzciw().zzcjm();
                if (string == null) {
                    Log.d((String)"FirebaseInstanceId", (String)"topic sync succeeded");
                    return true;
                }
            }
            if (!this.zzrp(string)) {
                return false;
            }
            FirebaseInstanceId.zzciw().zzri(string);
        }
    }

    private final boolean zzrp(String string) {
        block12: {
            String[] stringArray = string.split("!");
            if (stringArray.length != 2) break block12;
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            try {
                switch (string2) {
                    case "S": {
                        this.zznzx.zzrg(string3);
                        if (FirebaseInstanceId.zzcix()) {
                            Log.d((String)"FirebaseInstanceId", (String)"subscribe operation succeeded");
                        }
                        break;
                    }
                    case "U": {
                        this.zznzx.zzrh(string3);
                        if (FirebaseInstanceId.zzcix()) {
                            Log.d((String)"FirebaseInstanceId", (String)"unsubscribe operation succeeded");
                        } else {
                            break;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(iOException.getMessage());
                Log.e((String)"FirebaseInstanceId", (String)(string4.length() != 0 ? "Topic sync failed: ".concat(string4) : new String("Topic sync failed: ")));
                return false;
            }
        }
        return true;
    }

    final Context getContext() {
        return this.zznzx.getApp().getApplicationContext();
    }

    final boolean zzcjp() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }
}

