/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.util.SimpleArrayMap;
import android.util.Log;
import com.google.android.gms.iid.MessengerCompat;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.zzi;
import com.google.firebase.iid.zzs;
import com.google.firebase.iid.zzu;
import com.google.firebase.iid.zzw;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class zzv {
    private static int zzift = 0;
    private static PendingIntent zzicn;
    private final SimpleArrayMap<String, TaskCompletionSource<Bundle>> zznzn = new SimpleArrayMap();
    private final Context zzair;
    private final zzu zznys;
    private Messenger zzicr;
    private Messenger zzifw;
    private MessengerCompat zzifx;

    public zzv(Context context, zzu zzu2) {
        this.zzair = context;
        this.zznys = zzu2;
        this.zzicr = new Messenger((Handler)new zzw(this, Looper.getMainLooper()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zze(Message message) {
        if (message != null && message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader(MessengerCompat.class.getClassLoader());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof MessengerCompat) {
                    this.zzifx = (MessengerCompat)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzifw = (Messenger)parcelable;
                }
            }
            Intent intent2 = (Intent)message.obj;
            zzv zzv2 = this;
            String string = intent2.getAction();
            if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string)) {
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    String string2 = String.valueOf(string);
                    Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Unexpected response action: ".concat(string2) : new String("Unexpected response action: ")));
                }
                return;
            }
            String string3 = intent2.getStringExtra("registration_id");
            if (string3 == null) {
                string3 = intent2.getStringExtra("unregistered");
            }
            if (string3 == null) {
                Intent intent3 = intent2;
                zzv zzv3 = zzv2;
                String string4 = intent3.getStringExtra("error");
                if (string4 == null) {
                    String string5 = String.valueOf(intent3.getExtras());
                    Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(49 + String.valueOf(string5).length()).append("Unexpected response, no error or registration id ").append(string5).toString());
                    return;
                }
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    String string6 = String.valueOf(string4);
                    Log.d((String)"FirebaseInstanceId", (String)(string6.length() != 0 ? "Received InstanceID error ".concat(string6) : new String("Received InstanceID error ")));
                }
                String string7 = null;
                if (string4.startsWith("|")) {
                    String[] stringArray = string4.split("\\|");
                    if (!"ID".equals(stringArray[1])) {
                        String string8 = String.valueOf(string4);
                        Log.w((String)"FirebaseInstanceId", (String)(string8.length() != 0 ? "Unexpected structured response ".concat(string8) : new String("Unexpected structured response ")));
                    }
                    if (stringArray.length > 2) {
                        string7 = stringArray[2];
                        string4 = stringArray[3];
                        if (string4.startsWith(":")) {
                            string4 = string4.substring(1);
                        }
                    } else {
                        string4 = "UNKNOWN";
                    }
                    intent3.putExtra("error", string4);
                }
                zzv3.zzbl(string7, string4);
                return;
            }
            Matcher matcher = Pattern.compile("\\|ID\\|([^|]+)\\|:?+(.*)").matcher(string3);
            if (!matcher.matches()) {
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    String string9 = String.valueOf(string3);
                    Log.d((String)"FirebaseInstanceId", (String)(string9.length() != 0 ? "Unexpected response string: ".concat(string9) : new String("Unexpected response string: ")));
                }
                return;
            }
            String string10 = matcher.group(1);
            String string11 = matcher.group(2);
            Bundle bundle = intent2.getExtras();
            bundle.putString("registration_id", string11);
            Bundle bundle2 = bundle;
            String string12 = string10;
            zzv zzv4 = zzv2;
            SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = zzv4.zznzn;
            synchronized (simpleArrayMap) {
                TaskCompletionSource taskCompletionSource = (TaskCompletionSource)zzv4.zznzn.remove((Object)string12);
                if (taskCompletionSource == null) {
                    String string13 = String.valueOf(string12);
                    Log.w((String)"FirebaseInstanceId", (String)(string13.length() != 0 ? "Missing callback for ".concat(string13) : new String("Missing callback for ")));
                    return;
                }
                taskCompletionSource.setResult((Object)bundle2);
                return;
            }
        }
        Log.w((String)"FirebaseInstanceId", (String)"Dropping invalid message");
    }

    private static synchronized void zzd(Context context, Intent intent) {
        if (zzicn == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            zzicn = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)zzicn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzbl(String string, String string2) {
        SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.zznzn;
        synchronized (simpleArrayMap) {
            if (string == null) {
                for (int i = 0; i < this.zznzn.size(); ++i) {
                    ((TaskCompletionSource)this.zznzn.valueAt(i)).setException((Exception)new IOException(string2));
                }
                this.zznzn.clear();
            } else {
                TaskCompletionSource taskCompletionSource = (TaskCompletionSource)this.zznzn.remove((Object)string);
                if (taskCompletionSource == null) {
                    String string3 = String.valueOf(string);
                    Log.w((String)"FirebaseInstanceId", (String)(string3.length() != 0 ? "Missing callback for ".concat(string3) : new String("Missing callback for ")));
                    return;
                }
                taskCompletionSource.setException((Exception)new IOException(string2));
            }
            return;
        }
    }

    final Bundle zzad(Bundle bundle) throws IOException {
        if (this.zznys.zzcji() >= 12000000) {
            Task<Bundle> task = zzi.zzev(this.zzair).zzi(1, bundle);
            try {
                return (Bundle)Tasks.await(task);
            }
            catch (InterruptedException | ExecutionException exception) {
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    String string = String.valueOf(exception);
                    Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(22 + String.valueOf(string).length()).append("Error making request: ").append(string).toString());
                }
                if (exception.getCause() instanceof zzs && ((zzs)exception.getCause()).getErrorCode() == 4) {
                    return this.zzae(bundle);
                }
                return null;
            }
        }
        return this.zzae(bundle);
    }

    private final Bundle zzae(Bundle bundle) throws IOException {
        Bundle bundle2 = this.zzaf(bundle);
        if (bundle2 != null && bundle2.containsKey("google.messenger") && (bundle2 = this.zzaf(bundle)) != null && bundle2.containsKey("google.messenger")) {
            bundle2 = null;
        }
        return bundle2;
    }

    private static synchronized String zzavi() {
        return Integer.toString(zzift++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle zzaf(Bundle bundle) throws IOException {
        Bundle bundle2;
        TaskCompletionSource taskCompletionSource;
        String string;
        block27: {
            zzv zzv2;
            Intent intent;
            block28: {
                String string2;
                string = zzv.zzavi();
                taskCompletionSource = new TaskCompletionSource();
                bundle2 = this.zznzn;
                synchronized (bundle2) {
                    this.zznzn.put((Object)string, (Object)taskCompletionSource);
                }
                String string3 = string;
                Bundle bundle3 = bundle;
                zzv zzv3 = this;
                if (zzv3.zznys.zzcjf() == 0) {
                    throw new IOException("MISSING_INSTANCEID_SERVICE");
                }
                Intent intent2 = new Intent();
                intent2.setPackage("com.google.android.gms");
                if (zzv3.zznys.zzcjf() == 2) {
                    intent2.setAction("com.google.iid.TOKEN_REQUEST");
                } else {
                    intent2.setAction("com.google.android.c2dm.intent.REGISTER");
                }
                intent2.putExtras(bundle3);
                zzv.zzd(zzv3.zzair, intent2);
                String string4 = string3;
                intent = intent2;
                zzv2 = zzv3;
                intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string4).length()).append("|ID|").append(string4).append("|").toString());
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    string2 = String.valueOf(intent.getExtras());
                    Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
                }
                intent.putExtra("google.messenger", (Parcelable)zzv2.zzicr);
                if (zzv2.zzifw != null || zzv2.zzifx != null) {
                    string2 = Message.obtain();
                    Message.obtain().obj = intent;
                    try {
                        if (zzv2.zzifw != null) {
                            zzv2.zzifw.send((Message)string2);
                        } else {
                            zzv2.zzifx.send((Message)string2);
                        }
                        break block27;
                    }
                    catch (RemoteException remoteException) {
                        if (!Log.isLoggable((String)"FirebaseInstanceId", (int)3)) break block28;
                        Log.d((String)"FirebaseInstanceId", (String)"Messenger failed, fallback to startService");
                    }
                }
            }
            if (zzv2.zznys.zzcjf() == 2) {
                zzv2.zzair.sendBroadcast(intent);
            } else {
                zzv2.zzair.startService(intent);
            }
        }
        try {
            bundle2 = (Bundle)Tasks.await((Task)taskCompletionSource.getTask(), (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
            return bundle2;
        }
        catch (InterruptedException | TimeoutException exception) {
            Log.w((String)"FirebaseInstanceId", (String)"No response");
            throw new IOException("TIMEOUT");
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException(throwable);
        }
        finally {
            SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.zznzn;
            synchronized (simpleArrayMap) {
                this.zznzn.remove((Object)string);
            }
        }
    }

    static /* synthetic */ void zza(zzv zzv2, Message message) {
        zzv2.zze(message);
    }
}

