/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.util.zzx;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zza;
import com.google.firebase.iid.zzab;
import java.io.File;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

final class zzaa {
    private SharedPreferences zza;
    private Context zzb;

    public zzaa(Context context) {
        this(context, "com.google.android.gms.appid");
    }

    private zzaa(Context context, String string) {
        block4: {
            this.zzb = context;
            this.zza = context.getSharedPreferences(string, 0);
            String string2 = String.valueOf(string);
            String string3 = String.valueOf("-no-backup");
            String string4 = string3.length() != 0 ? string2.concat(string3) : new String(string2);
            zzaa zzaa2 = this;
            File file = zzx.zza((Context)zzaa2.zzb);
            File file2 = new File(file, string4);
            if (!file2.exists()) {
                try {
                    if (file2.createNewFile() && !zzaa2.zzc()) {
                        Log.i((String)"FirebaseInstanceId", (String)"App restored, clearing state");
                        zzaa2.zzb();
                        FirebaseInstanceId.getInstance().zzf();
                    }
                    return;
                }
                catch (IOException iOException) {
                    if (!Log.isLoggable((String)"FirebaseInstanceId", (int)3)) break block4;
                    String string5 = String.valueOf(iOException.getMessage());
                    Log.d((String)"FirebaseInstanceId", (String)(string5.length() != 0 ? "Error creating file in no backup dir: ".concat(string5) : new String("Error creating file in no backup dir: ")));
                }
            }
        }
    }

    public final synchronized void zza(String string) {
        String string2 = this.zza.getString("topic_operaion_queue", "");
        String string3 = new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(",").append(string).toString();
        this.zza.edit().putString("topic_operaion_queue", string3).apply();
    }

    @Nullable
    public final synchronized String zza() {
        String[] stringArray;
        String string = this.zza.getString("topic_operaion_queue", null);
        if (string != null && (stringArray = string.split(",")).length > 1 && !TextUtils.isEmpty((CharSequence)stringArray[1])) {
            return stringArray[1];
        }
        return null;
    }

    public final synchronized boolean zzb(String string) {
        String string2 = this.zza.getString("topic_operaion_queue", "");
        String string3 = String.valueOf(",");
        String string4 = String.valueOf(string);
        if (string2.startsWith(string4.length() != 0 ? string3.concat(string4) : new String(string3))) {
            String string5 = String.valueOf(",");
            String string6 = String.valueOf(string);
            int n = (string6.length() != 0 ? string5.concat(string6) : new String(string5)).length();
            string2 = string2.substring(n);
            this.zza.edit().putString("topic_operaion_queue", string2).apply();
            return true;
        }
        return false;
    }

    public final synchronized long zzc(String string) {
        String string2 = zzaa.zza(string, "cre");
        String string3 = this.zza.getString(string2, null);
        if (string3 != null) {
            try {
                return Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0L;
    }

    private final synchronized boolean zzc() {
        return this.zza.getAll().isEmpty();
    }

    private static String zzc(String string, String string2, String string3) {
        return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append("|T|").append(string2).append("|").append(string3).toString();
    }

    private static String zza(String string, String string2) {
        return new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("|S|").append(string2).toString();
    }

    public final synchronized void zzb() {
        this.zza.edit().clear().commit();
    }

    public final synchronized zzab zza(String string, String string2, String string3) {
        return zzab.zza(this.zza.getString(zzaa.zzc(string, string2, string3), null));
    }

    public final synchronized void zza(String string, String string2, String string3, String string4, String string5) {
        String string6 = zzab.zza(string4, string5, System.currentTimeMillis());
        if (string6 == null) {
            return;
        }
        SharedPreferences.Editor editor = this.zza.edit();
        editor.putString(zzaa.zzc(string, string2, string3), string6);
        editor.commit();
    }

    public final synchronized void zzb(String string, String string2, String string3) {
        String string4 = zzaa.zzc(string, string2, string3);
        SharedPreferences.Editor editor = this.zza.edit();
        editor.remove(string4);
        editor.commit();
    }

    final synchronized KeyPair zzd(String string) {
        KeyPair keyPair = com.google.firebase.iid.zza.zza();
        long l = System.currentTimeMillis();
        SharedPreferences.Editor editor = this.zza.edit();
        editor.putString(zzaa.zza(string, "|P|"), Base64.encodeToString((byte[])keyPair.getPublic().getEncoded(), (int)11));
        editor.putString(zzaa.zza(string, "|K|"), Base64.encodeToString((byte[])keyPair.getPrivate().getEncoded(), (int)11));
        editor.putString(zzaa.zza(string, "cre"), Long.toString(l));
        editor.commit();
        return keyPair;
    }

    public final synchronized void zze(String string) {
        String string2 = String.valueOf(string).concat("|T|");
        zzaa zzaa2 = this;
        SharedPreferences.Editor editor = zzaa2.zza.edit();
        for (String string3 : zzaa2.zza.getAll().keySet()) {
            if (!string3.startsWith(string2)) continue;
            editor.remove(string3);
        }
        editor.commit();
    }

    public final synchronized KeyPair zzf(String string) {
        String string2 = this.zza.getString(zzaa.zza(string, "|P|"), null);
        String string3 = this.zza.getString(zzaa.zza(string, "|K|"), null);
        if (string2 == null || string3 == null) {
            return null;
        }
        try {
            byte[] byArray = Base64.decode((String)string2, (int)8);
            byte[] byArray2 = Base64.decode((String)string3, (int)8);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            String string4 = String.valueOf(generalSecurityException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(19 + String.valueOf(string4).length()).append("Invalid key stored ").append(string4).toString());
            FirebaseInstanceId.getInstance().zzf();
            return null;
        }
    }
}

