/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Parcelable;
import android.os.PowerManager;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdReceiver;
import com.google.firebase.iid.zzab;
import com.google.firebase.iid.zzad;
import com.google.firebase.iid.zzw;
import java.io.IOException;

final class zzac
implements Runnable {
    private final long zza;
    private final PowerManager.WakeLock zzb;
    private final FirebaseInstanceId zzc;
    private final zzw zzd;

    zzac(FirebaseInstanceId firebaseInstanceId, zzw zzw2, long l) {
        this.zzc = firebaseInstanceId;
        this.zzd = zzw2;
        this.zza = l;
        PowerManager powerManager = (PowerManager)this.zza().getSystemService("power");
        this.zzb = powerManager.newWakeLock(1, "fiid-sync");
        this.zzb.setReferenceCounted(false);
    }

    @Override
    public final void run() {
        this.zzb.acquire();
        try {
            this.zzc.zza(true);
            if (!(this.zzd.zza() != 0)) {
                this.zzc.zza(false);
                return;
            }
            if (!this.zzb()) {
                new zzad(this).zza();
                return;
            }
            if (this.zzc() && this.zzd()) {
                this.zzc.zza(false);
            } else {
                this.zzc.zza(this.zza);
            }
            return;
        }
        finally {
            this.zzb.release();
        }
    }

    private final boolean zzc() {
        zzab zzab2 = this.zzc.zzb();
        if (zzab2 != null && !zzab2.zzb(this.zzd.zzb())) {
            return true;
        }
        try {
            String string = this.zzc.zzc();
            if (string == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Token retrieval failed: null");
                return false;
            }
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Token successfully retrieved");
            }
            if (zzab2 == null || zzab2 != null && !string.equals(zzab2.zza)) {
                Context context = this.zza();
                Intent intent = new Intent("com.google.firebase.iid.TOKEN_REFRESH");
                Intent intent2 = new Intent("com.google.firebase.INSTANCE_ID_EVENT");
                intent2.setClass(context, FirebaseInstanceIdReceiver.class);
                intent2.putExtra("wrapped_intent", (Parcelable)intent);
                context.sendBroadcast(intent2);
            }
            return true;
        }
        catch (IOException | SecurityException exception) {
            String string = String.valueOf(exception.getMessage());
            Log.e((String)"FirebaseInstanceId", (String)(string.length() != 0 ? "Token retrieval failed: ".concat(string) : new String("Token retrieval failed: ")));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzd() {
        while (true) {
            String string;
            FirebaseInstanceId firebaseInstanceId = this.zzc;
            synchronized (firebaseInstanceId) {
                string = FirebaseInstanceId.zzd().zza();
                if (string == null) {
                    Log.d((String)"FirebaseInstanceId", (String)"topic sync succeeded");
                    return true;
                }
            }
            if (!this.zza(string)) {
                return false;
            }
            FirebaseInstanceId.zzd().zzb(string);
        }
    }

    private final boolean zza(String string) {
        block12: {
            String[] stringArray = string.split("!");
            if (stringArray.length != 2) break block12;
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            try {
                switch (string2) {
                    case "S": {
                        this.zzc.zzb(string3);
                        if (FirebaseInstanceId.zze()) {
                            Log.d((String)"FirebaseInstanceId", (String)"subscribe operation succeeded");
                        }
                        break;
                    }
                    case "U": {
                        this.zzc.zzc(string3);
                        if (FirebaseInstanceId.zze()) {
                            Log.d((String)"FirebaseInstanceId", (String)"unsubscribe operation succeeded");
                        } else {
                            break;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(iOException.getMessage());
                Log.e((String)"FirebaseInstanceId", (String)(string4.length() != 0 ? "Topic sync failed: ".concat(string4) : new String("Topic sync failed: ")));
                return false;
            }
        }
        return true;
    }

    final Context zza() {
        return this.zzc.zza().getApplicationContext();
    }

    final boolean zzb() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zza().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }
}

