/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.zzaa;
import com.google.firebase.iid.zzab;
import com.google.firebase.iid.zzac;
import com.google.firebase.iid.zzw;
import com.google.firebase.iid.zzx;
import java.io.IOException;
import java.security.KeyPair;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseInstanceId {
    private static final long zzbqi = TimeUnit.HOURS.toSeconds(8L);
    private static Map<String, FirebaseInstanceId> zzbqj = new ArrayMap();
    private static zzaa zzbqk;
    @GuardedBy(value="FirebaseInstanceId.class")
    @VisibleForTesting
    private static ScheduledThreadPoolExecutor zzbql;
    private final FirebaseApp zzbqm;
    private final zzw zzbqn;
    private final zzx zzbqo;
    @GuardedBy(value="this")
    private KeyPair zzbqp;
    @GuardedBy(value="this")
    private boolean zzbqq = false;
    @GuardedBy(value="this")
    private boolean zzbqr;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static synchronized FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        FirebaseInstanceId firebaseInstanceId = zzbqj.get(firebaseApp.getOptions().getApplicationId());
        if (firebaseInstanceId == null) {
            if (zzbqk == null) {
                zzbqk = new zzaa(firebaseApp.getApplicationContext());
            }
            firebaseInstanceId = new FirebaseInstanceId(firebaseApp, new zzw(firebaseApp.getApplicationContext()));
            zzbqj.put(firebaseApp.getOptions().getApplicationId(), firebaseInstanceId);
        }
        return firebaseInstanceId;
    }

    @VisibleForTesting
    private FirebaseInstanceId(FirebaseApp firebaseApp, zzw zzw2) {
        if (zzw.zza(firebaseApp) == null) {
            throw new IllegalStateException("FirebaseInstanceId failed to initialize, FirebaseApp is missing project ID");
        }
        this.zzbqm = firebaseApp;
        this.zzbqn = zzw2;
        this.zzbqo = new zzx(firebaseApp.getApplicationContext(), zzw2);
        this.zzbqr = this.zzsm();
        if (this.zzso()) {
            this.zzse();
        }
    }

    private final void zzse() {
        zzab zzab2 = this.zzsg();
        if (zzab2 == null || zzab2.zzff(this.zzbqn.zzsv()) || zzbqk.zztc() != null) {
            this.startSync();
        }
    }

    final FirebaseApp zzsf() {
        return this.zzbqm;
    }

    final synchronized void zzu(boolean bl) {
        this.zzbqq = bl;
    }

    private final synchronized void startSync() {
        if (!this.zzbqq) {
            this.zzan(0L);
        }
    }

    final synchronized void zzan(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zzbqi);
        FirebaseInstanceId.zza(new zzac(this, this.zzbqn, l2), l);
        this.zzbqq = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzbql == null) {
                zzbql = new ScheduledThreadPoolExecutor(1);
            }
            zzbql.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    public String getId() {
        this.zzse();
        return zzw.zza(this.getKeyPair());
    }

    public long getCreationTime() {
        return zzbqk.zzfa("");
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        Bundle bundle = new Bundle();
        bundle.putString("iid-operation", "delete");
        bundle.putString("delete", "1");
        this.zzb("*", "*", bundle);
        this.zzsk();
    }

    @Nullable
    public String getToken() {
        zzab zzab2 = this.zzsg();
        if (zzab2 == null || zzab2.zzff(this.zzbqn.zzsv())) {
            this.startSync();
        }
        if (zzab2 != null) {
            return zzab2.zzbsb;
        }
        return null;
    }

    @Nullable
    final zzab zzsg() {
        return zzbqk.zzj("", zzw.zza(this.zzbqm), "*");
    }

    final String zzsh() throws IOException {
        return this.getToken(zzw.zza(this.zzbqm), "*");
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        zzab zzab2 = zzbqk.zzj("", string, string2);
        if (zzab2 != null && !zzab2.zzff(this.zzbqn.zzsv())) {
            return zzab2.zzbsb;
        }
        String string3 = this.zzb(string, string2, new Bundle());
        if (string3 != null) {
            zzbqk.zza("", string, string2, string3, this.zzbqn.zzsv());
        }
        return string3;
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        Bundle bundle = new Bundle();
        bundle.putString("delete", "1");
        this.zzb(string, string2, bundle);
        zzbqk.zzk("", string, string2);
    }

    public final synchronized void zzev(String string) {
        zzbqk.zzev(string);
        this.startSync();
    }

    static zzaa zzsi() {
        return zzbqk;
    }

    final void zzew(String string) throws IOException {
        zzab zzab2 = this.zzsg();
        if (zzab2 == null || zzab2.zzff(this.zzbqn.zzsv())) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zzb(zzab2.zzbsb, string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    final void zzex(String string) throws IOException {
        zzab zzab2 = this.zzsg();
        if (zzab2 == null || zzab2.zzff(this.zzbqn.zzsv())) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        bundle.putString("delete", "1");
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zzb(zzab2.zzbsb, string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    private final String zzb(String string, String string2, Bundle bundle) throws IOException {
        bundle.putString("scope", string2);
        bundle.putString("sender", string);
        bundle.putString("subtype", string);
        bundle.putString("appid", this.getId());
        bundle.putString("gmp_app_id", this.zzbqm.getOptions().getApplicationId());
        bundle.putString("gmsv", Integer.toString(this.zzbqn.zzsx()));
        bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle.putString("app_ver", this.zzbqn.zzsv());
        bundle.putString("app_ver_name", this.zzbqn.zzsw());
        bundle.putString("cliv", "fiid-12451000");
        Bundle bundle2 = this.zzbqo.zzi(bundle);
        if (bundle2 == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string3 = bundle2.getString("registration_id");
        if (string3 != null) {
            return string3;
        }
        String string4 = bundle2.getString("unregistered");
        if (string4 != null) {
            return string4;
        }
        String string5 = bundle2.getString("error");
        if ("RST".equals(string5)) {
            this.zzsk();
            throw new IOException("INSTANCE_ID_RESET");
        }
        if (string5 != null) {
            throw new IOException(string5);
        }
        String string6 = String.valueOf(bundle2);
        Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(21 + String.valueOf(string6).length()).append("Unexpected response: ").append(string6).toString(), (Throwable)new Throwable());
        throw new IOException("SERVICE_NOT_AVAILABLE");
    }

    static boolean zzsj() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }

    private final synchronized KeyPair getKeyPair() {
        if (this.zzbqp == null) {
            this.zzbqp = zzbqk.zzfd("");
        }
        if (this.zzbqp == null) {
            this.zzbqp = zzbqk.zzfb("");
        }
        return this.zzbqp;
    }

    final synchronized void zzsk() {
        zzbqk.zztd();
        this.zzbqp = null;
        if (this.zzso()) {
            this.startSync();
        }
    }

    final void zzsl() {
        zzbqk.zzfc("");
        this.startSync();
    }

    private final boolean zzsm() {
        Context context = this.zzbqm.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
        if (sharedPreferences.contains("auto_init")) {
            return sharedPreferences.getBoolean("auto_init", true);
        }
        try {
            ApplicationInfo applicationInfo;
            PackageManager packageManager = context.getPackageManager();
            if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("firebase_messaging_auto_init_enabled")) {
                return applicationInfo.metaData.getBoolean("firebase_messaging_auto_init_enabled");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return this.zzsn();
    }

    private final boolean zzsn() {
        try {
            Class.forName("com.google.firebase.messaging.FirebaseMessaging");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Context context = this.zzbqm.getApplicationContext();
            Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
            intent.setPackage(context.getPackageName());
            ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
            return resolveInfo != null && resolveInfo.serviceInfo != null;
        }
    }

    @VisibleForTesting
    public final synchronized boolean zzso() {
        return this.zzbqr;
    }

    @VisibleForTesting
    public final synchronized void zzv(boolean bl) {
        SharedPreferences.Editor editor = this.zzbqm.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
        editor.putBoolean("auto_init", bl);
        editor.apply();
        if (!this.zzbqr && bl) {
            this.zzse();
        }
        this.zzbqr = bl;
    }
}

