/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zza;
import com.google.firebase.iid.zzab;
import java.io.File;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

final class zzaa {
    private final SharedPreferences zzbrz;
    private final Context zzqs;

    public zzaa(Context context) {
        this(context, "com.google.android.gms.appid");
    }

    private zzaa(Context context, String string) {
        block4: {
            this.zzqs = context;
            this.zzbrz = context.getSharedPreferences(string, 0);
            String string2 = String.valueOf(string);
            String string3 = String.valueOf("-no-backup");
            String string4 = string3.length() != 0 ? string2.concat(string3) : new String(string2);
            zzaa zzaa2 = this;
            File file = ContextCompat.getNoBackupFilesDir((Context)zzaa2.zzqs);
            File file2 = new File(file, string4);
            if (!file2.exists()) {
                try {
                    if (file2.createNewFile() && !zzaa2.isEmpty()) {
                        Log.i((String)"FirebaseInstanceId", (String)"App restored, clearing state");
                        zzaa2.zztd();
                        FirebaseInstanceId.getInstance().zzsk();
                    }
                    return;
                }
                catch (IOException iOException) {
                    if (!Log.isLoggable((String)"FirebaseInstanceId", (int)3)) break block4;
                    String string5 = String.valueOf(iOException.getMessage());
                    Log.d((String)"FirebaseInstanceId", (String)(string5.length() != 0 ? "Error creating file in no backup dir: ".concat(string5) : new String("Error creating file in no backup dir: ")));
                }
            }
        }
    }

    public final synchronized void zzev(String string) {
        String string2 = this.zzbrz.getString("topic_operaion_queue", "");
        String string3 = new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(",").append(string).toString();
        this.zzbrz.edit().putString("topic_operaion_queue", string3).apply();
    }

    @Nullable
    public final synchronized String zztc() {
        String[] stringArray;
        String string = this.zzbrz.getString("topic_operaion_queue", null);
        if (string != null && (stringArray = string.split(",")).length > 1 && !TextUtils.isEmpty((CharSequence)stringArray[1])) {
            return stringArray[1];
        }
        return null;
    }

    public final synchronized boolean zzez(String string) {
        String string2 = this.zzbrz.getString("topic_operaion_queue", "");
        String string3 = String.valueOf(",");
        String string4 = String.valueOf(string);
        if (string2.startsWith(string4.length() != 0 ? string3.concat(string4) : new String(string3))) {
            String string5 = String.valueOf(",");
            String string6 = String.valueOf(string);
            int n = (string6.length() != 0 ? string5.concat(string6) : new String(string5)).length();
            string2 = string2.substring(n);
            this.zzbrz.edit().putString("topic_operaion_queue", string2).apply();
            return true;
        }
        return false;
    }

    public final synchronized long zzfa(String string) {
        String string2 = zzaa.zzv(string, "cre");
        String string3 = this.zzbrz.getString(string2, null);
        if (string3 != null) {
            try {
                return Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0L;
    }

    private final synchronized boolean isEmpty() {
        return this.zzbrz.getAll().isEmpty();
    }

    private static String zzi(String string, String string2, String string3) {
        return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append("|T|").append(string2).append("|").append(string3).toString();
    }

    private static String zzv(String string, String string2) {
        return new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("|S|").append(string2).toString();
    }

    public final synchronized void zztd() {
        this.zzbrz.edit().clear().commit();
    }

    public final synchronized zzab zzj(String string, String string2, String string3) {
        return zzab.zzfe(this.zzbrz.getString(zzaa.zzi(string, string2, string3), null));
    }

    public final synchronized void zza(String string, String string2, String string3, String string4, String string5) {
        String string6 = zzab.zza(string4, string5, System.currentTimeMillis());
        if (string6 == null) {
            return;
        }
        SharedPreferences.Editor editor = this.zzbrz.edit();
        editor.putString(zzaa.zzi(string, string2, string3), string6);
        editor.commit();
    }

    public final synchronized void zzk(String string, String string2, String string3) {
        String string4 = zzaa.zzi(string, string2, string3);
        SharedPreferences.Editor editor = this.zzbrz.edit();
        editor.remove(string4);
        editor.commit();
    }

    final synchronized KeyPair zzfb(String string) {
        KeyPair keyPair = zza.zzsc();
        long l = System.currentTimeMillis();
        SharedPreferences.Editor editor = this.zzbrz.edit();
        editor.putString(zzaa.zzv(string, "|P|"), Base64.encodeToString((byte[])keyPair.getPublic().getEncoded(), (int)11));
        editor.putString(zzaa.zzv(string, "|K|"), Base64.encodeToString((byte[])keyPair.getPrivate().getEncoded(), (int)11));
        editor.putString(zzaa.zzv(string, "cre"), Long.toString(l));
        editor.commit();
        return keyPair;
    }

    public final synchronized void zzfc(String string) {
        String string2 = String.valueOf(string).concat("|T|");
        zzaa zzaa2 = this;
        SharedPreferences.Editor editor = zzaa2.zzbrz.edit();
        for (String string3 : zzaa2.zzbrz.getAll().keySet()) {
            if (!string3.startsWith(string2)) continue;
            editor.remove(string3);
        }
        editor.commit();
    }

    public final synchronized KeyPair zzfd(String string) {
        String string2 = this.zzbrz.getString(zzaa.zzv(string, "|P|"), null);
        String string3 = this.zzbrz.getString(zzaa.zzv(string, "|K|"), null);
        if (string2 == null || string3 == null) {
            return null;
        }
        try {
            byte[] byArray = Base64.decode((String)string2, (int)8);
            byte[] byArray2 = Base64.decode((String)string3, (int)8);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            String string4 = String.valueOf(generalSecurityException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(19 + String.valueOf(string4).length()).append("Invalid key stored ").append(string4).toString());
            FirebaseInstanceId.getInstance().zzsk();
            return null;
        }
    }
}

