/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Parcelable;
import android.os.PowerManager;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdReceiver;
import com.google.firebase.iid.zzab;
import com.google.firebase.iid.zzad;
import com.google.firebase.iid.zzw;
import java.io.IOException;

final class zzac
implements Runnable {
    private final long zzbsc;
    private final PowerManager.WakeLock zzbsd;
    private final FirebaseInstanceId zzbse;
    private final zzw zzbqn;

    @VisibleForTesting
    zzac(FirebaseInstanceId firebaseInstanceId, zzw zzw2, long l) {
        this.zzbse = firebaseInstanceId;
        this.zzbqn = zzw2;
        this.zzbsc = l;
        PowerManager powerManager = (PowerManager)this.getContext().getSystemService("power");
        this.zzbsd = powerManager.newWakeLock(1, "fiid-sync");
        this.zzbsd.setReferenceCounted(false);
    }

    @Override
    public final void run() {
        this.zzbsd.acquire();
        try {
            this.zzbse.zzu(true);
            if (!(this.zzbqn.zzsu() != 0)) {
                this.zzbse.zzu(false);
                return;
            }
            if (!this.zztg()) {
                new zzad(this).zzth();
                return;
            }
            if (this.zzte() && this.zztf()) {
                this.zzbse.zzu(false);
            } else {
                this.zzbse.zzan(this.zzbsc);
            }
            return;
        }
        finally {
            this.zzbsd.release();
        }
    }

    @VisibleForTesting
    private final boolean zzte() {
        zzab zzab2 = this.zzbse.zzsg();
        if (zzab2 != null && !zzab2.zzff(this.zzbqn.zzsv())) {
            return true;
        }
        try {
            String string = this.zzbse.zzsh();
            if (string == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Token retrieval failed: null");
                return false;
            }
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Token successfully retrieved");
            }
            if (zzab2 == null || zzab2 != null && !string.equals(zzab2.zzbsb)) {
                Context context = this.getContext();
                Intent intent = new Intent("com.google.firebase.iid.TOKEN_REFRESH");
                Intent intent2 = new Intent("com.google.firebase.INSTANCE_ID_EVENT");
                intent2.setClass(context, FirebaseInstanceIdReceiver.class);
                intent2.putExtra("wrapped_intent", (Parcelable)intent);
                context.sendBroadcast(intent2);
            }
            return true;
        }
        catch (IOException | SecurityException exception) {
            String string = String.valueOf(exception.getMessage());
            Log.e((String)"FirebaseInstanceId", (String)(string.length() != 0 ? "Token retrieval failed: ".concat(string) : new String("Token retrieval failed: ")));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zztf() {
        while (true) {
            String string;
            FirebaseInstanceId firebaseInstanceId = this.zzbse;
            synchronized (firebaseInstanceId) {
                string = FirebaseInstanceId.zzsi().zztc();
                if (string == null) {
                    Log.d((String)"FirebaseInstanceId", (String)"topic sync succeeded");
                    return true;
                }
            }
            if (!this.zzfg(string)) {
                return false;
            }
            FirebaseInstanceId.zzsi().zzez(string);
        }
    }

    private final boolean zzfg(String string) {
        block12: {
            String[] stringArray = string.split("!");
            if (stringArray.length != 2) break block12;
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            try {
                switch (string2) {
                    case "S": {
                        this.zzbse.zzew(string3);
                        if (FirebaseInstanceId.zzsj()) {
                            Log.d((String)"FirebaseInstanceId", (String)"subscribe operation succeeded");
                        }
                        break;
                    }
                    case "U": {
                        this.zzbse.zzex(string3);
                        if (FirebaseInstanceId.zzsj()) {
                            Log.d((String)"FirebaseInstanceId", (String)"unsubscribe operation succeeded");
                        } else {
                            break;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(iOException.getMessage());
                Log.e((String)"FirebaseInstanceId", (String)(string4.length() != 0 ? "Topic sync failed: ".concat(string4) : new String("Topic sync failed: ")));
                return false;
            }
        }
        return true;
    }

    final Context getContext() {
        return this.zzbse.zzsf().getApplicationContext();
    }

    final boolean zztg() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }
}

