/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.firebase.iid.zzk;
import com.google.firebase.iid.zzl;
import com.google.firebase.iid.zzn;
import com.google.firebase.iid.zzo;
import com.google.firebase.iid.zzp;
import com.google.firebase.iid.zzr;
import com.google.firebase.iid.zzt;
import com.google.firebase.iid.zzu;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

final class zzm
implements ServiceConnection {
    @GuardedBy(value="this")
    int state = 0;
    final Messenger zzbqz = new Messenger(new Handler(Looper.getMainLooper(), (Handler.Callback)new zzn(this)));
    zzr zzbra;
    @GuardedBy(value="this")
    final Queue<zzt<?>> zzbrb = new ArrayDeque();
    @GuardedBy(value="this")
    final SparseArray<zzt<?>> zzbrc = new SparseArray();
    final /* synthetic */ zzk zzbrd;

    private zzm(zzk zzk2) {
        this.zzbrd = zzk2;
    }

    final synchronized boolean zzb(zzt zzt2) {
        switch (this.state) {
            case 0: {
                this.zzbrb.add(zzt2);
                zzm zzm2 = this;
                Preconditions.checkState((zzm2.state == 0 ? 1 : 0) != 0);
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
                }
                zzm2.state = 1;
                Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
                intent.setPackage("com.google.android.gms");
                if (!ConnectionTracker.getInstance().bindService(zzk.zza(zzm2.zzbrd), intent, (ServiceConnection)zzm2, 1)) {
                    zzm2.zzb(0, "Unable to bind to service");
                } else {
                    zzk.zzb(zzm2.zzbrd).schedule(new zzo(zzm2), 30L, TimeUnit.SECONDS);
                }
                return true;
            }
            case 1: {
                this.zzbrb.add(zzt2);
                return true;
            }
            case 2: {
                this.zzbrb.add(zzt2);
                this.zzsq();
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        int n = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(Message message) {
        zzt zzt2;
        int n = message.arg1;
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            Log.d((String)"MessengerIpcClient", (String)new StringBuilder(41).append("Received response to request: ").append(n).toString());
        }
        zzm zzm2 = this;
        synchronized (zzm2) {
            zzt2 = (zzt)this.zzbrc.get(n);
            if (zzt2 == null) {
                Log.w((String)"MessengerIpcClient", (String)new StringBuilder(50).append("Received response for unknown request: ").append(n).toString());
                return true;
            }
            this.zzbrc.remove(n);
            this.zzsr();
        }
        Bundle bundle = message.getData();
        zzt zzt3 = zzt2;
        if (bundle.getBoolean("unsupported", false)) {
            zzt3.zza(new zzu(4, "Not supported by GmsCore"));
        } else {
            zzt3.zzh(bundle);
        }
        return true;
    }

    public final synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service connected");
        }
        if (iBinder == null) {
            this.zzb(0, "Null service connection");
            return;
        }
        try {
            this.zzbra = new zzr(iBinder);
        }
        catch (RemoteException remoteException) {
            this.zzb(0, remoteException.getMessage());
            return;
        }
        this.state = 2;
        this.zzsq();
    }

    private final void zzsq() {
        zzk.zzb(this.zzbrd).execute(new zzp(this));
    }

    public final synchronized void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
        }
        this.zzb(2, "Service disconnected");
    }

    final synchronized void zzb(int n, String string) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"MessengerIpcClient", (String)(string2.length() != 0 ? "Disconnected: ".concat(string2) : new String("Disconnected: ")));
        }
        switch (this.state) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: 
            case 2: {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                }
                this.state = 4;
                ConnectionTracker.getInstance().unbindService(zzk.zza(this.zzbrd), (ServiceConnection)this);
                zzu zzu2 = new zzu(n, string);
                zzm zzm2 = this;
                Iterator iterator = zzm2.zzbrb.iterator();
                while (iterator.hasNext()) {
                    ((zzt)iterator.next()).zza(zzu2);
                }
                zzm2.zzbrb.clear();
                for (int i = 0; i < zzm2.zzbrc.size(); ++i) {
                    ((zzt)zzm2.zzbrc.valueAt(i)).zza(zzu2);
                }
                zzm2.zzbrc.clear();
                return;
            }
            case 3: {
                this.state = 4;
                return;
            }
            case 4: {
                return;
            }
        }
        int n2 = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n2).toString());
    }

    final synchronized void zzsr() {
        if (this.state == 2 && this.zzbrb.isEmpty() && this.zzbrc.size() == 0) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
            }
            this.state = 3;
            ConnectionTracker.getInstance().unbindService(zzk.zza(this.zzbrd), (ServiceConnection)this);
        }
    }

    final synchronized void zzss() {
        if (this.state == 1) {
            this.zzb(1, "Timed out while binding");
        }
    }

    final synchronized void zzae(int n) {
        zzt zzt2 = (zzt)this.zzbrc.get(n);
        if (zzt2 != null) {
            Log.w((String)"MessengerIpcClient", (String)new StringBuilder(31).append("Timing out request: ").append(n).toString());
            this.zzbrc.remove(n);
            zzt2.zza(new zzu(3, "Timed out waiting for response"));
            this.zzsr();
        }
    }

    /* synthetic */ zzm(zzk zzk2, zzl zzl2) {
        this(zzk2);
    }
}

