/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.firebase.FirebaseApp;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public final class zzae {
    private final Context zzz;
    @GuardedBy(value="this")
    private String zzbu;
    @GuardedBy(value="this")
    private String zzbv;
    @GuardedBy(value="this")
    private int zzbw;
    @GuardedBy(value="this")
    private int zzbx = 0;

    public zzae(Context context) {
        this.zzz = context;
    }

    public final synchronized int zzx() {
        List list;
        Intent intent;
        if (this.zzbx != 0) {
            return this.zzbx;
        }
        PackageManager packageManager = this.zzz.getPackageManager();
        if (packageManager.checkPermission("com.google.android.c2dm.permission.SEND", "com.google.android.gms") == -1) {
            Log.e((String)"FirebaseInstanceId", (String)"Google Play services missing or without correct permission.");
            return 0;
        }
        if (!PlatformVersion.isAtLeastO()) {
            intent = new Intent("com.google.android.c2dm.intent.REGISTER");
            intent.setPackage("com.google.android.gms");
            list = packageManager.queryIntentServices(intent, 0);
            if (list != null && list.size() > 0) {
                this.zzbx = 1;
                return this.zzbx;
            }
        }
        intent = new Intent("com.google.iid.TOKEN_REQUEST");
        intent.setPackage("com.google.android.gms");
        list = packageManager.queryBroadcastReceivers(intent, 0);
        if (list != null && list.size() > 0) {
            this.zzbx = 2;
            return this.zzbx;
        }
        Log.w((String)"FirebaseInstanceId", (String)"Failed to resolve IID implementation package, falling back");
        this.zzbx = PlatformVersion.isAtLeastO() ? 2 : 1;
        return this.zzbx;
    }

    public static String zza(FirebaseApp firebaseApp) {
        String string = firebaseApp.getOptions().getGcmSenderId();
        if (string != null) {
            return string;
        }
        String string2 = firebaseApp.getOptions().getApplicationId();
        if (!string2.startsWith("1:")) {
            return string2;
        }
        String[] stringArray = string2.split(":");
        if (stringArray.length < 2) {
            return null;
        }
        String string3 = stringArray[1];
        if (string3.isEmpty()) {
            return null;
        }
        return string3;
    }

    public static String zza(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA1").digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)n;
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"FirebaseInstanceId", (String)"Unexpected error, device missing required algorithms");
            return null;
        }
    }

    public final synchronized String zzy() {
        if (this.zzbu == null) {
            this.zzab();
        }
        return this.zzbu;
    }

    public final synchronized String zzz() {
        if (this.zzbv == null) {
            this.zzab();
        }
        return this.zzbv;
    }

    public final synchronized int zzaa() {
        PackageInfo packageInfo;
        if (this.zzbw == 0 && (packageInfo = this.zze("com.google.android.gms")) != null) {
            this.zzbw = packageInfo.versionCode;
        }
        return this.zzbw;
    }

    private final synchronized void zzab() {
        PackageInfo packageInfo = this.zze(this.zzz.getPackageName());
        if (packageInfo != null) {
            this.zzbu = Integer.toString(packageInfo.versionCode);
            this.zzbv = packageInfo.versionName;
        }
    }

    private final PackageInfo zze(String string) {
        try {
            return this.zzz.getPackageManager().getPackageInfo(string, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Failed to find package ").append(string2).toString());
            return null;
        }
    }
}

