/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.util.SimpleArrayMap;
import android.util.Log;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.zzac;
import com.google.firebase.iid.zzae;
import com.google.firebase.iid.zzam;
import com.google.firebase.iid.zzi;
import com.google.firebase.iid.zzs;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;

final class zzal {
    private static int zzbr = 0;
    private static PendingIntent zzcf;
    @GuardedBy(value="responseCallbacks")
    private final SimpleArrayMap<String, TaskCompletionSource<Bundle>> zzcg = new SimpleArrayMap();
    private final Context zzz;
    private final zzae zzal;
    private Messenger zzch;
    private Messenger zzci;
    private zzi zzcj;

    public zzal(Context context, zzae zzae2) {
        this.zzz = context;
        this.zzal = zzae2;
        this.zzch = new Messenger((Handler)new zzam(this, Looper.getMainLooper()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzb(Message message) {
        if (message != null && message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader((ClassLoader)new zzi.zza());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof zzi) {
                    this.zzcj = (zzi)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzci = (Messenger)parcelable;
                }
            }
            Intent intent2 = (Intent)message.obj;
            zzal zzal2 = this;
            String string = intent2.getAction();
            if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string)) {
                if (!Log.isLoggable((String)"FirebaseInstanceId", (int)3)) return;
                String string2 = String.valueOf(string);
                Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Unexpected response action: ".concat(string2) : new String("Unexpected response action: ")));
                return;
            }
            String string3 = intent2.getStringExtra("registration_id");
            if (string3 == null) {
                string3 = intent2.getStringExtra("unregistered");
            }
            if (string3 == null) {
                Intent intent3 = intent2;
                zzal zzal3 = zzal2;
                String string4 = intent3.getStringExtra("error");
                if (string4 == null) {
                    String string5 = String.valueOf(intent3.getExtras());
                    Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(49 + String.valueOf(string5).length()).append("Unexpected response, no error or registration id ").append(string5).toString());
                    return;
                }
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    String string6 = String.valueOf(string4);
                    Log.d((String)"FirebaseInstanceId", (String)(string6.length() != 0 ? "Received InstanceID error ".concat(string6) : new String("Received InstanceID error ")));
                }
                if (string4.startsWith("|")) {
                    String[] stringArray = string4.split("\\|");
                    if (stringArray.length <= 2 || !"ID".equals(stringArray[1])) {
                        String string7 = String.valueOf(string4);
                        Log.w((String)"FirebaseInstanceId", (String)(string7.length() != 0 ? "Unexpected structured response ".concat(string7) : new String("Unexpected structured response ")));
                        return;
                    }
                    String string8 = stringArray[2];
                    string4 = stringArray[3];
                    if (string4.startsWith(":")) {
                        string4 = string4.substring(1);
                    }
                    zzal3.zza(string8, intent3.putExtra("error", string4).getExtras());
                    return;
                }
                SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = zzal3.zzcg;
                synchronized (simpleArrayMap) {
                    int n = 0;
                    while (n < zzal3.zzcg.size()) {
                        zzal3.zza((String)zzal3.zzcg.keyAt(n), intent3.getExtras());
                        ++n;
                    }
                    return;
                }
            }
            Matcher matcher = Pattern.compile("\\|ID\\|([^|]+)\\|:?+(.*)").matcher(string3);
            if (matcher.matches()) {
                String string9 = matcher.group(1);
                String string10 = matcher.group(2);
                Bundle bundle = intent2.getExtras();
                bundle.putString("registration_id", string10);
                zzal2.zza(string9, bundle);
                return;
            }
            if (!Log.isLoggable((String)"FirebaseInstanceId", (int)3)) return;
            String string11 = String.valueOf(string3);
            Log.d((String)"FirebaseInstanceId", (String)(string11.length() != 0 ? "Unexpected response string: ".concat(string11) : new String("Unexpected response string: ")));
            return;
        }
        Log.w((String)"FirebaseInstanceId", (String)"Dropping invalid message");
    }

    private static synchronized void zza(Context context, Intent intent) {
        if (zzcf == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            zzcf = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)zzcf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(String string, Bundle bundle) {
        SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.zzcg;
        synchronized (simpleArrayMap) {
            TaskCompletionSource taskCompletionSource = (TaskCompletionSource)this.zzcg.remove((Object)string);
            if (taskCompletionSource == null) {
                String string2 = String.valueOf(string);
                Log.w((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Missing callback for ".concat(string2) : new String("Missing callback for ")));
                return;
            }
            taskCompletionSource.setResult((Object)bundle);
            return;
        }
    }

    final Bundle zzc(Bundle bundle) throws IOException {
        if (this.zzal.zzaa() >= 12000000) {
            Task<Bundle> task = zzs.zzc(this.zzz).zzb(1, bundle);
            try {
                return (Bundle)Tasks.await(task);
            }
            catch (InterruptedException | ExecutionException exception) {
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    String string = String.valueOf(exception);
                    Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(22 + String.valueOf(string).length()).append("Error making request: ").append(string).toString());
                }
                if (exception.getCause() instanceof zzac && ((zzac)exception.getCause()).getErrorCode() == 4) {
                    return this.zzd(bundle);
                }
                return null;
            }
        }
        return this.zzd(bundle);
    }

    private final Bundle zzd(Bundle bundle) throws IOException {
        Bundle bundle2 = this.zze(bundle);
        if (bundle2 != null && bundle2.containsKey("google.messenger") && (bundle2 = this.zze(bundle)) != null && bundle2.containsKey("google.messenger")) {
            bundle2 = null;
        }
        return bundle2;
    }

    private static synchronized String zzac() {
        return Integer.toString(zzbr++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle zze(Bundle bundle) throws IOException {
        Bundle bundle2;
        TaskCompletionSource taskCompletionSource;
        String string;
        block26: {
            zzal zzal2;
            Intent intent;
            block27: {
                String string2;
                string = com.google.firebase.iid.zzal.zzac();
                taskCompletionSource = new TaskCompletionSource();
                bundle2 = this.zzcg;
                synchronized (bundle2) {
                    this.zzcg.put((Object)string, (Object)taskCompletionSource);
                }
                String string3 = string;
                Bundle bundle3 = bundle;
                zzal zzal3 = this;
                if (zzal3.zzal.zzx() == 0) {
                    throw new IOException("MISSING_INSTANCEID_SERVICE");
                }
                Intent intent2 = new Intent();
                intent2.setPackage("com.google.android.gms");
                if (zzal3.zzal.zzx() == 2) {
                    intent2.setAction("com.google.iid.TOKEN_REQUEST");
                } else {
                    intent2.setAction("com.google.android.c2dm.intent.REGISTER");
                }
                intent2.putExtras(bundle3);
                com.google.firebase.iid.zzal.zza(zzal3.zzz, intent2);
                String string4 = string3;
                intent = intent2;
                zzal2 = zzal3;
                intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string4).length()).append("|ID|").append(string4).append("|").toString());
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    string2 = String.valueOf(intent.getExtras());
                    Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
                }
                intent.putExtra("google.messenger", (Parcelable)zzal2.zzch);
                if (zzal2.zzci != null || zzal2.zzcj != null) {
                    string2 = Message.obtain();
                    Message.obtain().obj = intent;
                    try {
                        if (zzal2.zzci != null) {
                            zzal2.zzci.send((Message)string2);
                        } else {
                            zzal2.zzcj.send((Message)string2);
                        }
                        break block26;
                    }
                    catch (RemoteException remoteException) {
                        if (!Log.isLoggable((String)"FirebaseInstanceId", (int)3)) break block27;
                        Log.d((String)"FirebaseInstanceId", (String)"Messenger failed, fallback to startService");
                    }
                }
            }
            if (zzal2.zzal.zzx() == 2) {
                zzal2.zzz.sendBroadcast(intent);
            } else {
                zzal2.zzz.startService(intent);
            }
        }
        try {
            bundle2 = (Bundle)Tasks.await((Task)taskCompletionSource.getTask(), (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
            return bundle2;
        }
        catch (InterruptedException | TimeoutException exception) {
            Log.w((String)"FirebaseInstanceId", (String)"No response");
            throw new IOException("TIMEOUT");
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException);
        }
        finally {
            SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.zzcg;
            synchronized (simpleArrayMap) {
                this.zzcg.remove((Object)string);
            }
        }
    }

    static /* synthetic */ void zza(zzal zzal2, Message message) {
        zzal2.zzb(message);
    }
}

