/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Parcelable;
import android.os.PowerManager;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdReceiver;
import com.google.firebase.iid.zzae;
import com.google.firebase.iid.zzap;
import com.google.firebase.iid.zzar;
import java.io.IOException;

final class zzaq
implements Runnable {
    private final long zzcw;
    private final PowerManager.WakeLock zzcx;
    private final FirebaseInstanceId zzaw;
    private final zzae zzal;

    @VisibleForTesting
    zzaq(FirebaseInstanceId firebaseInstanceId, zzae zzae2, long l) {
        this.zzaw = firebaseInstanceId;
        this.zzal = zzae2;
        this.zzcw = l;
        PowerManager powerManager = (PowerManager)this.getContext().getSystemService("power");
        this.zzcx = powerManager.newWakeLock(1, "fiid-sync");
        this.zzcx.setReferenceCounted(false);
    }

    @Override
    public final void run() {
        this.zzcx.acquire();
        try {
            this.zzaw.zza(true);
            if (!(this.zzal.zzx() != 0)) {
                this.zzaw.zza(false);
                return;
            }
            if (!this.zzaj()) {
                new zzar(this).zzak();
                return;
            }
            if (this.zzah() && this.zzai()) {
                this.zzaw.zza(false);
            } else {
                this.zzaw.zza(this.zzcw);
            }
            return;
        }
        finally {
            this.zzcx.release();
        }
    }

    @VisibleForTesting
    private final boolean zzah() {
        zzap zzap2 = this.zzaw.zzg();
        if (zzap2 != null && !zzap2.zzj(this.zzal.zzy())) {
            return true;
        }
        try {
            String string = this.zzaw.zzh();
            if (string == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Token retrieval failed: null");
                return false;
            }
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Token successfully retrieved");
            }
            if (zzap2 == null || zzap2 != null && !string.equals(zzap2.zzcu)) {
                Context context = this.getContext();
                Intent intent = new Intent("com.google.firebase.iid.TOKEN_REFRESH");
                Intent intent2 = new Intent("com.google.firebase.INSTANCE_ID_EVENT");
                intent2.setClass(context, FirebaseInstanceIdReceiver.class);
                intent2.putExtra("wrapped_intent", (Parcelable)intent);
                context.sendBroadcast(intent2);
            }
            return true;
        }
        catch (IOException | SecurityException exception) {
            String string = String.valueOf(exception.getMessage());
            Log.e((String)"FirebaseInstanceId", (String)(string.length() != 0 ? "Token retrieval failed: ".concat(string) : new String("Token retrieval failed: ")));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zzai() {
        while (true) {
            String string;
            FirebaseInstanceId firebaseInstanceId = this.zzaw;
            synchronized (firebaseInstanceId) {
                string = FirebaseInstanceId.zzi().zzaf();
                if (string == null) {
                    Log.d((String)"FirebaseInstanceId", (String)"topic sync succeeded");
                    return true;
                }
            }
            if (!this.zzk(string)) {
                return false;
            }
            FirebaseInstanceId.zzi().zzf(string);
        }
    }

    private final boolean zzk(String string) {
        block12: {
            String[] stringArray = string.split("!");
            if (stringArray.length != 2) break block12;
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            try {
                switch (string2) {
                    case "S": {
                        this.zzaw.zzb(string3);
                        if (FirebaseInstanceId.zzj()) {
                            Log.d((String)"FirebaseInstanceId", (String)"subscribe operation succeeded");
                        }
                        break;
                    }
                    case "U": {
                        this.zzaw.zzc(string3);
                        if (FirebaseInstanceId.zzj()) {
                            Log.d((String)"FirebaseInstanceId", (String)"unsubscribe operation succeeded");
                        } else {
                            break;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(iOException.getMessage());
                Log.e((String)"FirebaseInstanceId", (String)(string4.length() != 0 ? "Topic sync failed: ".concat(string4) : new String("Topic sync failed: ")));
                return false;
            }
        }
        return true;
    }

    final Context getContext() {
        return this.zzaw.zze().getApplicationContext();
    }

    final boolean zzaj() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }
}

