/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.internal.firebase_messaging.zzh;
import com.google.firebase.iid.zza;
import com.google.firebase.iid.zzao;
import com.google.firebase.iid.zzq;
import com.google.firebase.iid.zzr;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Properties;

final class zzp {
    zzp() {
    }

    @WorkerThread
    final zzq zzb(Context context, String string) throws zzr {
        zzq zzq2 = this.zzd(context, string);
        if (zzq2 != null) {
            return zzq2;
        }
        return this.zzc(context, string);
    }

    @WorkerThread
    final zzq zzc(Context context, String string) {
        zzq zzq2 = new zzq(zza.zzb(), System.currentTimeMillis());
        try {
            zzq zzq3 = this.zzd(context, string);
            if (zzq3 != null) {
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    Log.d((String)"FirebaseInstanceId", (String)"Loaded key after generating new one, using loaded one");
                }
                return zzq3;
            }
        }
        catch (zzr zzr2) {}
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Generated new key");
        }
        zzp.zza(context, string, zzq2);
        this.zzb(context, string, zzq2);
        return zzq2;
    }

    static void zza(Context context) {
        for (File file : zzp.zzb(context).listFiles()) {
            if (!file.getName().startsWith("com.google.InstanceId")) continue;
            file.delete();
        }
    }

    @Nullable
    private final zzq zzd(Context context, String string) throws zzr {
        zzq zzq2;
        Object var3_3 = null;
        try {
            zzq2 = this.zze(context, string);
            if (zzq2 != null) {
                this.zzb(context, string, zzq2);
                return zzq2;
            }
        }
        catch (zzr zzr2) {
            // empty catch block
        }
        try {
            String string2 = string;
            Context context2 = context;
            zzq2 = zzp.zza(context2.getSharedPreferences("com.google.android.gms.appid", 0), string2);
            if (zzq2 != null) {
                zzp.zza(context, string, zzq2);
                return zzq2;
            }
        }
        catch (zzr zzr3) {
            // empty catch block
        }
        if (var3_3 != null) {
            throw var3_3;
        }
        return null;
    }

    private static KeyPair zzc(String string, String string2) throws zzr {
        byte[] byArray;
        byte[] byArray2;
        try {
            byArray2 = Base64.decode((String)string, (int)8);
            byArray = Base64.decode((String)string2, (int)8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new zzr(illegalArgumentException);
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(byArray2));
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            String string3 = String.valueOf(generalSecurityException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(19 + String.valueOf(string3).length()).append("Invalid key stored ").append(string3).toString());
            throw new zzr(generalSecurityException);
        }
    }

    @Nullable
    private final zzq zze(Context context, String string) throws zzr {
        File file = zzp.zzf(context, string);
        if (!file.exists()) {
            return null;
        }
        try {
            return zzp.zza(file);
        }
        catch (IOException iOException) {
            String string2;
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                string2 = String.valueOf(iOException);
                Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(40 + String.valueOf(string2).length()).append("Failed to read key from file, retrying: ").append(string2).toString());
            }
            try {
                return zzp.zza(file);
            }
            catch (IOException iOException2) {
                string2 = String.valueOf(iOException2);
                Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(45 + String.valueOf(string2).length()).append("IID file exists, but failed to read from it: ").append(string2).toString());
                throw new zzr(iOException2);
            }
        }
    }

    private static void zza(Context context, String string, zzq zzq2) {
        try {
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Writing key to properties file");
            }
            File file = zzp.zzf(context, string);
            file.createNewFile();
            Properties properties = new Properties();
            properties.setProperty("pub", zzq.zza(zzq2));
            properties.setProperty("pri", zzq.zzb(zzq2));
            properties.setProperty("cre", String.valueOf(zzq.zzc(zzq2)));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Throwable throwable = null;
            try {
                properties.store(fileOutputStream, null);
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    zzp.zza(throwable, fileOutputStream);
                    throw throwable4;
                }
            }
            zzp.zza(null, fileOutputStream);
            return;
        }
        catch (IOException iOException) {
            String string2 = String.valueOf(iOException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(21 + String.valueOf(string2).length()).append("Failed to write key: ").append(string2).toString());
            return;
        }
    }

    private static File zzb(Context context) {
        File file = ContextCompat.getNoBackupFilesDir((Context)context);
        if (file != null && file.isDirectory()) {
            return file;
        }
        Log.w((String)"FirebaseInstanceId", (String)"noBackupFilesDir doesn't exist, using regular files directory instead");
        return context.getFilesDir();
    }

    private static File zzf(Context context, String string) {
        String string2;
        if (TextUtils.isEmpty((CharSequence)string)) {
            string2 = "com.google.InstanceId.properties";
        } else {
            try {
                String string3 = Base64.encodeToString((byte[])string.getBytes("UTF-8"), (int)11);
                string2 = new StringBuilder(33 + String.valueOf(string3).length()).append("com.google.InstanceId_").append(string3).append(".properties").toString();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
        }
        return new File(zzp.zzb(context), string2);
    }

    @Nullable
    private static zzq zza(File file) throws zzr, IOException {
        zzq zzq2;
        String string;
        String string2;
        Serializable serializable;
        Throwable throwable;
        FileInputStream fileInputStream;
        block7: {
            fileInputStream = new FileInputStream(file);
            throwable = null;
            serializable = new Properties();
            ((Properties)serializable).load(fileInputStream);
            string2 = ((Properties)serializable).getProperty("pub");
            string = ((Properties)serializable).getProperty("pri");
            if (string2 != null && string != null) break block7;
            zzp.zza(null, fileInputStream);
            return null;
        }
        try {
            long l;
            KeyPair keyPair = zzp.zzc(string2, string);
            try {
                l = Long.parseLong(((Properties)serializable).getProperty("cre"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new zzr(numberFormatException);
            }
            zzq2 = new zzq(keyPair, l);
        }
        catch (Throwable throwable2) {
            try {
                serializable = throwable2;
                throwable = throwable2;
                throw serializable;
            }
            catch (Throwable throwable3) {
                zzp.zza(throwable, fileInputStream);
                throw throwable3;
            }
        }
        zzp.zza(null, fileInputStream);
        return zzq2;
    }

    @Nullable
    private static zzq zza(SharedPreferences sharedPreferences, String string) throws zzr {
        String string2 = sharedPreferences.getString(zzao.zzd(string, "|P|"), null);
        String string3 = sharedPreferences.getString(zzao.zzd(string, "|K|"), null);
        if (string2 == null || string3 == null) {
            return null;
        }
        KeyPair keyPair = zzp.zzc(string2, string3);
        long l = zzp.zzb(sharedPreferences, string);
        return new zzq(keyPair, l);
    }

    private final void zzb(Context context, String string, zzq zzq2) {
        zzq zzq3;
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.appid", 0);
        try {
            zzq3 = zzp.zza(sharedPreferences, string);
            if (zzq2.equals(zzq3)) {
                return;
            }
        }
        catch (zzr zzr2) {}
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Writing key to shared preferences");
        }
        zzq3 = sharedPreferences.edit();
        zzq3.putString(zzao.zzd(string, "|P|"), zzq.zza(zzq2));
        zzq3.putString(zzao.zzd(string, "|K|"), zzq.zzb(zzq2));
        zzq3.putString(zzao.zzd(string, "cre"), String.valueOf(zzq.zzc(zzq2)));
        zzq3.commit();
    }

    private static long zzb(SharedPreferences sharedPreferences, String string) {
        String string2 = sharedPreferences.getString(zzao.zzd(string, "cre"), null);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0L;
    }

    private static /* synthetic */ void zza(Throwable throwable, FileOutputStream fileOutputStream) {
        if (throwable != null) {
            try {
                fileOutputStream.close();
                return;
            }
            catch (Throwable throwable2) {
                zzh.zza(throwable, throwable2);
                return;
            }
        }
        fileOutputStream.close();
    }

    private static /* synthetic */ void zza(Throwable throwable, FileInputStream fileInputStream) {
        if (throwable != null) {
            try {
                fileInputStream.close();
                return;
            }
            catch (Throwable throwable2) {
                zzh.zza(throwable, throwable2);
                return;
            }
        }
        fileInputStream.close();
    }
}

