/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.firebase.iid.zzab;
import com.google.firebase.iid.zzac;
import com.google.firebase.iid.zzs;
import com.google.firebase.iid.zzt;
import com.google.firebase.iid.zzv;
import com.google.firebase.iid.zzw;
import com.google.firebase.iid.zzx;
import com.google.firebase.iid.zzz;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

final class zzu
implements ServiceConnection {
    @GuardedBy(value="this")
    int state = 0;
    final Messenger zzbj = new Messenger(new Handler(Looper.getMainLooper(), (Handler.Callback)new zzv(this)));
    zzz zzbk;
    @GuardedBy(value="this")
    final Queue<zzab<?>> zzbl = new ArrayDeque();
    @GuardedBy(value="this")
    final SparseArray<zzab<?>> zzbm = new SparseArray();
    final /* synthetic */ zzs zzbn;

    private zzu(zzs zzs2) {
        this.zzbn = zzs2;
    }

    final synchronized boolean zzb(zzab zzab2) {
        switch (this.state) {
            case 0: {
                this.zzbl.add(zzab2);
                zzu zzu2 = this;
                Preconditions.checkState((zzu2.state == 0 ? 1 : 0) != 0);
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
                }
                zzu2.state = 1;
                Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
                intent.setPackage("com.google.android.gms");
                if (!ConnectionTracker.getInstance().bindService(zzs.zza(zzu2.zzbn), intent, (ServiceConnection)zzu2, 1)) {
                    zzu2.zza(0, "Unable to bind to service");
                } else {
                    zzs.zzb(zzu2.zzbn).schedule(new zzw(zzu2), 30L, TimeUnit.SECONDS);
                }
                return true;
            }
            case 1: {
                this.zzbl.add(zzab2);
                return true;
            }
            case 2: {
                this.zzbl.add(zzab2);
                this.zzt();
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        int n = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(Message message) {
        zzab zzab2;
        int n = message.arg1;
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            Log.d((String)"MessengerIpcClient", (String)new StringBuilder(41).append("Received response to request: ").append(n).toString());
        }
        zzu zzu2 = this;
        synchronized (zzu2) {
            zzab2 = (zzab)this.zzbm.get(n);
            if (zzab2 == null) {
                Log.w((String)"MessengerIpcClient", (String)new StringBuilder(50).append("Received response for unknown request: ").append(n).toString());
                return true;
            }
            this.zzbm.remove(n);
            this.zzu();
        }
        Bundle bundle = message.getData();
        zzab zzab3 = zzab2;
        if (bundle.getBoolean("unsupported", false)) {
            zzab3.zza(new zzac(4, "Not supported by GmsCore"));
        } else {
            zzab3.zzb(bundle);
        }
        return true;
    }

    public final synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service connected");
        }
        if (iBinder == null) {
            this.zza(0, "Null service connection");
            return;
        }
        try {
            this.zzbk = new zzz(iBinder);
        }
        catch (RemoteException remoteException) {
            this.zza(0, remoteException.getMessage());
            return;
        }
        this.state = 2;
        this.zzt();
    }

    private final void zzt() {
        zzs.zzb(this.zzbn).execute(new zzx(this));
    }

    public final synchronized void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
        }
        this.zza(2, "Service disconnected");
    }

    final synchronized void zza(int n, String string) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"MessengerIpcClient", (String)(string2.length() != 0 ? "Disconnected: ".concat(string2) : new String("Disconnected: ")));
        }
        switch (this.state) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: 
            case 2: {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                }
                this.state = 4;
                ConnectionTracker.getInstance().unbindService(zzs.zza(this.zzbn), (ServiceConnection)this);
                zzac zzac2 = new zzac(n, string);
                zzu zzu2 = this;
                Iterator iterator = zzu2.zzbl.iterator();
                while (iterator.hasNext()) {
                    ((zzab)iterator.next()).zza(zzac2);
                }
                zzu2.zzbl.clear();
                for (int i = 0; i < zzu2.zzbm.size(); ++i) {
                    ((zzab)zzu2.zzbm.valueAt(i)).zza(zzac2);
                }
                zzu2.zzbm.clear();
                return;
            }
            case 3: {
                this.state = 4;
                return;
            }
            case 4: {
                return;
            }
        }
        int n2 = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n2).toString());
    }

    final synchronized void zzu() {
        if (this.state == 2 && this.zzbl.isEmpty() && this.zzbm.size() == 0) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
            }
            this.state = 3;
            ConnectionTracker.getInstance().unbindService(zzs.zza(this.zzbn), (ServiceConnection)this);
        }
    }

    final synchronized void zzv() {
        if (this.state == 1) {
            this.zza(1, "Timed out while binding");
        }
    }

    final synchronized void zza(int n) {
        zzab zzab2 = (zzab)this.zzbm.get(n);
        if (zzab2 != null) {
            Log.w((String)"MessengerIpcClient", (String)new StringBuilder(31).append("Timing out request: ").append(n).toString());
            this.zzbm.remove(n);
            zzab2.zza(new zzac(3, "Timed out waiting for response"));
            this.zzu();
        }
    }

    /* synthetic */ zzu(zzs zzs2, zzt zzt2) {
        this(zzs2);
    }
}

