/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Parcelable;
import android.os.PowerManager;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdReceiver;
import com.google.firebase.iid.zzah;
import com.google.firebase.iid.zzar;
import com.google.firebase.iid.zzat;
import com.google.firebase.iid.zzau;
import java.io.IOException;

final class zzas
implements Runnable {
    private final long zzdb;
    private final PowerManager.WakeLock zzdc;
    private final FirebaseInstanceId zzdd;
    private final zzah zzao;
    private final zzau zzar;

    @VisibleForTesting
    zzas(FirebaseInstanceId firebaseInstanceId, zzah zzah2, zzau zzau2, long l) {
        this.zzdd = firebaseInstanceId;
        this.zzao = zzah2;
        this.zzar = zzau2;
        this.zzdb = l;
        PowerManager powerManager = (PowerManager)this.getContext().getSystemService("power");
        this.zzdc = powerManager.newWakeLock(1, "fiid-sync");
        this.zzdc.setReferenceCounted(false);
    }

    @Override
    public final void run() {
        this.zzdc.acquire();
        try {
            this.zzdd.zza(true);
            if (!(this.zzao.zzw() != 0)) {
                this.zzdd.zza(false);
                return;
            }
            if (!this.zzah()) {
                new zzat(this).zzai();
                return;
            }
            if (this.zzag() && this.zzar.zza(this.zzdd)) {
                this.zzdd.zza(false);
            } else {
                this.zzdd.zza(this.zzdb);
            }
            return;
        }
        finally {
            this.zzdc.release();
        }
    }

    @VisibleForTesting
    private final boolean zzag() {
        zzar zzar2 = this.zzdd.zzg();
        if (zzar2 != null && !zzar2.zzj(this.zzao.zzx())) {
            return true;
        }
        try {
            String string = this.zzdd.zzh();
            if (string == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Token retrieval failed: null");
                return false;
            }
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Token successfully retrieved");
            }
            if (zzar2 == null || zzar2 != null && !string.equals(zzar2.zzcz)) {
                Context context = this.getContext();
                Intent intent = new Intent("com.google.firebase.iid.TOKEN_REFRESH");
                Intent intent2 = new Intent("com.google.firebase.INSTANCE_ID_EVENT");
                intent2.setClass(context, FirebaseInstanceIdReceiver.class);
                intent2.putExtra("wrapped_intent", (Parcelable)intent);
                context.sendBroadcast(intent2);
            }
            return true;
        }
        catch (IOException | SecurityException exception) {
            String string = String.valueOf(exception.getMessage());
            Log.e((String)"FirebaseInstanceId", (String)(string.length() != 0 ? "Token retrieval failed: ".concat(string) : new String("Token retrieval failed: ")));
            return false;
        }
    }

    final Context getContext() {
        return this.zzdd.zze().getApplicationContext();
    }

    final boolean zzah() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }
}

