/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.firebase.iid.zzaa;
import com.google.firebase.iid.zzac;
import com.google.firebase.iid.zzad;
import com.google.firebase.iid.zzae;
import com.google.firebase.iid.zzag;
import com.google.firebase.iid.zzai;
import com.google.firebase.iid.zzaj;
import com.google.firebase.iid.zzz;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

final class zzab
implements ServiceConnection {
    @GuardedBy(value="this")
    int state = 0;
    final Messenger zzbo = new Messenger(new Handler(Looper.getMainLooper(), (Handler.Callback)new zzac(this)));
    zzag zzbp;
    @GuardedBy(value="this")
    final Queue<zzai<?>> zzbq = new ArrayDeque();
    @GuardedBy(value="this")
    final SparseArray<zzai<?>> zzbr = new SparseArray();
    final /* synthetic */ zzz zzbs;

    private zzab(zzz zzz2) {
        this.zzbs = zzz2;
    }

    final synchronized boolean zzb(zzai zzai2) {
        switch (this.state) {
            case 0: {
                this.zzbq.add(zzai2);
                zzab zzab2 = this;
                Preconditions.checkState((zzab2.state == 0 ? 1 : 0) != 0);
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
                }
                zzab2.state = 1;
                Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
                intent.setPackage("com.google.android.gms");
                if (!ConnectionTracker.getInstance().bindService(zzz.zza(zzab2.zzbs), intent, (ServiceConnection)zzab2, 1)) {
                    zzab2.zza(0, "Unable to bind to service");
                } else {
                    zzz.zzb(zzab2.zzbs).schedule(new zzad(zzab2), 30L, TimeUnit.SECONDS);
                }
                return true;
            }
            case 1: {
                this.zzbq.add(zzai2);
                return true;
            }
            case 2: {
                this.zzbq.add(zzai2);
                this.zzx();
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        int n = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(Message message) {
        zzai zzai2;
        int n = message.arg1;
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            Log.d((String)"MessengerIpcClient", (String)new StringBuilder(41).append("Received response to request: ").append(n).toString());
        }
        zzab zzab2 = this;
        synchronized (zzab2) {
            zzai2 = (zzai)this.zzbr.get(n);
            if (zzai2 == null) {
                Log.w((String)"MessengerIpcClient", (String)new StringBuilder(50).append("Received response for unknown request: ").append(n).toString());
                return true;
            }
            this.zzbr.remove(n);
            this.zzy();
        }
        Bundle bundle = message.getData();
        zzai zzai3 = zzai2;
        if (bundle.getBoolean("unsupported", false)) {
            zzai3.zza(new zzaj(4, "Not supported by GmsCore"));
        } else {
            zzai3.zzb(bundle);
        }
        return true;
    }

    public final synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service connected");
        }
        if (iBinder == null) {
            this.zza(0, "Null service connection");
            return;
        }
        try {
            this.zzbp = new zzag(iBinder);
        }
        catch (RemoteException remoteException) {
            this.zza(0, remoteException.getMessage());
            return;
        }
        this.state = 2;
        this.zzx();
    }

    private final void zzx() {
        zzz.zzb(this.zzbs).execute(new zzae(this));
    }

    public final synchronized void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
        }
        this.zza(2, "Service disconnected");
    }

    final synchronized void zza(int n, String string) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"MessengerIpcClient", (String)(string2.length() != 0 ? "Disconnected: ".concat(string2) : new String("Disconnected: ")));
        }
        switch (this.state) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: 
            case 2: {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                }
                this.state = 4;
                ConnectionTracker.getInstance().unbindService(zzz.zza(this.zzbs), (ServiceConnection)this);
                zzaj zzaj2 = new zzaj(n, string);
                zzab zzab2 = this;
                Iterator iterator = zzab2.zzbq.iterator();
                while (iterator.hasNext()) {
                    ((zzai)iterator.next()).zza(zzaj2);
                }
                zzab2.zzbq.clear();
                for (int i = 0; i < zzab2.zzbr.size(); ++i) {
                    ((zzai)zzab2.zzbr.valueAt(i)).zza(zzaj2);
                }
                zzab2.zzbr.clear();
                return;
            }
            case 3: {
                this.state = 4;
                return;
            }
            case 4: {
                return;
            }
        }
        int n2 = this.state;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n2).toString());
    }

    final synchronized void zzy() {
        if (this.state == 2 && this.zzbq.isEmpty() && this.zzbr.size() == 0) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
            }
            this.state = 3;
            ConnectionTracker.getInstance().unbindService(zzz.zza(this.zzbs), (ServiceConnection)this);
        }
    }

    final synchronized void zzz() {
        if (this.state == 1) {
            this.zza(1, "Timed out while binding");
        }
    }

    final synchronized void zza(int n) {
        zzai zzai2 = (zzai)this.zzbr.get(n);
        if (zzai2 != null) {
            Log.w((String)"MessengerIpcClient", (String)new StringBuilder(31).append("Timing out request: ").append(n).toString());
            this.zzbr.remove(n);
            zzai2.zza(new zzaj(3, "Timed out waiting for response"));
            this.zzy();
        }
    }

    /* synthetic */ zzab(zzz zzz2, zzaa zzaa2) {
        this(zzz2);
    }
}

