/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.PowerManager;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzal;
import com.google.firebase.iid.zzat;
import com.google.firebase.iid.zzav;
import com.google.firebase.iid.zzax;
import com.google.firebase.iid.zzay;
import java.io.IOException;

final class zzaw
implements Runnable {
    private final long zzcy;
    private final PowerManager.WakeLock zzcz;
    private final FirebaseInstanceId zzda;
    private final zzal zzak;
    private final zzay zzan;

    @VisibleForTesting
    zzaw(FirebaseInstanceId firebaseInstanceId, zzal zzal2, zzay zzay2, long l) {
        this.zzda = firebaseInstanceId;
        this.zzak = zzal2;
        this.zzan = zzay2;
        this.zzcy = l;
        PowerManager powerManager = (PowerManager)this.getContext().getSystemService("power");
        this.zzcz = powerManager.newWakeLock(1, "fiid-sync");
        this.zzcz.setReferenceCounted(false);
    }

    @Override
    public final void run() {
        this.zzcz.acquire();
        try {
            this.zzda.zza(true);
            if (!this.zzda.zzm()) {
                this.zzda.zza(false);
                return;
            }
            if (!this.zzan()) {
                new zzax(this).zzao();
                return;
            }
            if (this.zzal() && this.zzam() && this.zzan.zza(this.zzda)) {
                this.zzda.zza(false);
            } else {
                this.zzda.zza(this.zzcy);
            }
            return;
        }
        finally {
            this.zzcz.release();
        }
    }

    @VisibleForTesting
    private final boolean zzal() {
        try {
            if (!this.zzda.zzn()) {
                this.zzda.zzo();
            }
            return true;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            Log.e((String)"FirebaseInstanceId", (String)(string.length() != 0 ? "Build channel failed: ".concat(string) : new String("Build channel failed: ")));
            return false;
        }
    }

    @VisibleForTesting
    private final boolean zzam() {
        zzav zzav2 = this.zzda.zzi();
        if (zzav2 != null && !zzav2.zzj(this.zzak.zzac())) {
            return true;
        }
        try {
            String string = this.zzda.zzj();
            if (string == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Token retrieval failed: null");
                return false;
            }
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Token successfully retrieved");
            }
            if (zzav2 == null || zzav2 != null && !string.equals(zzav2.zzbh)) {
                String string2;
                String string3 = string2 = string;
                Context context = this.getContext();
                Intent intent = new Intent("com.google.firebase.messaging.NEW_TOKEN");
                intent.putExtra("token", string3);
                zzat.zzc(context, intent);
                Intent intent2 = new Intent("com.google.firebase.iid.TOKEN_REFRESH");
                zzat.zzb(context, intent2);
            }
            return true;
        }
        catch (IOException | SecurityException exception) {
            String string = String.valueOf(exception.getMessage());
            Log.e((String)"FirebaseInstanceId", (String)(string.length() != 0 ? "Token retrieval failed: ".concat(string) : new String("Token retrieval failed: ")));
            return false;
        }
    }

    final Context getContext() {
        return this.zzda.zzg().getApplicationContext();
    }

    final boolean zzan() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }
}

