/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.events.EventHandler;
import com.google.firebase.events.Subscriber;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.MessagingChannel;
import com.google.firebase.iid.zzam;
import com.google.firebase.iid.zzap;
import com.google.firebase.iid.zzav;
import com.google.firebase.iid.zzaw;
import com.google.firebase.iid.zzax;
import com.google.firebase.iid.zzaz;
import com.google.firebase.iid.zzi;
import com.google.firebase.iid.zzm;
import com.google.firebase.iid.zzn;
import com.google.firebase.iid.zzo;
import com.google.firebase.iid.zzp;
import com.google.firebase.iid.zzq;
import com.google.firebase.iid.zzw;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseInstanceId {
    private static final long zzaf = TimeUnit.HOURS.toSeconds(8L);
    private static zzav zzag;
    @GuardedBy(value="FirebaseInstanceId.class")
    @VisibleForTesting
    private static ScheduledThreadPoolExecutor zzah;
    private final Executor zzai;
    private final FirebaseApp zzaj;
    private final zzam zzak;
    private MessagingChannel zzal;
    private final zzap zzam = new zzap();
    private final zzaz zzan;
    @GuardedBy(value="this")
    private boolean zzao = false;
    private final zza zzap;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static synchronized FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseInstanceId)firebaseApp.get(FirebaseInstanceId.class);
    }

    FirebaseInstanceId(FirebaseApp firebaseApp, Subscriber subscriber) {
        this(firebaseApp, new zzam(firebaseApp.getApplicationContext()), zzi.zze(), zzi.zze(), subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FirebaseInstanceId(FirebaseApp firebaseApp, zzam zzam2, Executor executor, Executor executor2, Subscriber subscriber) {
        if (com.google.firebase.iid.zzam.zza(firebaseApp) == null) {
            throw new IllegalStateException("FirebaseInstanceId failed to initialize, FirebaseApp is missing project ID");
        }
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzag == null) {
                zzag = new zzav(firebaseApp.getApplicationContext());
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            this.zzaj = firebaseApp;
            this.zzak = zzam2;
            Executor executor3 = executor;
            zzam zzam3 = zzam2;
            FirebaseApp firebaseApp2 = firebaseApp;
            FirebaseInstanceId firebaseInstanceId = this;
            if (firebaseInstanceId.zzal == null) {
                MessagingChannel messagingChannel = (MessagingChannel)firebaseApp2.get(MessagingChannel.class);
                firebaseInstanceId.zzal = messagingChannel != null && messagingChannel.isAvailable() ? messagingChannel : new zzq(firebaseApp2, zzam3, executor3);
            }
            this.zzal = firebaseInstanceId.zzal;
            this.zzai = executor2;
            this.zzan = new zzaz(zzag);
            this.zzap = new zza(subscriber);
            if (this.zzap.isEnabled()) {
                this.zzf();
            }
            return;
        }
    }

    private final void zzf() {
        zzaw zzaw2 = this.zzi();
        if (!this.zzn() || zzaw2 == null || zzaw2.zzj(this.zzak.zzac()) || this.zzan.zzap()) {
            this.startSync();
        }
    }

    final FirebaseApp zzg() {
        return this.zzaj;
    }

    final synchronized void zza(boolean bl) {
        this.zzao = bl;
    }

    private final synchronized void startSync() {
        if (!this.zzao) {
            this.zza(0L);
        }
    }

    final synchronized void zza(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zzaf);
        FirebaseInstanceId.zza(new zzax(this, this.zzak, this.zzan, l2), l);
        this.zzao = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzah == null) {
                zzah = new ScheduledThreadPoolExecutor(1);
            }
            zzah.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    public String getId() {
        this.zzf();
        return FirebaseInstanceId.zzh();
    }

    private static String zzh() {
        return com.google.firebase.iid.zzam.zza(zzag.zzg("").getKeyPair());
    }

    public long getCreationTime() {
        return zzag.zzg("").getCreationTime();
    }

    @NonNull
    public Task<InstanceIdResult> getInstanceId() {
        return this.zza(com.google.firebase.iid.zzam.zza(this.zzaj), "*");
    }

    private final Task<InstanceIdResult> zza(String string, String string2) {
        String string3 = FirebaseInstanceId.zzd(string2);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzai.execute(new zzm(this, string, string2, taskCompletionSource, string3));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        String string = FirebaseInstanceId.zzh();
        this.zza(this.zzal.deleteInstanceId(string));
        this.zzl();
    }

    @Deprecated
    @Nullable
    public String getToken() {
        zzaw zzaw2 = this.zzi();
        if (zzaw2 == null || zzaw2.zzj(this.zzak.zzac())) {
            this.startSync();
        }
        if (zzaw2 != null) {
            return zzaw2.zzbn;
        }
        return null;
    }

    @Nullable
    final zzaw zzi() {
        return FirebaseInstanceId.zzb(com.google.firebase.iid.zzam.zza(this.zzaj), "*");
    }

    @Nullable
    @VisibleForTesting
    private static zzaw zzb(String string, String string2) {
        return zzag.zzb("", string, string2);
    }

    final String zzj() throws IOException {
        return this.getToken(com.google.firebase.iid.zzam.zza(this.zzaj), "*");
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        return this.zza(this.zza(string, string2)).getToken();
    }

    private final <T> T zza(Task<T> task) throws IOException {
        try {
            return (T)Tasks.await(task, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                if ("INSTANCE_ID_RESET".equals(throwable.getMessage())) {
                    this.zzl();
                }
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IOException(executionException2);
        }
        catch (InterruptedException | TimeoutException exception) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        string2 = FirebaseInstanceId.zzd(string2);
        String string3 = FirebaseInstanceId.zzh();
        String string4 = zzaw.zza(FirebaseInstanceId.zzb(string, string2));
        this.zza(this.zzal.deleteToken(string3, string4, string, string2));
        zzag.zzc("", string, string2);
    }

    public final synchronized Task<Void> zza(String string) {
        Task<Void> task = this.zzan.zza(string);
        this.startSync();
        return task;
    }

    final void zzb(String string) throws IOException {
        zzaw zzaw2 = this.zzi();
        if (zzaw2 == null || zzaw2.zzj(this.zzak.zzac())) {
            throw new IOException("token not available");
        }
        String string2 = FirebaseInstanceId.zzh();
        String string3 = string;
        String string4 = zzaw2.zzbn;
        String string5 = string2;
        Task<Void> task = this.zzal.subscribeToTopic(string5, string4, string3);
        this.zza(task);
    }

    final void zzc(String string) throws IOException {
        zzaw zzaw2 = this.zzi();
        if (zzaw2 == null || zzaw2.zzj(this.zzak.zzac())) {
            throw new IOException("token not available");
        }
        String string2 = FirebaseInstanceId.zzh();
        this.zza(this.zzal.unsubscribeFromTopic(string2, zzaw2.zzbn, string));
    }

    static boolean zzk() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }

    final synchronized void zzl() {
        zzag.zzak();
        if (this.zzap.isEnabled()) {
            this.startSync();
        }
    }

    final boolean zzm() {
        return this.zzal.isAvailable();
    }

    final boolean zzn() {
        return this.zzal.isChannelBuilt();
    }

    final void zzo() throws IOException {
        String string = FirebaseInstanceId.zzh();
        String string2 = zzaw.zza(this.zzi());
        this.zza(this.zzal.buildChannel(string, string2));
    }

    final void zzp() {
        zzag.zzh("");
        this.startSync();
    }

    @VisibleForTesting
    public final boolean zzq() {
        return this.zzap.isEnabled();
    }

    @VisibleForTesting
    public final void zzb(boolean bl) {
        this.zzap.setEnabled(bl);
    }

    private static String zzd(String string) {
        if (string.isEmpty() || string.equalsIgnoreCase("fcm") || string.equalsIgnoreCase("gcm")) {
            return "*";
        }
        return string;
    }

    final /* synthetic */ void zza(String string, String string2, TaskCompletionSource taskCompletionSource, String string3) {
        String string4 = FirebaseInstanceId.zzh();
        zzaw zzaw2 = FirebaseInstanceId.zzb(string, string2);
        if (zzaw2 != null && !zzaw2.zzj(this.zzak.zzac())) {
            taskCompletionSource.setResult((Object)new zzw(string4, zzaw2.zzbn));
            return;
        }
        String string5 = zzaw.zza(zzaw2);
        this.zzam.zza(string, string3, new zzn(this, string4, string5, string, string3)).addOnCompleteListener(this.zzai, (OnCompleteListener)new zzo(this, string, string3, taskCompletionSource, string4));
    }

    final /* synthetic */ void zza(String string, String string2, TaskCompletionSource taskCompletionSource, String string3, Task task) {
        if (task.isSuccessful()) {
            String string4 = (String)task.getResult();
            zzag.zza("", string, string2, string4, this.zzak.zzac());
            taskCompletionSource.setResult((Object)new zzw(string3, string4));
            return;
        }
        taskCompletionSource.setException(task.getException());
    }

    final /* synthetic */ Task zza(String string, String string2, String string3, String string4) {
        return this.zzal.getToken(string, string2, string3, string4);
    }

    private final class zza {
        private final boolean zzaw;
        private final Subscriber zzax;
        @GuardedBy(value="this")
        @Nullable
        private EventHandler<DataCollectionDefaultChange> zzay;
        @GuardedBy(value="this")
        @Nullable
        private Boolean zzaz;

        zza(Subscriber subscriber) {
            this.zzax = subscriber;
            this.zzaw = this.zzt();
            this.zzaz = this.zzs();
            if (this.zzaz == null && this.zzaw) {
                this.zzay = new zzp(this);
                subscriber.subscribe(DataCollectionDefaultChange.class, this.zzay);
            }
        }

        final synchronized boolean isEnabled() {
            if (this.zzaz != null) {
                return this.zzaz;
            }
            return this.zzaw && FirebaseInstanceId.this.zzaj.isDataCollectionDefaultEnabled();
        }

        final synchronized void setEnabled(boolean bl) {
            if (this.zzay != null) {
                this.zzax.unsubscribe(DataCollectionDefaultChange.class, this.zzay);
                this.zzay = null;
            }
            SharedPreferences.Editor editor = FirebaseInstanceId.this.zzaj.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
            editor.putBoolean("auto_init", bl);
            editor.apply();
            if (bl) {
                FirebaseInstanceId.this.zzf();
            }
            this.zzaz = bl;
        }

        @Nullable
        private final Boolean zzs() {
            Context context = FirebaseInstanceId.this.zzaj.getApplicationContext();
            SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
            if (sharedPreferences.contains("auto_init")) {
                return sharedPreferences.getBoolean("auto_init", false);
            }
            try {
                ApplicationInfo applicationInfo;
                PackageManager packageManager = context.getPackageManager();
                if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("firebase_messaging_auto_init_enabled")) {
                    return applicationInfo.metaData.getBoolean("firebase_messaging_auto_init_enabled");
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
            return null;
        }

        private final boolean zzt() {
            try {
                Class.forName("com.google.firebase.messaging.FirebaseMessaging");
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Context context = FirebaseInstanceId.this.zzaj.getApplicationContext();
                Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
                intent.setPackage(context.getPackageName());
                ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
                return resolveInfo != null && resolveInfo.serviceInfo != null;
            }
        }
    }
}

