/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.firebase.iid.zzau;
import com.google.firebase.iid.zzh;
import javax.annotation.concurrent.GuardedBy;

public final class FirebaseInstanceIdReceiver
extends WakefulBroadcastReceiver {
    private static boolean zzbc = false;
    @GuardedBy(value="FirebaseInstanceIdReceiver.class")
    private static zzh zzbd;
    @GuardedBy(value="FirebaseInstanceIdReceiver.class")
    private static zzh zzbe;

    public FirebaseInstanceIdReceiver() {
    }

    public final void onReceive(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        Parcelable parcelable = intent.getParcelableExtra("wrapped_intent");
        Intent intent2 = parcelable instanceof Intent ? (Intent)parcelable : null;
        if (intent2 != null) {
            this.zza(context, intent2, intent.getAction());
            return;
        }
        this.zza(context, intent, intent.getAction());
    }

    private final void zza(Context context, Intent intent, String string) {
        String string2;
        intent.setComponent(null);
        intent.setPackage(context.getPackageName());
        if (Build.VERSION.SDK_INT <= 18) {
            intent.removeCategory(context.getPackageName());
        }
        if ((string2 = intent.getStringExtra("gcm.rawData64")) != null) {
            intent.putExtra("rawData", Base64.decode((String)string2, (int)0));
            intent.removeExtra("gcm.rawData64");
        }
        String string3 = null;
        String string4 = intent.getStringExtra("from");
        if ("google.com/iid".equals(string4) || "com.google.firebase.INSTANCE_ID_EVENT".equals(string)) {
            string3 = "com.google.firebase.INSTANCE_ID_EVENT";
        } else if ("com.google.android.c2dm.intent.RECEIVE".equals(string) || "com.google.firebase.MESSAGING_EVENT".equals(string)) {
            string3 = "com.google.firebase.MESSAGING_EVENT";
        } else {
            Log.d((String)"FirebaseInstanceId", (String)"Unexpected intent");
        }
        int n = -1;
        if (string3 != null) {
            n = FirebaseInstanceIdReceiver.zza((BroadcastReceiver)this, context, string3, intent);
        }
        if (this.isOrderedBroadcast()) {
            this.setResultCode(n);
        }
    }

    public static int zza(BroadcastReceiver broadcastReceiver, Context context, String string, Intent intent) {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Starting service: ".concat(string2) : new String("Starting service: ")));
        }
        if (PlatformVersion.isAtLeastO() && context.getApplicationInfo().targetSdkVersion >= 26) {
            if (broadcastReceiver.isOrderedBroadcast()) {
                broadcastReceiver.setResultCode(-1);
            }
            FirebaseInstanceIdReceiver.zza(context, string).zza(intent, broadcastReceiver.goAsync());
            return -1;
        }
        return zzau.zzah().zzb(context, string, intent);
    }

    private static synchronized zzh zza(Context context, String string) {
        if ("com.google.firebase.MESSAGING_EVENT".equals(string)) {
            if (zzbe == null) {
                zzbe = new zzh(context, string);
            }
            return zzbe;
        }
        if (zzbd == null) {
            zzbd = new zzh(context, string);
        }
        return zzbd;
    }
}

