/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.google.firebase.iid.zza;
import com.google.firebase.iid.zzav;
import com.google.firebase.iid.zzy;
import com.google.firebase.iid.zzz;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Properties;

final class zzx {
    zzx() {
    }

    @WorkerThread
    final zzy zzb(Context context, String string) throws zzz {
        zzy zzy2 = this.zzd(context, string);
        if (zzy2 != null) {
            return zzy2;
        }
        return this.zzc(context, string);
    }

    @WorkerThread
    final zzy zzc(Context context, String string) {
        zzy zzy2 = new zzy(zza.zzb(), System.currentTimeMillis());
        zzy zzy3 = this.zza(context, string, zzy2, true);
        if (zzy3 != null && !zzy3.equals(zzy2)) {
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Loaded key after generating new one, using loaded one");
            }
            return zzy3;
        }
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Generated new key");
        }
        this.zza(context, string, zzy2);
        return zzy2;
    }

    static void zza(Context context) {
        for (File file : zzx.zzb(context).listFiles()) {
            if (!file.getName().startsWith("com.google.InstanceId")) continue;
            file.delete();
        }
    }

    @Nullable
    private final zzy zzd(Context context, String string) throws zzz {
        zzy zzy2;
        Object var3_3 = null;
        try {
            zzy2 = this.zze(context, string);
            if (zzy2 != null) {
                this.zza(context, string, zzy2);
                return zzy2;
            }
        }
        catch (zzz zzz2) {
            // empty catch block
        }
        try {
            String string2 = string;
            Context context2 = context;
            zzy2 = zzx.zza(context2.getSharedPreferences("com.google.android.gms.appid", 0), string2);
            if (zzy2 != null) {
                this.zza(context, string, zzy2, false);
                return zzy2;
            }
        }
        catch (zzz zzz3) {
            // empty catch block
        }
        if (var3_3 != null) {
            throw var3_3;
        }
        return null;
    }

    private static KeyPair zzc(String string, String string2) throws zzz {
        byte[] byArray;
        byte[] byArray2;
        try {
            byArray2 = Base64.decode((String)string, (int)8);
            byArray = Base64.decode((String)string2, (int)8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new zzz(illegalArgumentException);
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(byArray2));
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            String string3 = String.valueOf(generalSecurityException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(19 + String.valueOf(string3).length()).append("Invalid key stored ").append(string3).toString());
            throw new zzz(generalSecurityException);
        }
    }

    @Nullable
    private final zzy zze(Context context, String string) throws zzz {
        File file = zzx.zzf(context, string);
        if (!file.exists()) {
            return null;
        }
        try {
            return this.zza(file);
        }
        catch (zzz | IOException exception) {
            String string2;
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                string2 = String.valueOf(exception);
                Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(40 + String.valueOf(string2).length()).append("Failed to read key from file, retrying: ").append(string2).toString());
            }
            try {
                return this.zza(file);
            }
            catch (IOException iOException) {
                string2 = String.valueOf(iOException);
                Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(45 + String.valueOf(string2).length()).append("IID file exists, but failed to read from it: ").append(string2).toString());
                throw new zzz(iOException);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private final zzy zza(Context var1_1, String var2_2, zzy var3_3, boolean var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static File zzb(Context context) {
        File file = ContextCompat.getNoBackupFilesDir((Context)context);
        if (file != null && file.isDirectory()) {
            return file;
        }
        Log.w((String)"FirebaseInstanceId", (String)"noBackupFilesDir doesn't exist, using regular files directory instead");
        return context.getFilesDir();
    }

    private static File zzf(Context context, String string) {
        String string2;
        if (TextUtils.isEmpty((CharSequence)string)) {
            string2 = "com.google.InstanceId.properties";
        } else {
            try {
                String string3 = Base64.encodeToString((byte[])string.getBytes("UTF-8"), (int)11);
                string2 = new StringBuilder(33 + String.valueOf(string3).length()).append("com.google.InstanceId_").append(string3).append(".properties").toString();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
        }
        return new File(zzx.zzb(context), string2);
    }

    /*
     * Loose catch block
     */
    private final zzy zza(File file) throws zzz, IOException {
        zzy zzy2;
        Throwable throwable;
        Object object;
        Throwable throwable2;
        FileInputStream fileInputStream;
        block10: {
            fileInputStream = new FileInputStream(file);
            throwable2 = null;
            object = fileInputStream.getChannel();
            throwable = null;
            ((FileChannel)object).lock(0L, Long.MAX_VALUE, true);
            zzy2 = zzx.zza((FileChannel)object);
            if (object == null) break block10;
            zzx.zza(null, (FileChannel)object);
        }
        zzx.zza(null, fileInputStream);
        return zzy2;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            Throwable throwable4 = throwable3;
                            throwable = throwable3;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (object != null) {
                                zzx.zza(throwable, (FileChannel)object);
                            }
                            throw throwable5;
                        }
                    }
                    catch (Throwable throwable6) {
                        object = throwable6;
                        throwable2 = throwable6;
                        throw object;
                    }
                }
                catch (Throwable throwable7) {
                    zzx.zza(throwable2, fileInputStream);
                    throw throwable7;
                }
            }
        }
    }

    private static zzy zza(FileChannel fileChannel) throws zzz, IOException {
        long l;
        Properties properties = new Properties();
        properties.load(Channels.newInputStream(fileChannel));
        String string = properties.getProperty("pub");
        String string2 = properties.getProperty("pri");
        if (string == null || string2 == null) {
            throw new zzz("Invalid properties file");
        }
        KeyPair keyPair = zzx.zzc(string, string2);
        try {
            l = Long.parseLong(properties.getProperty("cre"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new zzz(numberFormatException);
        }
        return new zzy(keyPair, l);
    }

    @Nullable
    private static zzy zza(SharedPreferences sharedPreferences, String string) throws zzz {
        String string2 = sharedPreferences.getString(zzav.zzd(string, "|P|"), null);
        String string3 = sharedPreferences.getString(zzav.zzd(string, "|K|"), null);
        if (string2 == null || string3 == null) {
            return null;
        }
        KeyPair keyPair = zzx.zzc(string2, string3);
        long l = zzx.zzb(sharedPreferences, string);
        return new zzy(keyPair, l);
    }

    private final void zza(Context context, String string, zzy zzy2) {
        zzy zzy3;
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.appid", 0);
        try {
            zzy3 = zzx.zza(sharedPreferences, string);
            if (zzy2.equals(zzy3)) {
                return;
            }
        }
        catch (zzz zzz2) {}
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Writing key to shared preferences");
        }
        zzy3 = sharedPreferences.edit();
        zzy3.putString(zzav.zzd(string, "|P|"), zzy.zza(zzy2));
        zzy3.putString(zzav.zzd(string, "|K|"), zzy.zzb(zzy2));
        zzy3.putString(zzav.zzd(string, "cre"), String.valueOf(zzy.zzc(zzy2)));
        zzy3.commit();
    }

    private static long zzb(SharedPreferences sharedPreferences, String string) {
        String string2 = sharedPreferences.getString(zzav.zzd(string, "cre"), null);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0L;
    }

    private static /* synthetic */ void zza(Throwable throwable, FileChannel fileChannel) {
        if (throwable != null) {
            try {
                fileChannel.close();
                return;
            }
            catch (Throwable throwable2) {
                com.google.android.gms.internal.firebase_messaging.zza.zza(throwable, throwable2);
                return;
            }
        }
        fileChannel.close();
    }

    private static /* synthetic */ void zza(Throwable throwable, RandomAccessFile randomAccessFile) {
        if (throwable != null) {
            try {
                randomAccessFile.close();
                return;
            }
            catch (Throwable throwable2) {
                com.google.android.gms.internal.firebase_messaging.zza.zza(throwable, throwable2);
                return;
            }
        }
        randomAccessFile.close();
    }

    private static /* synthetic */ void zza(Throwable throwable, FileInputStream fileInputStream) {
        if (throwable != null) {
            try {
                fileInputStream.close();
                return;
            }
            catch (Throwable throwable2) {
                com.google.android.gms.internal.firebase_messaging.zza.zza(throwable, throwable2);
                return;
            }
        }
        fileInputStream.close();
    }
}

