/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.PowerManager;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzan;
import com.google.firebase.iid.zzav;
import com.google.firebase.iid.zzax;
import com.google.firebase.iid.zzaz;
import com.google.firebase.iid.zzba;
import java.io.IOException;

final class zzay
implements Runnable {
    private final long zzdh;
    private final PowerManager.WakeLock zzdi;
    private final FirebaseInstanceId zzdj;
    private final zzan zzan;
    private final zzba zzaq;

    @VisibleForTesting
    zzay(FirebaseInstanceId firebaseInstanceId, zzan zzan2, zzba zzba2, long l) {
        this.zzdj = firebaseInstanceId;
        this.zzan = zzan2;
        this.zzaq = zzba2;
        this.zzdh = l;
        PowerManager powerManager = (PowerManager)this.getContext().getSystemService("power");
        this.zzdi = powerManager.newWakeLock(1, "fiid-sync");
        this.zzdi.setReferenceCounted(false);
    }

    @Override
    public final void run() {
        this.zzdi.acquire();
        try {
            this.zzdj.zza(true);
            if (!this.zzdj.zzn()) {
                this.zzdj.zza(false);
                return;
            }
            if (!this.zzao()) {
                new zzaz(this).zzap();
                return;
            }
            if (this.zzam() && this.zzan() && this.zzaq.zzc(this.zzdj)) {
                this.zzdj.zza(false);
            } else {
                this.zzdj.zza(this.zzdh);
            }
            return;
        }
        finally {
            this.zzdi.release();
        }
    }

    @VisibleForTesting
    private final boolean zzam() {
        try {
            if (!this.zzdj.zzo()) {
                this.zzdj.zzp();
            }
            return true;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            Log.e((String)"FirebaseInstanceId", (String)(string.length() != 0 ? "Build channel failed: ".concat(string) : new String("Build channel failed: ")));
            return false;
        }
    }

    @VisibleForTesting
    private final boolean zzan() {
        zzax zzax2 = this.zzdj.zzj();
        if (zzax2 != null && !zzax2.zzj(this.zzan.zzad())) {
            return true;
        }
        try {
            String string = this.zzdj.zzk();
            if (string == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Token retrieval failed: null");
                return false;
            }
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Token successfully retrieved");
            }
            if (zzax2 == null || zzax2 != null && !string.equals(zzax2.zzbq)) {
                String string2;
                String string3 = string2 = string;
                Context context = this.getContext();
                Intent intent = new Intent("com.google.firebase.messaging.NEW_TOKEN");
                intent.putExtra("token", string3);
                zzav.zzc(context, intent);
                Intent intent2 = new Intent("com.google.firebase.iid.TOKEN_REFRESH");
                zzav.zzb(context, intent2);
            }
            return true;
        }
        catch (IOException | SecurityException exception) {
            String string = String.valueOf(exception.getMessage());
            Log.e((String)"FirebaseInstanceId", (String)(string.length() != 0 ? "Token retrieval failed: ".concat(string) : new String("Token retrieval failed: ")));
            return false;
        }
    }

    final Context getContext() {
        return this.zzdj.zzh().getApplicationContext();
    }

    final boolean zzao() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }
}

