/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.PowerManager;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzam;
import com.google.firebase.iid.zzau;
import com.google.firebase.iid.zzaw;
import com.google.firebase.iid.zzay;
import com.google.firebase.iid.zzba;
import java.io.IOException;

final class zzaz
implements Runnable {
    private final long zzdq;
    private final PowerManager.WakeLock zzdr;
    private final FirebaseInstanceId zzds;
    private final zzba zzay;

    @VisibleForTesting
    zzaz(FirebaseInstanceId firebaseInstanceId, zzam zzam2, zzba zzba2, long l) {
        this.zzds = firebaseInstanceId;
        this.zzay = zzba2;
        this.zzdq = l;
        PowerManager powerManager = (PowerManager)this.getContext().getSystemService("power");
        this.zzdr = powerManager.newWakeLock(1, "fiid-sync");
        this.zzdr.setReferenceCounted(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SuppressLint(value={"Wakelock"})
    public final void run() {
        block8: {
            block7: {
                try {
                    if (zzau.zzai().zzd(this.getContext())) {
                        this.zzdr.acquire();
                    }
                    this.zzds.zza(true);
                    if (this.zzds.zzo()) break block7;
                    this.zzds.zza(false);
                    if (!zzau.zzai().zzd(this.getContext())) return;
                }
                catch (Throwable throwable) {
                    if (!zzau.zzai().zzd(this.getContext())) throw throwable;
                    this.zzdr.release();
                    throw throwable;
                }
                this.zzdr.release();
                return;
            }
            if (!zzau.zzai().zze(this.getContext()) || this.zzao()) break block8;
            new zzay(this).zzam();
            if (!zzau.zzai().zzd(this.getContext())) return;
            this.zzdr.release();
            return;
        }
        if (this.zzan() && this.zzay.zzc(this.zzds)) {
            this.zzds.zza(false);
        } else {
            this.zzds.zza(this.zzdq);
        }
        if (!zzau.zzai().zzd(this.getContext())) return;
        this.zzdr.release();
    }

    @VisibleForTesting
    private final boolean zzan() {
        zzaw zzaw2 = this.zzds.zzk();
        if (!this.zzds.zzr() && !this.zzds.zza(zzaw2)) {
            return true;
        }
        try {
            String string = this.zzds.zzl();
            if (string == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Token retrieval failed: null");
                return false;
            }
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Token successfully retrieved");
            }
            if (zzaw2 == null || zzaw2 != null && !string.equals(zzaw2.zzbx)) {
                String string2;
                String string3 = string2 = string;
                Context context = this.getContext();
                Intent intent = new Intent("com.google.firebase.messaging.NEW_TOKEN");
                intent.putExtra("token", string3);
                zzau.zzc(context, intent);
                Intent intent2 = new Intent("com.google.firebase.iid.TOKEN_REFRESH");
                zzau.zzb(context, intent2);
            }
            return true;
        }
        catch (IOException | SecurityException exception) {
            String string = String.valueOf(exception.getMessage());
            Log.e((String)"FirebaseInstanceId", (String)(string.length() != 0 ? "Token retrieval failed: ".concat(string) : new String("Token retrieval failed: ")));
            return false;
        }
    }

    final Context getContext() {
        return this.zzds.zzi().getApplicationContext();
    }

    final boolean zzao() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }
}

