/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.events.EventHandler;
import com.google.firebase.events.Subscriber;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.zzaf;
import com.google.firebase.iid.zzak;
import com.google.firebase.iid.zzap;
import com.google.firebase.iid.zzaq;
import com.google.firebase.iid.zzas;
import com.google.firebase.iid.zzau;
import com.google.firebase.iid.zzc;
import com.google.firebase.iid.zzg;
import com.google.firebase.iid.zzh;
import com.google.firebase.iid.zzi;
import com.google.firebase.iid.zzj;
import com.google.firebase.iid.zzk;
import com.google.firebase.iid.zzt;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseInstanceId {
    private static final long zza = TimeUnit.HOURS.toSeconds(8L);
    private static zzaq zzb;
    @GuardedBy(value="FirebaseInstanceId.class")
    @VisibleForTesting
    private static ScheduledExecutorService zzc;
    private final Executor zzd;
    private final FirebaseApp zze;
    private final zzaf zzf;
    private final zzk zzg;
    private final zzak zzh;
    private final zzau zzi;
    @GuardedBy(value="this")
    private boolean zzj = false;
    private final zza zzk;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseInstanceId)firebaseApp.get(FirebaseInstanceId.class);
    }

    FirebaseInstanceId(FirebaseApp firebaseApp, Subscriber subscriber, UserAgentPublisher userAgentPublisher) {
        this(firebaseApp, new zzaf(firebaseApp.getApplicationContext()), com.google.firebase.iid.zzc.zzb(), com.google.firebase.iid.zzc.zzb(), subscriber, userAgentPublisher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FirebaseInstanceId(FirebaseApp firebaseApp, zzaf zzaf2, Executor executor, Executor executor2, Subscriber subscriber, UserAgentPublisher userAgentPublisher) {
        if (zzaf.zza(firebaseApp) == null) {
            throw new IllegalStateException("FirebaseInstanceId failed to initialize, FirebaseApp is missing project ID");
        }
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzb == null) {
                zzb = new zzaq(firebaseApp.getApplicationContext());
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            this.zze = firebaseApp;
            this.zzf = zzaf2;
            this.zzg = new zzk(firebaseApp, zzaf2, executor, userAgentPublisher);
            this.zzd = executor2;
            this.zzi = new zzau(zzb);
            this.zzk = new zza(subscriber);
            this.zzh = new zzak(executor);
            if (this.zzk.zza()) {
                this.zzi();
            }
            return;
        }
    }

    private final void zzi() {
        zzap zzap2 = this.zzb();
        if (this.zza(zzap2) || this.zzi.zza()) {
            this.zzj();
        }
    }

    final FirebaseApp zza() {
        return this.zze;
    }

    final synchronized void zza(boolean bl) {
        this.zzj = bl;
    }

    private final synchronized void zzj() {
        if (!this.zzj) {
            this.zza(0L);
        }
    }

    final synchronized void zza(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zza);
        FirebaseInstanceId.zza(new zzas(this, this.zzf, this.zzi, l2), l);
        this.zzj = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzc == null) {
                zzc = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("FirebaseInstanceId"));
            }
            zzc.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    public String getId() {
        this.zzi();
        return FirebaseInstanceId.zzk();
    }

    private static String zzk() {
        return zzb.zzb("").zza();
    }

    public long getCreationTime() {
        return zzb.zzb("").zzb();
    }

    @NonNull
    public Task<InstanceIdResult> getInstanceId() {
        return this.zza(zzaf.zza(this.zze), "*");
    }

    private final Task<InstanceIdResult> zza(String string, String string2) {
        String string3 = FirebaseInstanceId.zzd(string2);
        return Tasks.forResult(null).continueWithTask(this.zzd, (Continuation)new zzg(this, string, string3));
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        String string = FirebaseInstanceId.zzk();
        this.zza(this.zzg.zza(string));
        this.zze();
    }

    @Deprecated
    @Nullable
    public String getToken() {
        zzap zzap2 = this.zzb();
        if (this.zza(zzap2)) {
            this.zzj();
        }
        return zzap.zza(zzap2);
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        return this.zza(this.zza(string, string2)).getToken();
    }

    @Nullable
    final zzap zzb() {
        return FirebaseInstanceId.zzb(zzaf.zza(this.zze), "*");
    }

    @Nullable
    @VisibleForTesting
    private static zzap zzb(String string, String string2) {
        return zzb.zza("", string, string2);
    }

    final String zzc() throws IOException {
        return this.getToken(zzaf.zza(this.zze), "*");
    }

    private final <T> T zza(Task<T> task) throws IOException {
        try {
            return (T)Tasks.await(task, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                if ("INSTANCE_ID_RESET".equals(throwable.getMessage())) {
                    this.zze();
                }
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IOException(executionException2);
        }
        catch (InterruptedException | TimeoutException exception) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        string2 = FirebaseInstanceId.zzd(string2);
        String string3 = FirebaseInstanceId.zzk();
        this.zza(this.zzg.zzb(string3, string, string2));
        zzb.zzb("", string, string2);
    }

    public final synchronized Task<Void> zza(String string) {
        Task<Void> task = this.zzi.zza(string);
        this.zzj();
        return task;
    }

    final void zzb(String string) throws IOException {
        zzap zzap2 = this.zzb();
        if (this.zza(zzap2)) {
            throw new IOException("token not available");
        }
        String string2 = FirebaseInstanceId.zzk();
        String string3 = string;
        String string4 = zzap2.zza;
        String string5 = string2;
        Task<Void> task = this.zzg.zzc(string5, string4, string3);
        this.zza(task);
    }

    final void zzc(String string) throws IOException {
        zzap zzap2 = this.zzb();
        if (this.zza(zzap2)) {
            throw new IOException("token not available");
        }
        String string2 = FirebaseInstanceId.zzk();
        this.zza(this.zzg.zzd(string2, zzap2.zza, string));
    }

    static boolean zzd() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }

    final synchronized void zze() {
        zzb.zzb();
        if (this.zzk.zza()) {
            this.zzj();
        }
    }

    final boolean zzf() {
        return this.zzf.zza() != 0;
    }

    final void zzg() {
        zzb.zzc("");
        this.zzj();
    }

    @VisibleForTesting
    public final boolean zzh() {
        return this.zzk.zza();
    }

    @VisibleForTesting
    public final void zzb(boolean bl) {
        this.zzk.zza(bl);
    }

    private static String zzd(String string) {
        if (string.isEmpty() || string.equalsIgnoreCase("fcm") || string.equalsIgnoreCase("gcm")) {
            return "*";
        }
        return string;
    }

    final boolean zza(@Nullable zzap zzap2) {
        return zzap2 == null || zzap2.zzb(this.zzf.zzb());
    }

    final /* synthetic */ Task zza(String string, String string2, Task task) throws Exception {
        String string3 = FirebaseInstanceId.zzk();
        zzap zzap2 = FirebaseInstanceId.zzb(string, string2);
        if (!this.zza(zzap2)) {
            return Tasks.forResult((Object)new zzt(string3, zzap2.zza));
        }
        return this.zzh.zza(string, string2, new zzi(this, string3, string, string2));
    }

    final /* synthetic */ Task zza(String string, String string2, String string3) {
        return this.zzg.zza(string, string2, string3).onSuccessTask(this.zzd, (SuccessContinuation)new zzh(this, string2, string3, string));
    }

    final /* synthetic */ Task zza(String string, String string2, String string3, String string4) throws Exception {
        zzb.zza("", string, string2, string4, this.zzf.zzb());
        return Tasks.forResult((Object)new zzt(string3, string4));
    }

    private final class zza {
        private final boolean zzb;
        private final Subscriber zzc;
        @GuardedBy(value="this")
        @Nullable
        private EventHandler<DataCollectionDefaultChange> zzd;
        @GuardedBy(value="this")
        @Nullable
        private Boolean zze;

        zza(Subscriber subscriber) {
            this.zzc = subscriber;
            this.zzb = this.zzc();
            this.zze = this.zzb();
            if (this.zze == null && this.zzb) {
                this.zzd = new zzj(this);
                subscriber.subscribe(DataCollectionDefaultChange.class, this.zzd);
            }
        }

        final synchronized boolean zza() {
            if (this.zze != null) {
                return this.zze;
            }
            return this.zzb && FirebaseInstanceId.this.zze.isDataCollectionDefaultEnabled();
        }

        final synchronized void zza(boolean bl) {
            if (this.zzd != null) {
                this.zzc.unsubscribe(DataCollectionDefaultChange.class, this.zzd);
                this.zzd = null;
            }
            SharedPreferences.Editor editor = FirebaseInstanceId.this.zze.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
            editor.putBoolean("auto_init", bl);
            editor.apply();
            if (bl) {
                FirebaseInstanceId.this.zzi();
            }
            this.zze = bl;
        }

        @Nullable
        private final Boolean zzb() {
            Context context = FirebaseInstanceId.this.zze.getApplicationContext();
            SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
            if (sharedPreferences.contains("auto_init")) {
                return sharedPreferences.getBoolean("auto_init", false);
            }
            try {
                ApplicationInfo applicationInfo;
                PackageManager packageManager = context.getPackageManager();
                if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("firebase_messaging_auto_init_enabled")) {
                    return applicationInfo.metaData.getBoolean("firebase_messaging_auto_init_enabled");
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
            return null;
        }

        private final boolean zzc() {
            try {
                Class.forName("com.google.firebase.messaging.FirebaseMessaging");
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Context context = FirebaseInstanceId.this.zze.getApplicationContext();
                Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
                intent.setPackage(context.getPackageName());
                ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
                return resolveInfo != null && resolveInfo.serviceInfo != null;
            }
        }
    }
}

