/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import androidx.core.content.ContextCompat;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzap;
import com.google.firebase.iid.zzp;
import com.google.firebase.iid.zzr;
import com.google.firebase.iid.zzs;
import java.io.File;
import java.io.IOException;
import java.util.Map;

final class zzaq {
    private final SharedPreferences zza;
    private final Context zzb;
    private final zzp zzc;
    @GuardedBy(value="this")
    private final Map<String, zzr> zzd;

    public zzaq(Context context) {
        this(context, new zzp());
    }

    private zzaq(Context context, zzp zzp2) {
        block4: {
            this.zzd = new ArrayMap();
            this.zzb = context;
            this.zza = context.getSharedPreferences("com.google.android.gms.appid", 0);
            this.zzc = zzp2;
            String string = "com.google.android.gms.appid-no-backup";
            zzaq zzaq2 = this;
            File file = ContextCompat.getNoBackupFilesDir((Context)zzaq2.zzb);
            File file2 = new File(file, string);
            if (!file2.exists()) {
                try {
                    if (file2.createNewFile() && !zzaq2.zzc()) {
                        Log.i((String)"FirebaseInstanceId", (String)"App restored, clearing state");
                        zzaq2.zzb();
                        FirebaseInstanceId.getInstance().zze();
                    }
                    return;
                }
                catch (IOException iOException) {
                    if (!Log.isLoggable((String)"FirebaseInstanceId", (int)3)) break block4;
                    String string2 = String.valueOf(iOException.getMessage());
                    Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Error creating file in no backup dir: ".concat(string2) : new String("Error creating file in no backup dir: ")));
                }
            }
        }
    }

    public final synchronized String zza() {
        return this.zza.getString("topic_operation_queue", "");
    }

    public final synchronized void zza(String string) {
        this.zza.edit().putString("topic_operation_queue", string).apply();
    }

    private final synchronized boolean zzc() {
        return this.zza.getAll().isEmpty();
    }

    private static String zzc(String string, String string2, String string3) {
        return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append("|T|").append(string2).append("|").append(string3).toString();
    }

    static String zza(String string, String string2) {
        return new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("|S|").append(string2).toString();
    }

    public final synchronized void zzb() {
        this.zzd.clear();
        zzp.zza(this.zzb);
        this.zza.edit().clear().commit();
    }

    public final synchronized zzap zza(String string, String string2, String string3) {
        return zzap.zza(this.zza.getString(zzaq.zzc(string, string2, string3), null));
    }

    public final synchronized void zza(String string, String string2, String string3, String string4, String string5) {
        String string6 = zzap.zza(string4, string5, System.currentTimeMillis());
        if (string6 == null) {
            return;
        }
        SharedPreferences.Editor editor = this.zza.edit();
        editor.putString(zzaq.zzc(string, string2, string3), string6);
        editor.commit();
    }

    public final synchronized void zzb(String string, String string2, String string3) {
        String string4 = zzaq.zzc(string, string2, string3);
        SharedPreferences.Editor editor = this.zza.edit();
        editor.remove(string4);
        editor.commit();
    }

    public final synchronized zzr zzb(String string) {
        zzr zzr2 = this.zzd.get(string);
        if (zzr2 != null) {
            return zzr2;
        }
        try {
            zzr2 = this.zzc.zza(this.zzb, string);
        }
        catch (zzs zzs2) {
            Log.w((String)"FirebaseInstanceId", (String)"Stored data is corrupt, generating new identity");
            FirebaseInstanceId.getInstance().zze();
            zzr2 = this.zzc.zzb(this.zzb, string);
        }
        this.zzd.put(string, zzr2);
        return zzr2;
    }

    public final synchronized void zzc(String string) {
        String string2 = String.valueOf(string).concat("|T|");
        zzaq zzaq2 = this;
        SharedPreferences.Editor editor = zzaq2.zza.edit();
        for (String string3 : zzaq2.zza.getAll().keySet()) {
            if (!string3.startsWith(string2)) continue;
            editor.remove(string3);
        }
        editor.commit();
    }
}

