/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.internal.firebase_messaging.zzn;
import com.google.firebase.iid.zza;
import com.google.firebase.iid.zzaf;
import com.google.firebase.iid.zzaq;
import com.google.firebase.iid.zzr;
import com.google.firebase.iid.zzs;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Properties;

final class zzp {
    zzp() {
    }

    @WorkerThread
    final zzr zza(Context context, String string) throws zzs {
        zzr zzr2 = this.zzc(context, string);
        if (zzr2 != null) {
            return zzr2;
        }
        return this.zzb(context, string);
    }

    @WorkerThread
    final zzr zzb(Context context, String string) {
        String string2 = zzaf.zza(zza.zza().getPublic());
        zzr zzr2 = new zzr(string2, System.currentTimeMillis());
        zzr zzr3 = this.zza(context, string, zzr2, true);
        if (zzr3 != null && !zzr3.equals(zzr2)) {
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Loaded key after generating new one, using loaded one");
            }
            return zzr3;
        }
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Generated new key");
        }
        this.zza(context, string, zzr2);
        return zzr2;
    }

    static void zza(Context context) {
        for (File file : zzp.zzb(context).listFiles()) {
            if (!file.getName().startsWith("com.google.InstanceId")) continue;
            file.delete();
        }
    }

    @Nullable
    private final zzr zzc(Context context, String string) throws zzs {
        zzr zzr2;
        Object var3_3 = null;
        try {
            zzr2 = this.zzd(context, string);
            if (zzr2 != null) {
                this.zza(context, string, zzr2);
                return zzr2;
            }
        }
        catch (zzs zzs2) {
            // empty catch block
        }
        try {
            String string2 = string;
            Context context2 = context;
            zzr2 = zzp.zza(context2.getSharedPreferences("com.google.android.gms.appid", 0), string2);
            if (zzr2 != null) {
                this.zza(context, string, zzr2, false);
                return zzr2;
            }
        }
        catch (zzs zzs3) {
            // empty catch block
        }
        if (var3_3 != null) {
            throw var3_3;
        }
        return null;
    }

    private static PublicKey zza(String string) throws zzs {
        byte[] byArray;
        try {
            byArray = Base64.decode((String)string, (int)8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new zzs(illegalArgumentException);
        }
        try {
            return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(byArray));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            String string2 = String.valueOf(generalSecurityException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(19 + String.valueOf(string2).length()).append("Invalid key stored ").append(string2).toString());
            throw new zzs(generalSecurityException);
        }
    }

    @Nullable
    private final zzr zzd(Context context, String string) throws zzs {
        File file = zzp.zze(context, string);
        if (!file.exists()) {
            return null;
        }
        try {
            return this.zza(file);
        }
        catch (zzs | IOException exception) {
            String string2;
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                string2 = String.valueOf(exception);
                Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(39 + String.valueOf(string2).length()).append("Failed to read ID from file, retrying: ").append(string2).toString());
            }
            try {
                return this.zza(file);
            }
            catch (IOException iOException) {
                string2 = String.valueOf(iOException);
                Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(45 + String.valueOf(string2).length()).append("IID file exists, but failed to read from it: ").append(string2).toString());
                throw new zzs(iOException);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private final zzr zza(Context var1_1, String var2_2, zzr var3_3, boolean var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static File zzb(Context context) {
        File file = ContextCompat.getNoBackupFilesDir((Context)context);
        if (file != null && file.isDirectory()) {
            return file;
        }
        Log.w((String)"FirebaseInstanceId", (String)"noBackupFilesDir doesn't exist, using regular files directory instead");
        return context.getFilesDir();
    }

    private static File zze(Context context, String string) {
        String string2;
        if (TextUtils.isEmpty((CharSequence)string)) {
            string2 = "com.google.InstanceId.properties";
        } else {
            try {
                String string3 = Base64.encodeToString((byte[])string.getBytes("UTF-8"), (int)11);
                string2 = new StringBuilder(33 + String.valueOf(string3).length()).append("com.google.InstanceId_").append(string3).append(".properties").toString();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
        }
        return new File(zzp.zzb(context), string2);
    }

    /*
     * Loose catch block
     */
    private final zzr zza(File file) throws zzs, IOException {
        zzr zzr2;
        Throwable throwable;
        Object object;
        Throwable throwable2;
        FileInputStream fileInputStream;
        block10: {
            fileInputStream = new FileInputStream(file);
            throwable2 = null;
            object = fileInputStream.getChannel();
            throwable = null;
            ((FileChannel)object).lock(0L, Long.MAX_VALUE, true);
            zzr2 = zzp.zza((FileChannel)object);
            if (object == null) break block10;
            zzp.zza(null, (FileChannel)object);
        }
        zzp.zza(null, fileInputStream);
        return zzr2;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            Throwable throwable4 = throwable3;
                            throwable = throwable3;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (object != null) {
                                zzp.zza(throwable, (FileChannel)object);
                            }
                            throw throwable5;
                        }
                    }
                    catch (Throwable throwable6) {
                        object = throwable6;
                        throwable2 = throwable6;
                        throw object;
                    }
                }
                catch (Throwable throwable7) {
                    zzp.zza(throwable2, fileInputStream);
                    throw throwable7;
                }
            }
        }
    }

    private static zzr zza(FileChannel fileChannel) throws zzs, IOException {
        long l;
        Properties properties = new Properties();
        properties.load(Channels.newInputStream(fileChannel));
        try {
            l = Long.parseLong(properties.getProperty("cre"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new zzs(numberFormatException);
        }
        String string = properties.getProperty("id");
        if (string == null) {
            String string2 = properties.getProperty("pub");
            if (string2 == null) {
                throw new zzs("Invalid properties file");
            }
            string = zzaf.zza(zzp.zza(string2));
        }
        return new zzr(string, l);
    }

    @Nullable
    private static zzr zza(SharedPreferences sharedPreferences, String string) throws zzs {
        long l = zzp.zzb(sharedPreferences, string);
        String string2 = sharedPreferences.getString(zzaq.zza(string, "id"), null);
        if (string2 == null) {
            String string3 = sharedPreferences.getString(zzaq.zza(string, "|P|"), null);
            if (string3 == null) {
                return null;
            }
            string2 = zzaf.zza(zzp.zza(string3));
        }
        return new zzr(string2, l);
    }

    private final void zza(Context context, String string, zzr zzr2) {
        zzr zzr3;
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.appid", 0);
        try {
            zzr3 = zzp.zza(sharedPreferences, string);
            if (zzr2.equals(zzr3)) {
                return;
            }
        }
        catch (zzs zzs2) {}
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Writing key to shared preferences");
        }
        zzr3 = sharedPreferences.edit();
        zzr3.putString(zzaq.zza(string, "id"), zzr2.zza());
        zzr3.putString(zzaq.zza(string, "cre"), String.valueOf(zzr.zza(zzr2)));
        zzr3.commit();
    }

    private static long zzb(SharedPreferences sharedPreferences, String string) {
        String string2 = sharedPreferences.getString(zzaq.zza(string, "cre"), null);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0L;
    }

    private static /* synthetic */ void zza(Throwable throwable, FileChannel fileChannel) {
        if (throwable != null) {
            try {
                fileChannel.close();
                return;
            }
            catch (Throwable throwable2) {
                zzn.zza(throwable, throwable2);
                return;
            }
        }
        fileChannel.close();
    }

    private static /* synthetic */ void zza(Throwable throwable, RandomAccessFile randomAccessFile) {
        if (throwable != null) {
            try {
                randomAccessFile.close();
                return;
            }
            catch (Throwable throwable2) {
                zzn.zza(throwable, throwable2);
                return;
            }
        }
        randomAccessFile.close();
    }

    private static /* synthetic */ void zza(Throwable throwable, FileInputStream fileInputStream) {
        if (throwable != null) {
            try {
                fileInputStream.close();
                return;
            }
            catch (Throwable throwable2) {
                zzn.zza(throwable, throwable2);
                return;
            }
        }
        fileInputStream.close();
    }
}

