/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.events.EventHandler;
import com.google.firebase.events.Subscriber;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.zzai;
import com.google.firebase.iid.zzan;
import com.google.firebase.iid.zzas;
import com.google.firebase.iid.zzat;
import com.google.firebase.iid.zzav;
import com.google.firebase.iid.zzax;
import com.google.firebase.iid.zzg;
import com.google.firebase.iid.zzh;
import com.google.firebase.iid.zzi;
import com.google.firebase.iid.zzj;
import com.google.firebase.iid.zzk;
import com.google.firebase.iid.zzl;
import com.google.firebase.iid.zzu;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseInstanceId {
    private static final long zza = TimeUnit.HOURS.toSeconds(8L);
    private static zzat zzb;
    @GuardedBy(value="FirebaseInstanceId.class")
    @VisibleForTesting
    private static ScheduledExecutorService zzc;
    @VisibleForTesting
    private final Executor zzd;
    private final FirebaseApp zze;
    private final zzai zzf;
    private final zzl zzg;
    private final zzan zzh;
    private final zzax zzi;
    @GuardedBy(value="this")
    private boolean zzj = false;
    private final zza zzk;

    @NonNull
    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    @NonNull
    public static FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseInstanceId)firebaseApp.get(FirebaseInstanceId.class);
    }

    FirebaseInstanceId(FirebaseApp firebaseApp, Subscriber subscriber, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo) {
        this(firebaseApp, new zzai(firebaseApp.getApplicationContext()), com.google.firebase.iid.zza.zzb(), com.google.firebase.iid.zza.zzb(), subscriber, userAgentPublisher, heartBeatInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FirebaseInstanceId(FirebaseApp firebaseApp, zzai zzai2, Executor executor, Executor executor2, Subscriber subscriber, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo) {
        if (zzai.zza(firebaseApp) == null) {
            throw new IllegalStateException("FirebaseInstanceId failed to initialize, FirebaseApp is missing project ID");
        }
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzb == null) {
                zzb = new zzat(firebaseApp.getApplicationContext());
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            this.zze = firebaseApp;
            this.zzf = zzai2;
            this.zzg = new zzl(firebaseApp, zzai2, executor, userAgentPublisher, heartBeatInfo);
            this.zzd = executor2;
            this.zzi = new zzax(zzb);
            this.zzk = new zza(subscriber);
            this.zzh = new zzan(executor);
            executor2.execute(new zzh(this));
            return;
        }
    }

    private final void zzj() {
        zzas zzas2 = this.zzb();
        if (this.zza(zzas2) || this.zzi.zza()) {
            this.zzk();
        }
    }

    final FirebaseApp zza() {
        return this.zze;
    }

    final synchronized void zza(boolean bl) {
        this.zzj = bl;
    }

    private final synchronized void zzk() {
        if (!this.zzj) {
            this.zza(0L);
        }
    }

    final synchronized void zza(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zza);
        FirebaseInstanceId.zza(new zzav(this, this.zzf, this.zzi, l2), l);
        this.zzj = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzc == null) {
                zzc = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("FirebaseInstanceId"));
            }
            zzc.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    @NonNull
    public String getId() {
        this.zzj();
        return FirebaseInstanceId.zzl();
    }

    private static String zzl() {
        return zzb.zzb("").zza();
    }

    public long getCreationTime() {
        return zzb.zzb("").zzb();
    }

    @NonNull
    public Task<InstanceIdResult> getInstanceId() {
        return this.zza(zzai.zza(this.zze), "*");
    }

    private final Task<InstanceIdResult> zza(String string, String string2) {
        String string3 = FirebaseInstanceId.zzd(string2);
        return Tasks.forResult(null).continueWithTask(this.zzd, (Continuation)new zzg(this, string, string3));
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        String string = FirebaseInstanceId.zzl();
        this.zza(this.zzg.zza(string));
        this.zze();
    }

    @Deprecated
    @Nullable
    public String getToken() {
        zzas zzas2 = this.zzb();
        if (this.zza(zzas2)) {
            this.zzk();
        }
        return zzas.zza(zzas2);
    }

    @Nullable
    @WorkerThread
    public String getToken(@NonNull String string, @NonNull String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        return this.zza(this.zza(string, string2)).getToken();
    }

    @Nullable
    final zzas zzb() {
        return FirebaseInstanceId.zzb(zzai.zza(this.zze), "*");
    }

    @Nullable
    @VisibleForTesting
    private static zzas zzb(String string, String string2) {
        return zzb.zza("", string, string2);
    }

    final String zzc() throws IOException {
        return this.getToken(zzai.zza(this.zze), "*");
    }

    private final <T> T zza(Task<T> task) throws IOException {
        try {
            return (T)Tasks.await(task, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                if ("INSTANCE_ID_RESET".equals(throwable.getMessage())) {
                    this.zze();
                }
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IOException(executionException2);
        }
        catch (InterruptedException | TimeoutException exception) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
    }

    @WorkerThread
    public void deleteToken(@NonNull String string, @NonNull String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        string2 = FirebaseInstanceId.zzd(string2);
        String string3 = FirebaseInstanceId.zzl();
        this.zza(this.zzg.zzb(string3, string, string2));
        zzb.zzb("", string, string2);
    }

    public final synchronized Task<Void> zza(String string) {
        Task<Void> task = this.zzi.zza(string);
        this.zzk();
        return task;
    }

    final void zzb(String string) throws IOException {
        zzas zzas2 = this.zzb();
        if (this.zza(zzas2)) {
            throw new IOException("token not available");
        }
        String string2 = FirebaseInstanceId.zzl();
        String string3 = string;
        String string4 = zzas2.zza;
        String string5 = string2;
        Task<Void> task = this.zzg.zzc(string5, string4, string3);
        this.zza(task);
    }

    final void zzc(String string) throws IOException {
        zzas zzas2 = this.zzb();
        if (this.zza(zzas2)) {
            throw new IOException("token not available");
        }
        String string2 = FirebaseInstanceId.zzl();
        this.zza(this.zzg.zzd(string2, zzas2.zza, string));
    }

    static boolean zzd() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }

    final synchronized void zze() {
        zzb.zzb();
        if (this.zzk.zza()) {
            this.zzk();
        }
    }

    final boolean zzf() {
        return this.zzf.zza() != 0;
    }

    final void zzg() {
        zzb.zzc("");
        this.zzk();
    }

    @VisibleForTesting
    public final boolean zzh() {
        return this.zzk.zza();
    }

    @VisibleForTesting
    public final void zzb(boolean bl) {
        this.zzk.zza(bl);
    }

    private static String zzd(String string) {
        if (string.isEmpty() || string.equalsIgnoreCase("fcm") || string.equalsIgnoreCase("gcm")) {
            return "*";
        }
        return string;
    }

    final boolean zza(@Nullable zzas zzas2) {
        return zzas2 == null || zzas2.zzb(this.zzf.zzb());
    }

    final /* synthetic */ Task zza(String string, String string2, Task task) throws Exception {
        String string3 = FirebaseInstanceId.zzl();
        zzas zzas2 = FirebaseInstanceId.zzb(string, string2);
        if (!this.zza(zzas2)) {
            return Tasks.forResult((Object)new zzu(string3, zzas2.zza));
        }
        return this.zzh.zza(string, string2, new zzj(this, string3, string, string2));
    }

    final /* synthetic */ Task zza(String string, String string2, String string3) {
        return this.zzg.zza(string, string2, string3).onSuccessTask(this.zzd, (SuccessContinuation)new zzi(this, string2, string3, string));
    }

    final /* synthetic */ Task zza(String string, String string2, String string3, String string4) throws Exception {
        zzb.zza("", string, string2, string4, this.zzf.zzb());
        return Tasks.forResult((Object)new zzu(string3, string4));
    }

    final /* synthetic */ void zzi() {
        if (this.zzk.zza()) {
            this.zzj();
        }
    }

    private final class zza {
        private boolean zzb;
        private final Subscriber zzc;
        @GuardedBy(value="this")
        private boolean zzd;
        @GuardedBy(value="this")
        @Nullable
        private EventHandler<DataCollectionDefaultChange> zze;
        @GuardedBy(value="this")
        @Nullable
        private Boolean zzf;

        zza(Subscriber subscriber) {
            this.zzc = subscriber;
        }

        private final synchronized void zzb() {
            if (this.zzd) {
                return;
            }
            this.zzb = this.zzd();
            this.zzf = this.zzc();
            if (this.zzf == null && this.zzb) {
                this.zze = new zzk(this);
                this.zzc.subscribe(DataCollectionDefaultChange.class, this.zze);
            }
            this.zzd = true;
        }

        final synchronized boolean zza() {
            this.zzb();
            if (this.zzf != null) {
                return this.zzf;
            }
            return this.zzb && FirebaseInstanceId.this.zze.isDataCollectionDefaultEnabled();
        }

        final synchronized void zza(boolean bl) {
            this.zzb();
            if (this.zze != null) {
                this.zzc.unsubscribe(DataCollectionDefaultChange.class, this.zze);
                this.zze = null;
            }
            SharedPreferences.Editor editor = FirebaseInstanceId.this.zze.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
            editor.putBoolean("auto_init", bl);
            editor.apply();
            if (bl) {
                FirebaseInstanceId.this.zzj();
            }
            this.zzf = bl;
        }

        @Nullable
        private final Boolean zzc() {
            Context context = FirebaseInstanceId.this.zze.getApplicationContext();
            SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
            if (sharedPreferences.contains("auto_init")) {
                return sharedPreferences.getBoolean("auto_init", false);
            }
            try {
                ApplicationInfo applicationInfo;
                PackageManager packageManager = context.getPackageManager();
                if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("firebase_messaging_auto_init_enabled")) {
                    return applicationInfo.metaData.getBoolean("firebase_messaging_auto_init_enabled");
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
            return null;
        }

        private final boolean zzd() {
            try {
                Class.forName("com.google.firebase.messaging.FirebaseMessaging");
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Context context = FirebaseInstanceId.this.zze.getApplicationContext();
                Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
                intent.setPackage(context.getPackageName());
                ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
                return resolveInfo != null && resolveInfo.serviceInfo != null;
            }
        }
    }
}

