/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.events.EventHandler;
import com.google.firebase.events.Subscriber;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.zzab;
import com.google.firebase.iid.zzaq;
import com.google.firebase.iid.zzat;
import com.google.firebase.iid.zzay;
import com.google.firebase.iid.zzba;
import com.google.firebase.iid.zzbb;
import com.google.firebase.iid.zzbc;
import com.google.firebase.iid.zzh;
import com.google.firebase.iid.zzl;
import com.google.firebase.iid.zzm;
import com.google.firebase.iid.zzn;
import com.google.firebase.iid.zzo;
import com.google.firebase.iid.zzp;
import com.google.firebase.iid.zzq;
import com.google.firebase.iid.zzr;
import com.google.firebase.iid.zzs;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseInstanceId {
    private static final long zza = TimeUnit.HOURS.toSeconds(8L);
    private static zzay zzb;
    @GuardedBy(value="FirebaseInstanceId.class")
    @VisibleForTesting
    private static ScheduledExecutorService zzc;
    @VisibleForTesting
    private final Executor zzd;
    private final FirebaseApp zze;
    private final zzaq zzf;
    private final zzs zzg;
    private final zzat zzh;
    private final zzbc zzi;
    private final FirebaseInstallationsApi zzj;
    @GuardedBy(value="this")
    private boolean zzk = false;
    private final zza zzl;

    @NonNull
    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    @NonNull
    public static FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseInstanceId)firebaseApp.get(FirebaseInstanceId.class);
    }

    FirebaseInstanceId(FirebaseApp firebaseApp, Subscriber subscriber, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi) {
        this(firebaseApp, new zzaq(firebaseApp.getApplicationContext()), com.google.firebase.iid.zzh.zzb(), com.google.firebase.iid.zzh.zzb(), subscriber, userAgentPublisher, heartBeatInfo, firebaseInstallationsApi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FirebaseInstanceId(FirebaseApp firebaseApp, zzaq zzaq2, Executor executor, Executor executor2, Subscriber subscriber, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi) {
        if (zzaq.zza(firebaseApp) == null) {
            throw new IllegalStateException("FirebaseInstanceId failed to initialize, FirebaseApp is missing project ID");
        }
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzb == null) {
                zzb = new zzay(firebaseApp.getApplicationContext());
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            this.zze = firebaseApp;
            this.zzf = zzaq2;
            this.zzg = new zzs(firebaseApp, zzaq2, executor, userAgentPublisher, heartBeatInfo, firebaseInstallationsApi);
            this.zzd = executor2;
            this.zzi = new zzbc(zzb);
            this.zzl = new zza(subscriber);
            this.zzh = new zzat(executor);
            this.zzj = firebaseInstallationsApi;
            executor2.execute(new zzl(this));
            return;
        }
    }

    private final void zzj() {
        zzbb zzbb2 = this.zzb();
        if (this.zza(zzbb2) || this.zzi.zza()) {
            this.zzk();
        }
    }

    final FirebaseApp zza() {
        return this.zze;
    }

    final synchronized void zza(boolean bl) {
        this.zzk = bl;
    }

    private final synchronized void zzk() {
        if (!this.zzk) {
            this.zza(0L);
        }
    }

    final synchronized void zza(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zza);
        FirebaseInstanceId.zza(new zzba(this, this.zzf, this.zzi, l2), l);
        this.zzk = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzc == null) {
                zzc = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("FirebaseInstanceId"));
            }
            zzc.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    @NonNull
    public String getId() {
        this.zzj();
        return this.zzl();
    }

    private final String zzl() {
        try {
            zzb.zzc(this.zze.getPersistenceKey());
            Task task = this.zzj.getId();
            Preconditions.checkNotNull((Object)task, (Object)"Task must not be null");
            CountDownLatch countDownLatch = new CountDownLatch(1);
            task.addOnCompleteListener(zzm.zza, (OnCompleteListener)new zzp(countDownLatch));
            countDownLatch.await(30000L, TimeUnit.MILLISECONDS);
            Task task2 = task;
            if (!task2.isSuccessful()) {
                if (task2.isCanceled()) {
                    throw new CancellationException("Task is already canceled");
                }
                throw new IllegalStateException(task2.getException());
            }
            return (String)task2.getResult();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    public long getCreationTime() {
        return zzb.zzb(this.zze.getPersistenceKey());
    }

    @NonNull
    public Task<InstanceIdResult> getInstanceId() {
        return this.zza(zzaq.zza(this.zze), "*");
    }

    private final Task<InstanceIdResult> zza(String string, String string2) {
        String string3 = FirebaseInstanceId.zzd(string2);
        return Tasks.forResult(null).continueWithTask(this.zzd, (Continuation)new zzn(this, string, string3));
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        this.zza(this.zzj.delete());
        this.zze();
    }

    @Deprecated
    @Nullable
    public String getToken() {
        zzbb zzbb2 = this.zzb();
        if (this.zza(zzbb2)) {
            this.zzk();
        }
        return zzbb.zza(zzbb2);
    }

    @Nullable
    @WorkerThread
    public String getToken(@NonNull String string, @NonNull String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        return this.zza(this.zza(string, string2)).getToken();
    }

    @Nullable
    final zzbb zzb() {
        return FirebaseInstanceId.zzb(zzaq.zza(this.zze), "*");
    }

    @Nullable
    @VisibleForTesting
    private static zzbb zzb(String string, String string2) {
        return zzb.zza("", string, string2);
    }

    final String zzc() throws IOException {
        return this.getToken(zzaq.zza(this.zze), "*");
    }

    private final <T> T zza(Task<T> task) throws IOException {
        try {
            return (T)Tasks.await(task, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                if ("INSTANCE_ID_RESET".equals(throwable.getMessage())) {
                    this.zze();
                }
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IOException(executionException2);
        }
        catch (InterruptedException | TimeoutException exception) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
    }

    @WorkerThread
    public void deleteToken(@NonNull String string, @NonNull String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        string2 = FirebaseInstanceId.zzd(string2);
        String string3 = this.zzl();
        this.zza(this.zzg.zzb(string3, string, string2));
        zzb.zzb("", string, string2);
    }

    public final synchronized Task<Void> zza(String string) {
        Task<Void> task = this.zzi.zza(string);
        this.zzk();
        return task;
    }

    final void zzb(String string) throws IOException {
        zzbb zzbb2 = this.zzb();
        if (this.zza(zzbb2)) {
            throw new IOException("token not available");
        }
        String string2 = this.zzl();
        String string3 = string;
        String string4 = zzbb2.zza;
        String string5 = string2;
        Task<Void> task = this.zzg.zzc(string5, string4, string3);
        this.zza(task);
    }

    final void zzc(String string) throws IOException {
        zzbb zzbb2 = this.zzb();
        if (this.zza(zzbb2)) {
            throw new IOException("token not available");
        }
        String string2 = this.zzl();
        this.zza(this.zzg.zzd(string2, zzbb2.zza, string));
    }

    static boolean zzd() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }

    final synchronized void zze() {
        zzb.zzb();
        if (this.zzl.zza()) {
            this.zzk();
        }
    }

    final boolean zzf() {
        return this.zzf.zza() != 0;
    }

    final void zzg() {
        zzb.zzd("");
        this.zzk();
    }

    @VisibleForTesting
    public final boolean zzh() {
        return this.zzl.zza();
    }

    @VisibleForTesting
    public final void zzb(boolean bl) {
        this.zzl.zza(bl);
    }

    private static String zzd(String string) {
        if (string.isEmpty() || string.equalsIgnoreCase("fcm") || string.equalsIgnoreCase("gcm")) {
            return "*";
        }
        return string;
    }

    final boolean zza(@Nullable zzbb zzbb2) {
        return zzbb2 == null || zzbb2.zzb(this.zzf.zzb());
    }

    static final /* synthetic */ void zza(CountDownLatch countDownLatch, Task task) {
        countDownLatch.countDown();
    }

    final /* synthetic */ Task zza(String string, String string2, Task task) throws Exception {
        String string3 = this.zzl();
        zzbb zzbb2 = FirebaseInstanceId.zzb(string, string2);
        if (!this.zza(zzbb2)) {
            return Tasks.forResult((Object)new zzab(string3, zzbb2.zza));
        }
        return this.zzh.zza(string, string2, new zzo(this, string3, string, string2));
    }

    final /* synthetic */ Task zza(String string, String string2, String string3) {
        return this.zzg.zza(string, string2, string3).onSuccessTask(this.zzd, (SuccessContinuation)new zzq(this, string2, string3, string));
    }

    final /* synthetic */ Task zza(String string, String string2, String string3, String string4) throws Exception {
        zzb.zza("", string, string2, string4, this.zzf.zzb());
        return Tasks.forResult((Object)new zzab(string3, string4));
    }

    final /* synthetic */ void zzi() {
        if (this.zzl.zza()) {
            this.zzj();
        }
    }

    private final class zza {
        private boolean zzb;
        private final Subscriber zzc;
        @GuardedBy(value="this")
        private boolean zzd;
        @GuardedBy(value="this")
        @Nullable
        private EventHandler<DataCollectionDefaultChange> zze;
        @GuardedBy(value="this")
        @Nullable
        private Boolean zzf;

        zza(Subscriber subscriber) {
            this.zzc = subscriber;
        }

        private final synchronized void zzb() {
            if (this.zzd) {
                return;
            }
            this.zzb = this.zzd();
            this.zzf = this.zzc();
            if (this.zzf == null && this.zzb) {
                this.zze = new zzr(this);
                this.zzc.subscribe(DataCollectionDefaultChange.class, this.zze);
            }
            this.zzd = true;
        }

        final synchronized boolean zza() {
            this.zzb();
            if (this.zzf != null) {
                return this.zzf;
            }
            return this.zzb && FirebaseInstanceId.this.zze.isDataCollectionDefaultEnabled();
        }

        final synchronized void zza(boolean bl) {
            this.zzb();
            if (this.zze != null) {
                this.zzc.unsubscribe(DataCollectionDefaultChange.class, this.zze);
                this.zze = null;
            }
            SharedPreferences.Editor editor = FirebaseInstanceId.this.zze.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
            editor.putBoolean("auto_init", bl);
            editor.apply();
            if (bl) {
                FirebaseInstanceId.this.zzj();
            }
            this.zzf = bl;
        }

        @Nullable
        private final Boolean zzc() {
            Context context = FirebaseInstanceId.this.zze.getApplicationContext();
            SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
            if (sharedPreferences.contains("auto_init")) {
                return sharedPreferences.getBoolean("auto_init", false);
            }
            try {
                ApplicationInfo applicationInfo;
                PackageManager packageManager = context.getPackageManager();
                if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("firebase_messaging_auto_init_enabled")) {
                    return applicationInfo.metaData.getBoolean("firebase_messaging_auto_init_enabled");
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
            return null;
        }

        private final boolean zzd() {
            try {
                Class.forName("com.google.firebase.messaging.FirebaseMessaging");
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Context context = FirebaseInstanceId.this.zze.getApplicationContext();
                Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
                intent.setPackage(context.getPackageName());
                ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
                return resolveInfo != null && resolveInfo.serviceInfo != null;
            }
        }
    }
}

