/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.LibraryVersion;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.zzaq;
import com.google.firebase.iid.zzax;
import com.google.firebase.iid.zzh;
import com.google.firebase.iid.zzu;
import com.google.firebase.iid.zzv;
import com.google.firebase.iid.zzx;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.installations.InstallationTokenResult;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

final class zzs {
    private final FirebaseApp zza;
    private final zzaq zzb;
    private final zzax zzc;
    private final Executor zzd;
    private final UserAgentPublisher zze;
    private final HeartBeatInfo zzf;
    private final FirebaseInstallationsApi zzg;

    zzs(FirebaseApp firebaseApp, zzaq zzaq2, Executor executor, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi) {
        this(firebaseApp, zzaq2, executor, new zzax(firebaseApp.getApplicationContext(), zzaq2), userAgentPublisher, heartBeatInfo, firebaseInstallationsApi);
    }

    @VisibleForTesting
    private zzs(FirebaseApp firebaseApp, zzaq zzaq2, Executor executor, zzax zzax2, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi) {
        this.zza = firebaseApp;
        this.zzb = zzaq2;
        this.zzc = zzax2;
        this.zzd = executor;
        this.zze = userAgentPublisher;
        this.zzf = heartBeatInfo;
        this.zzg = firebaseInstallationsApi;
    }

    public final Task<String> zza(String string, String string2, String string3) {
        Task<Bundle> task = this.zza(string, string2, string3, new Bundle());
        return this.zzb(task);
    }

    public final Task<Void> zzb(String string, String string2, String string3) {
        Bundle bundle = new Bundle();
        bundle.putString("delete", "1");
        Task<Bundle> task = this.zza(string, string2, string3, bundle);
        return this.zza(this.zzb(task));
    }

    public final Task<Void> zzc(String string, String string2, String string3) {
        Bundle bundle = new Bundle();
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string3);
        bundle.putString("gcm.topic", string5.length() != 0 ? string4.concat(string5) : new String(string4));
        String string6 = string2;
        String string7 = String.valueOf("/topics/");
        String string8 = String.valueOf(string3);
        String string9 = string8.length() != 0 ? string7.concat(string8) : new String(string7);
        Task<Bundle> task = this.zza(string, string6, string9, bundle);
        return this.zza(this.zzb(task));
    }

    public final Task<Void> zzd(String string, String string2, String string3) {
        Bundle bundle = new Bundle();
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string3);
        bundle.putString("gcm.topic", string5.length() != 0 ? string4.concat(string5) : new String(string4));
        bundle.putString("delete", "1");
        String string6 = string2;
        String string7 = String.valueOf("/topics/");
        String string8 = String.valueOf(string3);
        String string9 = string8.length() != 0 ? string7.concat(string8) : new String(string7);
        Task<Bundle> task = this.zza(string, string6, string9, bundle);
        return this.zza(this.zzb(task));
    }

    private final Task<Bundle> zza(String string, String string2, String string3, Bundle bundle) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzd.execute(new zzv(this, string, string2, string3, bundle, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    private final String zza() {
        String string = this.zza.getName();
        String string2 = "SHA-1";
        try {
            return Base64.encodeToString((byte[])MessageDigest.getInstance(string2).digest(string.getBytes()), (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "[HASH-ERROR]";
        }
    }

    private final Bundle zzb(String string, String string2, String string3, Bundle bundle) {
        String string4;
        bundle.putString("scope", string3);
        bundle.putString("sender", string2);
        bundle.putString("subtype", string2);
        bundle.putString("appid", string);
        bundle.putString("gmp_app_id", this.zza.getOptions().getApplicationId());
        bundle.putString("gmsv", Integer.toString(this.zzb.zzd()));
        bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle.putString("app_ver", this.zzb.zzb());
        bundle.putString("app_ver_name", this.zzb.zzc());
        bundle.putString("firebase-app-name-hash", this.zza());
        try {
            string4 = ((InstallationTokenResult)Tasks.await((Task)this.zzg.getToken(false))).getToken();
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                bundle.putString("Goog-Firebase-Installations-Auth", string4);
            } else {
                Log.w((String)"FirebaseInstanceId", (String)"FIS auth token is empty");
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            Log.e((String)"FirebaseInstanceId", (String)"Failed to get FIS auth token", (Throwable)exception);
        }
        string4 = LibraryVersion.getInstance().getVersion("firebase-iid");
        if ("UNKNOWN".equals(string4)) {
            int n = GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
            string4 = new StringBuilder(19).append("unknown_").append(n).toString();
        }
        String string5 = String.valueOf(string4);
        bundle.putString("cliv", string5.length() != 0 ? "fiid-".concat(string5) : new String("fiid-"));
        HeartBeatInfo.HeartBeat heartBeat = this.zzf.getHeartBeatCode("fire-iid");
        if (heartBeat != HeartBeatInfo.HeartBeat.NONE) {
            bundle.putString("Firebase-Client-Log-Type", Integer.toString(heartBeat.getCode()));
            bundle.putString("Firebase-Client", this.zze.getUserAgent());
        }
        return bundle;
    }

    private static String zza(Bundle bundle) throws IOException {
        if (bundle == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string = bundle.getString("registration_id");
        if (string != null) {
            return string;
        }
        String string2 = bundle.getString("unregistered");
        if (string2 != null) {
            return string2;
        }
        String string3 = bundle.getString("error");
        if ("RST".equals(string3)) {
            throw new IOException("INSTANCE_ID_RESET");
        }
        if (string3 != null) {
            throw new IOException(string3);
        }
        String string4 = String.valueOf(bundle);
        Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(21 + String.valueOf(string4).length()).append("Unexpected response: ").append(string4).toString(), (Throwable)new Throwable());
        throw new IOException("SERVICE_NOT_AVAILABLE");
    }

    private final <T> Task<Void> zza(Task<T> task) {
        return task.continueWith(zzh.zza(), (Continuation)new zzu(this));
    }

    private final Task<String> zzb(Task<Bundle> task) {
        return task.continueWith(this.zzd, (Continuation)new zzx(this));
    }

    final /* synthetic */ void zza(String string, String string2, String string3, Bundle bundle, TaskCompletionSource taskCompletionSource) {
        try {
            this.zzb(string, string2, string3, bundle);
            Bundle bundle2 = this.zzc.zza(bundle);
            taskCompletionSource.setResult((Object)bundle2);
            return;
        }
        catch (IOException iOException) {
            taskCompletionSource.setException((Exception)iOException);
            return;
        }
    }

    static /* synthetic */ String zza(zzs zzs2, Bundle bundle) throws IOException {
        return zzs.zza(bundle);
    }
}

