/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.firebase_messaging.zze;
import com.google.firebase.iid.zzab;
import com.google.firebase.iid.zzad;
import com.google.firebase.iid.zzae;
import com.google.firebase.iid.zzaf;
import com.google.firebase.iid.zzag;
import com.google.firebase.iid.zzah;
import com.google.firebase.iid.zzaj;
import com.google.firebase.iid.zzal;
import com.google.firebase.iid.zzam;
import com.google.firebase.iid.zzan;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

final class zzac
implements ServiceConnection {
    @GuardedBy(value="this")
    int zza = 0;
    final Messenger zzb = new Messenger((Handler)new zze(Looper.getMainLooper(), new zzaf(this)));
    zzal zzc;
    @GuardedBy(value="this")
    final Queue<zzan<?>> zzd = new ArrayDeque();
    @GuardedBy(value="this")
    final SparseArray<zzan<?>> zze = new SparseArray();
    final /* synthetic */ zzab zzf;

    private zzac(zzab zzab2) {
        this.zzf = zzab2;
    }

    final synchronized boolean zza(zzan<?> zzan2) {
        switch (this.zza) {
            case 0: {
                this.zzd.add(zzan2);
                zzac zzac2 = this;
                Preconditions.checkState((zzac2.zza == 0 ? 1 : 0) != 0);
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
                }
                zzac2.zza = 1;
                Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
                intent.setPackage("com.google.android.gms");
                if (!ConnectionTracker.getInstance().bindService(zzab.zza(zzac2.zzf), intent, (ServiceConnection)zzac2, 1)) {
                    zzac2.zza(0, "Unable to bind to service");
                } else {
                    zzab.zzb(zzac2.zzf).schedule(new zzae(zzac2), 30L, TimeUnit.SECONDS);
                }
                return true;
            }
            case 1: {
                this.zzd.add(zzan2);
                return true;
            }
            case 2: {
                this.zzd.add(zzan2);
                this.zza();
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        int n = this.zza;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(Message message) {
        zzan zzan2;
        int n = message.arg1;
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            Log.d((String)"MessengerIpcClient", (String)new StringBuilder(41).append("Received response to request: ").append(n).toString());
        }
        zzac zzac2 = this;
        synchronized (zzac2) {
            zzan2 = (zzan)this.zze.get(n);
            if (zzan2 == null) {
                Log.w((String)"MessengerIpcClient", (String)new StringBuilder(50).append("Received response for unknown request: ").append(n).toString());
                return true;
            }
            this.zze.remove(n);
            this.zzb();
        }
        Bundle bundle = message.getData();
        zzan zzan3 = zzan2;
        if (bundle.getBoolean("unsupported", false)) {
            zzan3.zza(new zzam(4, "Not supported by GmsCore"));
        } else {
            zzan3.zza(bundle);
        }
        return true;
    }

    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service connected");
        }
        zzab.zzb(this.zzf).execute(new zzah(this, iBinder));
    }

    final void zza() {
        zzab.zzb(this.zzf).execute(new zzag(this));
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
        }
        zzab.zzb(this.zzf).execute(new zzaj(this));
    }

    final synchronized void zza(int n, String string) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"MessengerIpcClient", (String)(string2.length() != 0 ? "Disconnected: ".concat(string2) : new String("Disconnected: ")));
        }
        switch (this.zza) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: 
            case 2: {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                }
                this.zza = 4;
                ConnectionTracker.getInstance().unbindService(zzab.zza(this.zzf), (ServiceConnection)this);
                zzam zzam2 = new zzam(n, string);
                zzac zzac2 = this;
                Iterator iterator = zzac2.zzd.iterator();
                while (iterator.hasNext()) {
                    ((zzan)iterator.next()).zza(zzam2);
                }
                zzac2.zzd.clear();
                for (int i = 0; i < zzac2.zze.size(); ++i) {
                    ((zzan)zzac2.zze.valueAt(i)).zza(zzam2);
                }
                zzac2.zze.clear();
                return;
            }
            case 3: {
                this.zza = 4;
                return;
            }
            case 4: {
                return;
            }
        }
        int n2 = this.zza;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n2).toString());
    }

    final synchronized void zzb() {
        if (this.zza == 2 && this.zzd.isEmpty() && this.zze.size() == 0) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
            }
            this.zza = 3;
            ConnectionTracker.getInstance().unbindService(zzab.zza(this.zzf), (ServiceConnection)this);
        }
    }

    final synchronized void zzc() {
        if (this.zza == 1) {
            this.zza(1, "Timed out while binding");
        }
    }

    final synchronized void zza(int n) {
        zzan zzan2 = (zzan)this.zze.get(n);
        if (zzan2 != null) {
            Log.w((String)"MessengerIpcClient", (String)new StringBuilder(31).append("Timing out request: ").append(n).toString());
            this.zze.remove(n);
            zzan2.zza(new zzam(3, "Timed out waiting for response"));
            this.zzb();
        }
    }

    /* synthetic */ zzac(zzab zzab2, zzad zzad2) {
        this(zzab2);
    }
}

