/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.AnyThread;
import androidx.collection.SimpleArrayMap;
import com.google.android.gms.internal.firebase-iid.zze;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.FirebaseIidExecutors;
import com.google.firebase.iid.FirebaseIidMessengerCompat;
import com.google.firebase.iid.MessengerIpcClient;
import com.google.firebase.iid.Metadata;
import com.google.firebase.iid.Rpc$$Lambda$0;
import com.google.firebase.iid.Rpc$$Lambda$1;
import com.google.firebase.iid.Rpc$$Lambda$2;
import com.google.firebase.iid.Rpc$$Lambda$3;
import com.google.firebase.iid.Rpc$$Lambda$4;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;

class Rpc {
    private static int requestId = 0;
    private static PendingIntent appPendingIntent;
    @GuardedBy(value="responseCallbacks")
    private final SimpleArrayMap<String, TaskCompletionSource<Bundle>> responseCallbacks = new SimpleArrayMap();
    private final Context context;
    private final Metadata metadata;
    private final ScheduledExecutorService timeoutExecutor;
    private Messenger responseMessenger;
    private Messenger outgoingMessenger;
    private FirebaseIidMessengerCompat outgoingMessengerCompat;

    public Rpc(Context context, Metadata metadata) {
        this.context = context;
        this.metadata = metadata;
        this.responseMessenger = new Messenger((Handler)new zze(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                Rpc.this.handleIncomingMessage(message);
            }
        });
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
        scheduledThreadPoolExecutor.setKeepAliveTime(60L, TimeUnit.SECONDS);
        scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);
        this.timeoutExecutor = scheduledThreadPoolExecutor;
    }

    private void handleIncomingMessage(Message message) {
        if (message != null && message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader((ClassLoader)new FirebaseIidMessengerCompat.HandleOldParcelNameClassLoader());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof FirebaseIidMessengerCompat) {
                    this.outgoingMessengerCompat = (FirebaseIidMessengerCompat)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.outgoingMessenger = (Messenger)parcelable;
                }
            }
            this.handleIidResponse((Intent)message.obj);
            return;
        }
        Log.w((String)"FirebaseInstanceId", (String)"Dropping invalid message");
    }

    public static synchronized void setPendingIntentExtra(Context context, Intent intent) {
        if (appPendingIntent == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            appPendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)appPendingIntent);
    }

    private void startRegisterRpc(Bundle bundle, String string) {
        Intent intent = new Intent();
        intent.setPackage("com.google.android.gms");
        if (this.metadata.getIidImplementation() == 2) {
            intent.setAction("com.google.iid.TOKEN_REQUEST");
        } else {
            intent.setAction("com.google.android.c2dm.intent.REGISTER");
        }
        intent.putExtras(bundle);
        Rpc.setPendingIntentExtra(this.context, intent);
        this.sendRequest(intent, string);
    }

    protected void sendRequest(Intent intent, String string) {
        block6: {
            String string2;
            intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string).length()).append("|ID|").append(string).append("|").toString());
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                string2 = String.valueOf(intent.getExtras());
                Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
            }
            intent.putExtra("google.messenger", (Parcelable)this.responseMessenger);
            if (this.outgoingMessenger != null || this.outgoingMessengerCompat != null) {
                string2 = Message.obtain();
                Message.obtain().obj = intent;
                try {
                    if (this.outgoingMessenger != null) {
                        this.outgoingMessenger.send((Message)string2);
                        return;
                    }
                    this.outgoingMessengerCompat.send((Message)string2);
                    return;
                }
                catch (RemoteException remoteException) {
                    if (!Log.isLoggable((String)"FirebaseInstanceId", (int)3)) break block6;
                    Log.d((String)"FirebaseInstanceId", (String)"Messenger failed, fallback to startService");
                }
            }
        }
        if (this.metadata.getIidImplementation() == 2) {
            this.context.sendBroadcast(intent);
            return;
        }
        this.context.startService(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processError(Intent intent) {
        String string = intent.getStringExtra("error");
        if (string == null) {
            String string2 = String.valueOf(intent.getExtras());
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(49 + String.valueOf(string2).length()).append("Unexpected response, no error or registration id ").append(string2).toString());
            return;
        }
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            String string3 = String.valueOf(string);
            Log.d((String)"FirebaseInstanceId", (String)(string3.length() != 0 ? "Received InstanceID error ".concat(string3) : new String("Received InstanceID error ")));
        }
        if (string.startsWith("|")) {
            String[] stringArray = string.split("\\|");
            if (stringArray.length <= 2 || !"ID".equals(stringArray[1])) {
                String string4 = String.valueOf(string);
                Log.w((String)"FirebaseInstanceId", (String)(string4.length() != 0 ? "Unexpected structured response ".concat(string4) : new String("Unexpected structured response ")));
                return;
            }
            String string5 = stringArray[2];
            string = stringArray[3];
            if (string.startsWith(":")) {
                string = string.substring(1);
            }
            this.setResponse(string5, intent.putExtra("error", string).getExtras());
            return;
        }
        SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.responseCallbacks;
        synchronized (simpleArrayMap) {
            for (int i = 0; i < this.responseCallbacks.size(); ++i) {
                this.setResponse((String)this.responseCallbacks.keyAt(i), intent.getExtras());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResponse(String string, Bundle bundle) {
        SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.responseCallbacks;
        synchronized (simpleArrayMap) {
            TaskCompletionSource taskCompletionSource = (TaskCompletionSource)this.responseCallbacks.remove((Object)string);
            if (taskCompletionSource == null) {
                String string2 = String.valueOf(string);
                Log.w((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Missing callback for ".concat(string2) : new String("Missing callback for ")));
                return;
            }
            taskCompletionSource.setResult((Object)bundle);
            return;
        }
    }

    private void handleIidResponse(Intent intent) {
        String string = intent.getAction();
        if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string)) {
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                String string2 = String.valueOf(string);
                Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Unexpected response action: ".concat(string2) : new String("Unexpected response action: ")));
            }
            return;
        }
        String string3 = intent.getStringExtra("registration_id");
        if (string3 == null) {
            string3 = intent.getStringExtra("unregistered");
        }
        if (string3 == null) {
            this.processError(intent);
            return;
        }
        Matcher matcher = Pattern.compile("\\|ID\\|([^|]+)\\|:?+(.*)").matcher(string3);
        if (!matcher.matches()) {
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                String string4 = String.valueOf(string3);
                Log.d((String)"FirebaseInstanceId", (String)(string4.length() != 0 ? "Unexpected response string: ".concat(string4) : new String("Unexpected response string: ")));
            }
            return;
        }
        String string5 = matcher.group(1);
        String string6 = matcher.group(2);
        Bundle bundle = intent.getExtras();
        bundle.putString("registration_id", string6);
        this.setResponse(string5, bundle);
    }

    Task<Bundle> registerRpc(Bundle bundle) {
        if (this.metadata.getGmsVersionCode() >= 12000000) {
            return MessengerIpcClient.getInstance(this.context).sendRequestForResponse(1, bundle).continueWith(FirebaseIidExecutors.directExecutor(), Rpc$$Lambda$0.$instance);
        }
        return this.registerRpcViaIntent(bundle);
    }

    private Task<Bundle> registerRpcViaIntent(Bundle bundle) {
        if (!this.metadata.isGmscorePresent()) {
            return Tasks.forException((Exception)new IOException("MISSING_INSTANCEID_SERVICE"));
        }
        return this.registerRpcInternal(bundle).continueWithTask(FirebaseIidExecutors.directExecutor(), (Continuation)new Rpc$$Lambda$1(this, bundle));
    }

    private static boolean gmsCoreRespondedWithMessenger(Bundle bundle) {
        return bundle != null && bundle.containsKey("google.messenger");
    }

    public static synchronized String nextId() {
        return Integer.toString(requestId++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    private Task<Bundle> registerRpcInternal(Bundle bundle) {
        String string = Rpc.nextId();
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Object object = this.responseCallbacks;
        synchronized (object) {
            this.responseCallbacks.put((Object)string, (Object)taskCompletionSource);
        }
        this.startRegisterRpc(bundle, string);
        object = this.timeoutExecutor.schedule(new Rpc$$Lambda$2(taskCompletionSource), 30L, TimeUnit.SECONDS);
        taskCompletionSource.getTask().addOnCompleteListener(FirebaseIidExecutors.directExecutor(), (OnCompleteListener)new Rpc$$Lambda$3(this, string, (ScheduledFuture)object));
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void lambda$registerRpcInternal$4$Rpc(String string, ScheduledFuture scheduledFuture, Task task) {
        SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.responseCallbacks;
        synchronized (simpleArrayMap) {
            this.responseCallbacks.remove((Object)string);
        }
        scheduledFuture.cancel(false);
    }

    static final /* synthetic */ void lambda$registerRpcInternal$3$Rpc(TaskCompletionSource taskCompletionSource) {
        if (taskCompletionSource.trySetException((Exception)new IOException("TIMEOUT"))) {
            Log.w((String)"FirebaseInstanceId", (String)"No response");
        }
    }

    final /* synthetic */ Task lambda$registerRpcViaIntent$2$Rpc(Bundle bundle, Task task) throws Exception {
        if (!task.isSuccessful()) {
            return task;
        }
        if (!Rpc.gmsCoreRespondedWithMessenger((Bundle)task.getResult())) {
            return task;
        }
        return this.registerRpcInternal(bundle).onSuccessTask(FirebaseIidExecutors.directExecutor(), Rpc$$Lambda$4.$instance);
    }

    static final /* synthetic */ Task lambda$registerRpcViaIntent$1$Rpc(Bundle bundle) throws Exception {
        if (Rpc.gmsCoreRespondedWithMessenger(bundle)) {
            return Tasks.forResult(null);
        }
        return Tasks.forResult((Object)bundle);
    }

    static final /* synthetic */ Bundle lambda$registerRpc$0$Rpc(Task task) throws Exception {
        if (task.isSuccessful()) {
            return (Bundle)task.getResult();
        }
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            String string = String.valueOf(task.getException());
            Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(22 + String.valueOf(string).length()).append("Error making request: ").append(string).toString());
        }
        throw new IOException("SERVICE_NOT_AVAILABLE");
    }
}

