/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.PowerManager;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.GmsRpc;
import com.google.firebase.iid.ServiceStarter;
import com.google.firebase.iid.Store;
import java.io.IOException;
import javax.annotation.Nullable;

class SyncTask
implements Runnable {
    private final long nextDelaySeconds;
    private final PowerManager.WakeLock syncWakeLock;
    private final FirebaseInstanceId iid;

    @VisibleForTesting
    SyncTask(FirebaseInstanceId firebaseInstanceId, long l) {
        this.iid = firebaseInstanceId;
        this.nextDelaySeconds = l;
        PowerManager powerManager = (PowerManager)this.getContext().getSystemService("power");
        this.syncWakeLock = powerManager.newWakeLock(1, "fiid-sync");
        this.syncWakeLock.setReferenceCounted(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SuppressLint(value={"Wakelock"})
    public void run() {
        if (ServiceStarter.getInstance().hasWakeLockPermission(this.getContext())) {
            this.syncWakeLock.acquire();
        }
        try {
            this.iid.setSyncScheduledOrRunning(true);
            if (!this.iid.isGmsCorePresent()) {
                this.iid.setSyncScheduledOrRunning(false);
                return;
            }
            if (ServiceStarter.getInstance().hasAccessNetworkStatePermission(this.getContext()) && !this.isDeviceConnected()) {
                new ConnectivityChangeReceiver(this).registerReceiver();
                return;
            }
            if (this.maybeRefreshToken()) {
                this.iid.setSyncScheduledOrRunning(false);
            } else {
                this.iid.syncWithDelaySecondsInternal(this.nextDelaySeconds);
            }
            if (!ServiceStarter.getInstance().hasWakeLockPermission(this.getContext())) return;
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            Log.e((String)"FirebaseInstanceId", (String)new StringBuilder(93 + String.valueOf(string).length()).append("Topic sync or token retrieval failed on hard failure exceptions: ").append(string).append(". Won't retry the operation.").toString());
            this.iid.setSyncScheduledOrRunning(false);
            return;
        }
        finally {
            if (!ServiceStarter.getInstance().hasWakeLockPermission(this.getContext())) return;
            this.syncWakeLock.release();
        }
        this.syncWakeLock.release();
        return;
    }

    @VisibleForTesting
    boolean maybeRefreshToken() throws IOException {
        Store.Token token = this.iid.getTokenWithoutTriggeringSync();
        if (!this.iid.tokenNeedsRefresh(token)) {
            return true;
        }
        try {
            String string = this.iid.blockingGetMasterToken();
            if (string == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Token retrieval failed: null");
                return false;
            }
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Token successfully retrieved");
            }
            if (token == null || token != null && !string.equals(token.token)) {
                this.invokeOnTokenRefresh(string);
            }
            return true;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            if (GmsRpc.isErrorMessageForRetryableError(iOException.getMessage())) {
                String string = iOException2.getMessage();
                Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(52 + String.valueOf(string).length()).append("Token retrieval failed: ").append(string).append(". Will retry token retrieval").toString());
                return false;
            }
            if (iOException2.getMessage() == null) {
                Log.w((String)"FirebaseInstanceId", (String)"Token retrieval failed without exception message. Will retry token retrieval");
                return false;
            }
            throw iOException2;
        }
        catch (SecurityException securityException) {
            Log.w((String)"FirebaseInstanceId", (String)"Token retrieval failed with SecurityException. Will retry token retrieval");
            return false;
        }
    }

    private void invokeOnTokenRefresh(String string) {
        if ("[DEFAULT]".equals(this.iid.getApp().getName())) {
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                String string2 = String.valueOf(this.iid.getApp().getName());
                Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Invoking onNewToken for app: ".concat(string2) : new String("Invoking onNewToken for app: ")));
            }
            Intent intent = new Intent("com.google.firebase.messaging.NEW_TOKEN");
            intent.putExtra("token", string);
            ServiceStarter.startMessagingServiceViaReceiver(this.getContext(), intent);
        }
    }

    Context getContext() {
        return this.iid.getApp().getApplicationContext();
    }

    boolean isDeviceConnected() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }

    @VisibleForTesting
    static class ConnectivityChangeReceiver
    extends BroadcastReceiver {
        @Nullable
        private SyncTask task;

        public ConnectivityChangeReceiver(SyncTask syncTask) {
            this.task = syncTask;
        }

        public void registerReceiver() {
            if (FirebaseInstanceId.isDebugLogEnabled()) {
                Log.d((String)"FirebaseInstanceId", (String)"Connectivity change received registered");
            }
            IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            this.task.getContext().registerReceiver((BroadcastReceiver)this, intentFilter);
        }

        public void onReceive(Context context, Intent intent) {
            if (this.task == null) {
                return;
            }
            if (!this.task.isDeviceConnected()) {
                return;
            }
            if (FirebaseInstanceId.isDebugLogEnabled()) {
                Log.d((String)"FirebaseInstanceId", (String)"Connectivity changed. Starting background sync.");
            }
            this.task.iid.enqueueTaskWithDelaySeconds(this.task, 0L);
            this.task.getContext().unregisterReceiver((BroadcastReceiver)this);
            this.task = null;
        }
    }
}

