/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.cloudmessaging.CloudMessage;
import com.google.android.gms.cloudmessaging.CloudMessagingReceiver;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.FcmBroadcastProcessor;
import java.util.concurrent.ExecutionException;

public final class FirebaseInstanceIdReceiver
extends CloudMessagingReceiver {
    private static Intent createServiceIntent(@NonNull Context context, @NonNull String string, @NonNull Bundle bundle) {
        return new Intent(string).putExtras(bundle);
    }

    @WorkerThread
    protected final int onMessageReceive(@NonNull Context context, @NonNull CloudMessage cloudMessage) {
        try {
            return (Integer)Tasks.await(new FcmBroadcastProcessor(context).process(cloudMessage.getIntent()));
        }
        catch (InterruptedException | ExecutionException exception) {
            Log.e((String)"FirebaseInstanceId", (String)"Failed to send message to service.", (Throwable)exception);
            return 500;
        }
    }

    @WorkerThread
    protected final void onNotificationOpen(@NonNull Context context, @NonNull Bundle bundle) {
        try {
            Intent intent = FirebaseInstanceIdReceiver.createServiceIntent(context, "com.google.firebase.messaging.NOTIFICATION_OPEN", bundle);
            Tasks.await(new FcmBroadcastProcessor(context).process(intent));
            return;
        }
        catch (InterruptedException | ExecutionException exception) {
            Log.e((String)"FirebaseInstanceId", (String)"Failed to send notification open event to service.", (Throwable)exception);
            return;
        }
    }

    @WorkerThread
    protected final void onNotificationDismissed(@NonNull Context context, @NonNull Bundle bundle) {
        try {
            Intent intent = FirebaseInstanceIdReceiver.createServiceIntent(context, "com.google.firebase.messaging.NOTIFICATION_DISMISS", bundle);
            Tasks.await(new FcmBroadcastProcessor(context).process(intent));
            return;
        }
        catch (InterruptedException | ExecutionException exception) {
            Log.e((String)"FirebaseInstanceId", (String)"Failed to send notification dismissed event to service.", (Throwable)exception);
            return;
        }
    }
}

