/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.AnyThread;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.cloudmessaging.Rpc;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.FirebaseIidExecutors;
import com.google.firebase.iid.GmsRpc$$Lambda$0;
import com.google.firebase.iid.Metadata;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.installations.InstallationTokenResult;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;

@KeepForSdk
public class GmsRpc {
    @KeepForSdk
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    @KeepForSdk
    public static final String ERROR_INTERNAL_SERVER_ERROR = "INTERNAL_SERVER_ERROR";
    private final FirebaseApp app;
    private final Metadata metadata;
    private final Rpc rpc;
    private final UserAgentPublisher userAgentPublisher;
    private final HeartBeatInfo heartbeatInfo;
    private final FirebaseInstallationsApi firebaseInstallations;

    public GmsRpc(FirebaseApp firebaseApp, Metadata metadata, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi) {
        this(firebaseApp, metadata, new Rpc(firebaseApp.getApplicationContext()), userAgentPublisher, heartBeatInfo, firebaseInstallationsApi);
    }

    @VisibleForTesting
    GmsRpc(FirebaseApp firebaseApp, Metadata metadata, Rpc rpc, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi) {
        this.app = firebaseApp;
        this.metadata = metadata;
        this.rpc = rpc;
        this.userAgentPublisher = userAgentPublisher;
        this.heartbeatInfo = heartBeatInfo;
        this.firebaseInstallations = firebaseInstallationsApi;
    }

    public Task<String> getToken(String string, String string2, String string3) {
        Task<Bundle> task = this.startRpc(string, string2, string3, new Bundle());
        return this.extractResponseWhenComplete(task);
    }

    public Task<?> deleteToken(String string, String string2, String string3) {
        Bundle bundle = new Bundle();
        bundle.putString("delete", "1");
        Task<Bundle> task = this.startRpc(string, string2, string3, bundle);
        return this.extractResponseWhenComplete(task);
    }

    public Task<?> deleteInstanceId(String string) {
        Bundle bundle = new Bundle();
        bundle.putString("iid-operation", "delete");
        bundle.putString("delete", "1");
        Task<Bundle> task = this.startRpc(string, "*", "*", bundle);
        return this.extractResponseWhenComplete(task);
    }

    @KeepForSdk
    public Task<?> subscribeToTopic(String string, String string2, String string3) {
        Bundle bundle = new Bundle();
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string3);
        bundle.putString("gcm.topic", string5.length() != 0 ? string4.concat(string5) : new String(string4));
        String string6 = string2;
        String string7 = String.valueOf("/topics/");
        String string8 = String.valueOf(string3);
        String string9 = string8.length() != 0 ? string7.concat(string8) : new String(string7);
        Task<Bundle> task = this.startRpc(string, string6, string9, bundle);
        return this.extractResponseWhenComplete(task);
    }

    @KeepForSdk
    public Task<?> unsubscribeFromTopic(String string, String string2, String string3) {
        Bundle bundle = new Bundle();
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string3);
        bundle.putString("gcm.topic", string5.length() != 0 ? string4.concat(string5) : new String(string4));
        bundle.putString("delete", "1");
        String string6 = string2;
        String string7 = String.valueOf("/topics/");
        String string8 = String.valueOf(string3);
        String string9 = string8.length() != 0 ? string7.concat(string8) : new String(string7);
        Task<Bundle> task = this.startRpc(string, string6, string9, bundle);
        return this.extractResponseWhenComplete(task);
    }

    private Task<Bundle> startRpc(String string, String string2, String string3, Bundle bundle) {
        this.setDefaultAttributesToBundle(string, string2, string3, bundle);
        return this.rpc.send(bundle);
    }

    private static String base64UrlSafe(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)11);
    }

    private String getHashedFirebaseAppName() {
        String string = this.app.getName();
        String string2 = "SHA-1";
        try {
            return GmsRpc.base64UrlSafe(MessageDigest.getInstance(string2).digest(string.getBytes()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "[HASH-ERROR]";
        }
    }

    private Bundle setDefaultAttributesToBundle(String string, String string2, String string3, Bundle bundle) {
        String string4;
        bundle.putString("scope", string3);
        bundle.putString("sender", string2);
        bundle.putString("subtype", string2);
        bundle.putString("appid", string);
        bundle.putString("gmp_app_id", this.app.getOptions().getApplicationId());
        bundle.putString("gmsv", Integer.toString(this.metadata.getGmsVersionCode()));
        bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle.putString("app_ver", this.metadata.getAppVersionCode());
        bundle.putString("app_ver_name", this.metadata.getAppVersionName());
        bundle.putString("firebase-app-name-hash", this.getHashedFirebaseAppName());
        try {
            string4 = ((InstallationTokenResult)Tasks.await((Task)this.firebaseInstallations.getToken(false))).getToken();
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                bundle.putString("Goog-Firebase-Installations-Auth", string4);
            } else {
                Log.w((String)"FirebaseInstanceId", (String)"FIS auth token is empty");
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            Log.e((String)"FirebaseInstanceId", (String)"Failed to get FIS auth token", (Throwable)exception);
        }
        string4 = "20.3.0";
        String string5 = String.valueOf(string4);
        bundle.putString("cliv", string5.length() != 0 ? "fiid-".concat(string5) : new String("fiid-"));
        HeartBeatInfo.HeartBeat heartBeat = this.heartbeatInfo.getHeartBeatCode("fire-iid");
        if (heartBeat != HeartBeatInfo.HeartBeat.NONE) {
            bundle.putString("Firebase-Client-Log-Type", Integer.toString(heartBeat.getCode()));
            bundle.putString("Firebase-Client", this.userAgentPublisher.getUserAgent());
        }
        return bundle;
    }

    @AnyThread
    private String handleResponse(Bundle bundle) throws IOException {
        if (bundle == null) {
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        String string = bundle.getString("registration_id");
        if (string != null) {
            return string;
        }
        String string2 = bundle.getString("unregistered");
        if (string2 != null) {
            return string2;
        }
        String string3 = bundle.getString("error");
        if ("RST".equals(string3)) {
            throw new IOException("INSTANCE_ID_RESET");
        }
        if (string3 != null) {
            throw new IOException(string3);
        }
        String string4 = String.valueOf(bundle);
        Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(21 + String.valueOf(string4).length()).append("Unexpected response: ").append(string4).toString(), (Throwable)new Throwable());
        throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
    }

    private Task<String> extractResponseWhenComplete(Task<Bundle> task) {
        return task.continueWith(FirebaseIidExecutors.directExecutor(), (Continuation)new GmsRpc$$Lambda$0(this));
    }

    static boolean isErrorMessageForRetryableError(String string) {
        return ERROR_SERVICE_NOT_AVAILABLE.equals(string) || ERROR_INTERNAL_SERVER_ERROR.equals(string) || "InternalServerError".equals(string);
    }

    final /* synthetic */ String lambda$extractResponseWhenComplete$0$GmsRpc(Task task) throws Exception {
        return this.handleResponse((Bundle)task.getResult(IOException.class));
    }
}

