/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Message;
import android.os.Parcel;
import android.os.RemoteException;
import androidx.annotation.NonNull;

interface IMessengerCompat
extends IInterface {
    public void send(@NonNull Message var1) throws RemoteException;

    public static class Impl
    extends Binder
    implements IMessengerCompat {
        @NonNull
        private final Handler handler;

        Impl(@NonNull Handler handler) {
            this.handler = handler;
            this.attachInterface(this, "com.google.android.gms.iid.IMessengerCompat");
        }

        @Override
        public void send(@NonNull Message message) throws RemoteException {
            message.arg2 = Binder.getCallingUid();
            this.handler.dispatchMessage(message);
        }

        public boolean onTransact(int n, @NonNull Parcel parcel, @NonNull Parcel parcel2, int n2) throws RemoteException {
            parcel.enforceInterface(this.getInterfaceDescriptor());
            if (n == 1) {
                Message message = parcel.readInt() != 0 ? (Message)Message.CREATOR.createFromParcel(parcel) : null;
                this.send(message);
                return true;
            }
            return false;
        }

        @NonNull
        public IBinder asBinder() {
            return this;
        }
    }

    public static class Proxy
    implements IMessengerCompat {
        private final IBinder remote;

        Proxy(@NonNull IBinder iBinder) {
            this.remote = iBinder;
        }

        @Override
        public void send(@NonNull Message message) throws RemoteException {
            Parcel parcel = Parcel.obtain();
            parcel.writeInterfaceToken("com.google.android.gms.iid.IMessengerCompat");
            parcel.writeInt(1);
            message.writeToParcel(parcel, 0);
            try {
                this.remote.transact(1, parcel, null, 1);
                return;
            }
            finally {
                parcel.recycle();
            }
        }

        @NonNull
        public IBinder asBinder() {
            return this.remote;
        }
    }
}

