/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import androidx.core.content.ContextCompat;
import com.google.firebase.iid.FirebaseInstanceId;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class Store {
    final SharedPreferences store;
    final Context context;
    @GuardedBy(value="this")
    private final Map<String, Long> subtypeCreationTimes = new ArrayMap();

    public Store(Context context) {
        this.context = context;
        this.store = context.getSharedPreferences("com.google.android.gms.appid", 0);
        this.checkForRestore("com.google.android.gms.appid-no-backup");
    }

    private void checkForRestore(String string) {
        File file = ContextCompat.getNoBackupFilesDir((Context)this.context);
        File file2 = new File(file, string);
        if (file2.exists()) {
            return;
        }
        try {
            if (file2.createNewFile() && !this.isEmpty()) {
                Log.i((String)"FirebaseInstanceId", (String)"App restored, clearing state");
                this.deleteAll();
                FirebaseInstanceId.getInstance().resetStorageAndScheduleSync();
            }
            return;
        }
        catch (IOException iOException) {
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                String string2 = String.valueOf(iOException.getMessage());
                Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Error creating file in no backup dir: ".concat(string2) : new String("Error creating file in no backup dir: ")));
            }
            return;
        }
    }

    public synchronized boolean isEmpty() {
        return this.store.getAll().isEmpty();
    }

    private String createTokenKey(String string, String string2, String string3) {
        return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append("|T|").append(string2).append("|").append(string3).toString();
    }

    static String createSubtypeInfoKey(String string, String string2) {
        return new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("|S|").append(string2).toString();
    }

    public synchronized void deleteAll() {
        this.subtypeCreationTimes.clear();
        this.store.edit().clear().commit();
    }

    public synchronized Token getToken(String string, String string2, String string3) {
        return Token.parse(this.store.getString(this.createTokenKey(string, string2, string3), null));
    }

    public synchronized void saveToken(String string, String string2, String string3, String string4, String string5) {
        String string6 = Token.encode(string4, string5, System.currentTimeMillis());
        if (string6 == null) {
            return;
        }
        SharedPreferences.Editor editor = this.store.edit();
        editor.putString(this.createTokenKey(string, string2, string3), string6);
        editor.commit();
    }

    public synchronized void deleteToken(String string, String string2, String string3) {
        String string4 = this.createTokenKey(string, string2, string3);
        SharedPreferences.Editor editor = this.store.edit();
        editor.remove(string4);
        editor.commit();
    }

    public synchronized long getCreationTime(String string) {
        Long l = this.subtypeCreationTimes.get(string);
        if (l != null) {
            return l;
        }
        return this.getCreationTimeFromSharedPreferences(string);
    }

    private long getCreationTimeFromSharedPreferences(String string) {
        String string2 = this.store.getString(Store.createSubtypeInfoKey(string, "cre"), null);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0L;
    }

    public synchronized long setCreationTime(String string) {
        long l = this.writeCreationTimeToSharedPreferences(string);
        this.subtypeCreationTimes.put(string, l);
        return l;
    }

    private long writeCreationTimeToSharedPreferences(String string) {
        long l = System.currentTimeMillis();
        String string2 = Store.createSubtypeInfoKey(string, "cre");
        if (!this.store.contains(string2)) {
            SharedPreferences.Editor editor = this.store.edit();
            editor.putString(Store.createSubtypeInfoKey(string, "cre"), String.valueOf(l));
            editor.commit();
            return l;
        }
        return this.getCreationTimeFromSharedPreferences(string);
    }

    static class Token {
        private static final long REFRESH_PERIOD_MILLIS = TimeUnit.DAYS.toMillis(7L);
        final String token;
        final String appVersion;
        final long timestamp;

        private Token(String string, String string2, long l) {
            this.token = string;
            this.appVersion = string2;
            this.timestamp = l;
        }

        static Token parse(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return null;
            }
            if (string.startsWith("{")) {
                try {
                    JSONObject jSONObject = new JSONObject(string);
                    return new Token(jSONObject.getString("token"), jSONObject.getString("appVersion"), jSONObject.getLong("timestamp"));
                }
                catch (JSONException jSONException) {
                    String string2 = String.valueOf((Object)jSONException);
                    Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Failed to parse token: ").append(string2).toString());
                    return null;
                }
            }
            return new Token(string, null, 0L);
        }

        static String encode(String string, String string2, long l) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("token", (Object)string);
                jSONObject.put("appVersion", (Object)string2);
                jSONObject.put("timestamp", l);
                return jSONObject.toString();
            }
            catch (JSONException jSONException) {
                String string3 = String.valueOf((Object)jSONException);
                Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(24 + String.valueOf(string3).length()).append("Failed to encode token: ").append(string3).toString());
                return null;
            }
        }

        static String getTokenOrNull(@Nullable Token token) {
            if (token == null) {
                return null;
            }
            return token.token;
        }

        boolean needsRefresh(String string) {
            return System.currentTimeMillis() > this.timestamp + REFRESH_PERIOD_MILLIS || !string.equals(this.appVersion);
        }
    }
}

