/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.iid.MessengerCompat;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzd;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class zzf {
    static String aaG = null;
    static int aaH = 0;
    static int aaI = 0;
    static int aaJ = 0;
    Context zzagf;
    Map<String, Object> aaK = new HashMap<String, Object>();
    Messenger Zu;
    Messenger aaL;
    MessengerCompat aaM;
    PendingIntent Zq;
    long aaN;
    long aaO;
    int aaP;
    int aaQ;
    long aaR;

    public zzf(Context context) {
        this.zzagf = context;
    }

    public static String zzdi(Context context) {
        if (aaG != null) {
            return aaG;
        }
        aaH = Process.myUid();
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentServices(new Intent("com.google.android.c2dm.intent.REGISTER"), 0);
        for (ResolveInfo resolveInfo : list) {
            String string;
            if (0 == packageManager.checkPermission("com.google.android.c2dm.permission.RECEIVE", resolveInfo.serviceInfo.packageName)) {
                try {
                    string = packageManager.getApplicationInfo(resolveInfo.serviceInfo.packageName, 0);
                    int n = ((ApplicationInfo)string).uid;
                    Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(17).append("Found ").append(n).toString());
                    aaI = ((ApplicationInfo)string).uid;
                    aaG = resolveInfo.serviceInfo.packageName;
                    return aaG;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    continue;
                }
            }
            string = String.valueOf(resolveInfo.serviceInfo.packageName);
            String string2 = String.valueOf("com.google.android.c2dm.intent.REGISTER");
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(56 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Possible malicious package ").append(string).append(" declares ").append(string2).append(" without permission").toString());
        }
        Log.w((String)"InstanceID/Rpc", (String)"Failed to resolve REGISTER intent, falling back");
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo("com.google.android.gms", 0);
            aaG = applicationInfo.packageName;
            aaI = applicationInfo.uid;
            return aaG;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            try {
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo("com.google.android.gsf", 0);
                aaG = applicationInfo.packageName;
                aaI = applicationInfo.uid;
                return aaG;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException2) {
                Log.w((String)"InstanceID/Rpc", (String)"Both Google Play Services and legacy GSF package are missing");
                return null;
            }
        }
    }

    private static int zzdj(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(zzf.zzdi(context), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return -1;
        }
    }

    static String zza(KeyPair keyPair, String ... stringArray) {
        byte[] byArray;
        try {
            byArray = TextUtils.join((CharSequence)"\n", (Object[])stringArray).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to encode string", (Throwable)unsupportedEncodingException);
            return null;
        }
        try {
            PrivateKey privateKey = keyPair.getPrivate();
            String string = privateKey instanceof RSAPrivateKey ? "SHA256withRSA" : "SHA256withECDSA";
            Signature signature = Signature.getInstance(string);
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            return FirebaseInstanceId.zzu(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to sign registration request", (Throwable)generalSecurityException);
            return null;
        }
    }

    void zzbmb() {
        if (this.Zu != null) {
            return;
        }
        zzf.zzdi(this.zzagf);
        this.Zu = new Messenger(new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                zzf.this.zze(message);
            }
        });
    }

    public void zze(Message message) {
        if (message == null) {
            return;
        }
        if (message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader(MessengerCompat.class.getClassLoader());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof MessengerCompat) {
                    this.aaM = (MessengerCompat)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.aaL = (Messenger)parcelable;
                }
            }
            this.zzv((Intent)message.obj);
        } else {
            Log.w((String)"InstanceID/Rpc", (String)"Dropping invalid message");
        }
    }

    synchronized void zzs(Intent intent) {
        if (this.Zq == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.Zq = PendingIntent.getBroadcast((Context)this.zzagf, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.Zq);
    }

    public void zza(Bundle bundle, KeyPair keyPair, String string) throws IOException {
        long l = SystemClock.elapsedRealtime();
        if (this.aaR != 0L && l <= this.aaR) {
            long l2 = this.aaR - l;
            int n = this.aaQ;
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(78).append("Backoff mode, next request attempt: ").append(l2).append(" interval: ").append(n).toString());
            throw new IOException("RETRY_LATER");
        }
        this.zzbmb();
        if (aaG == null) {
            throw new IOException("MISSING_INSTANCEID_SERVICE");
        }
        this.aaN = SystemClock.elapsedRealtime();
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(aaG);
        int n = zzf.zzdj(this.zzagf);
        bundle.putString("gmsv", Integer.toString(n));
        bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle.putString("app_ver", Integer.toString(FirebaseInstanceId.zzdf(this.zzagf)));
        bundle.putString("app_ver_name", FirebaseInstanceId.zzdg(this.zzagf));
        bundle.putString("cliv", "fiid-9452000");
        bundle.putString("appid", FirebaseInstanceId.zza(keyPair));
        String string2 = FirebaseInstanceId.zzem(this.zzagf);
        if (string2 != null) {
            bundle.putString("gmp_app_id", string2);
        }
        String string3 = FirebaseInstanceId.zzu(keyPair.getPublic().getEncoded());
        bundle.putString("pub2", string3);
        bundle.putString("sig", zzf.zza(keyPair, this.zzagf.getPackageName(), string3));
        intent.putExtras(bundle);
        this.zzs(intent);
        this.zzb(intent, string);
    }

    protected void zzb(Intent intent, String string) {
        block7: {
            String string2;
            this.aaN = SystemClock.elapsedRealtime();
            intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string).length()).append("|ID|").append(string).append("|").toString());
            intent.putExtra("X-kid", new StringBuilder(5 + String.valueOf(string).length()).append("|ID|").append(string).append("|").toString());
            boolean bl = "com.google.android.gsf".equals(aaG);
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                string2 = String.valueOf(intent.getExtras());
                Log.d((String)"InstanceID/Rpc", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
            }
            if (bl) {
                this.zzagf.startService(intent);
                return;
            }
            intent.putExtra("google.messenger", (Parcelable)this.Zu);
            if (this.aaL != null || this.aaM != null) {
                string2 = Message.obtain();
                ((Message)string2).obj = intent;
                try {
                    if (this.aaL != null) {
                        this.aaL.send((Message)string2);
                    } else {
                        this.aaM.send((Message)string2);
                    }
                    return;
                }
                catch (RemoteException remoteException) {
                    if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block7;
                    Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                }
            }
        }
        this.zzagf.startService(intent);
    }

    String zzt(Intent intent) throws IOException {
        if (intent == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string = intent.getStringExtra("registration_id");
        if (string == null) {
            string = intent.getStringExtra("unregistered");
        }
        if (string == null) {
            string = intent.getStringExtra("error");
            if (string != null) {
                throw new IOException(string);
            }
            String string2 = String.valueOf(intent.getExtras());
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(29 + String.valueOf(string2).length()).append("Unexpected response from GCM ").append(string2).toString(), (Throwable)new Throwable());
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        return string;
    }

    void zzu(Intent intent) {
        String string = intent.getStringExtra("error");
        if (string == null) {
            String string2 = String.valueOf(intent.getExtras());
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(49 + String.valueOf(string2).length()).append("Unexpected response, no error or registration id ").append(string2).toString());
            return;
        }
        if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
            String string3 = String.valueOf(string);
            Log.d((String)"InstanceID/Rpc", (String)(string3.length() != 0 ? "Received InstanceID error ".concat(string3) : new String("Received InstanceID error ")));
        }
        String string4 = null;
        if (string.startsWith("|")) {
            String[] stringArray = string.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                String string5 = String.valueOf(string);
                Log.w((String)"InstanceID/Rpc", (String)(string5.length() != 0 ? "Unexpected structured response ".concat(string5) : new String("Unexpected structured response ")));
            }
            if (stringArray.length > 2) {
                string4 = stringArray[2];
                string = stringArray[3];
                if (string.startsWith(":")) {
                    string = string.substring(1);
                }
            } else {
                string = "UNKNOWN";
            }
            intent.putExtra("error", string);
        }
        if (null == string4) {
            this.zzae(string);
        } else {
            this.zzi(string4, string);
        }
        long l = intent.getLongExtra("Retry-After", 0L);
        if (l > 0L) {
            this.aaO = SystemClock.elapsedRealtime();
            this.aaQ = (int)l * 1000;
            this.aaR = SystemClock.elapsedRealtime() + (long)this.aaQ;
            int n = this.aaQ;
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(52).append("Explicit request from server to backoff: ").append(n).toString());
        } else if ("SERVICE_NOT_AVAILABLE".equals(string) || "AUTHENTICATION_FAILED".equals(string)) {
            this.zzke(string);
        }
    }

    private void zzke(String string) {
        if (!"com.google.android.gsf".equals(aaG)) {
            return;
        }
        ++this.aaP;
        if (this.aaP < 3) {
            return;
        }
        if (this.aaP == 3) {
            this.aaQ = 1000 + new Random().nextInt(1000);
        }
        this.aaQ *= 2;
        this.aaR = SystemClock.elapsedRealtime() + (long)this.aaQ;
        int n = this.aaQ;
        Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(31 + String.valueOf(string).length()).append("Backoff due to ").append(string).append(" for ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzae(Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            for (String string : this.aaK.keySet()) {
                Object object2 = this.aaK.get(string);
                this.aaK.put(string, object);
                this.zzh(object2, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzi(String string, Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Object object2 = this.aaK.get(string);
            this.aaK.put(string, object);
            this.zzh(object2, object);
        }
    }

    private void zzh(Object object, Object object2) {
        if (object instanceof ConditionVariable) {
            ((ConditionVariable)object).open();
        }
        if (object instanceof Messenger) {
            Messenger messenger = (Messenger)object;
            Message message = Message.obtain();
            message.obj = object2;
            try {
                messenger.send(message);
            }
            catch (RemoteException remoteException) {
                String string = String.valueOf((Object)remoteException);
                Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(24 + String.valueOf(string).length()).append("Failed to send response ").append(string).toString());
            }
        }
    }

    void zzv(Intent intent) {
        String[] stringArray;
        String string;
        if (intent == null) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)"Unexpected response: null");
            }
            return;
        }
        String string2 = intent.getAction();
        if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string2)) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                String string3 = String.valueOf(intent.getAction());
                Log.d((String)"InstanceID/Rpc", (String)(string3.length() != 0 ? "Unexpected response ".concat(string3) : new String("Unexpected response ")));
            }
            return;
        }
        String string4 = intent.getStringExtra("registration_id");
        if (string4 == null) {
            string4 = intent.getStringExtra("unregistered");
        }
        if (string4 == null) {
            this.zzu(intent);
            return;
        }
        this.aaN = SystemClock.elapsedRealtime();
        this.aaR = 0L;
        this.aaP = 0;
        this.aaQ = 0;
        if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
            string = string4;
            stringArray = String.valueOf(intent.getExtras());
            Log.d((String)"InstanceID/Rpc", (String)new StringBuilder(16 + String.valueOf(string).length() + String.valueOf(stringArray).length()).append("AppIDResponse: ").append(string).append(" ").append((String)stringArray).toString());
        }
        string = null;
        if (string4.startsWith("|")) {
            stringArray = string4.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                String string5 = String.valueOf(string4);
                Log.w((String)"InstanceID/Rpc", (String)(string5.length() != 0 ? "Unexpected structured response ".concat(string5) : new String("Unexpected structured response ")));
            }
            string = stringArray[2];
            if (stringArray.length > 4) {
                if ("SYNC".equals(stringArray[3])) {
                    FirebaseInstanceId.zzdh(this.zzagf);
                } else if ("RST".equals(stringArray[3])) {
                    FirebaseInstanceId.zza(this.zzagf, zzd.zzb(this.zzagf, null).zzcwy());
                    intent.removeExtra("registration_id");
                    this.zzi(string, intent);
                    return;
                }
            }
            if ((string4 = stringArray[stringArray.length - 1]).startsWith(":")) {
                string4 = string4.substring(1);
            }
            intent.putExtra("registration_id", string4);
        }
        if (null == string) {
            this.zzae(intent);
        } else {
            this.zzi(string, intent);
        }
    }

    Intent zza(Bundle bundle, KeyPair keyPair) throws IOException {
        Intent intent = this.zzb(bundle, keyPair);
        if (intent != null && intent.hasExtra("google.messenger")) {
            intent = this.zzb(bundle, keyPair);
        }
        return intent;
    }

    public static synchronized String zzbmc() {
        return Integer.toString(aaJ++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Intent zzb(Bundle bundle, KeyPair keyPair) throws IOException {
        ConditionVariable conditionVariable = new ConditionVariable();
        String string = zzf.zzbmc();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.aaK.put(string, conditionVariable);
        }
        this.zza(bundle, keyPair, string);
        conditionVariable.block(30000L);
        clazz = this.getClass();
        synchronized (clazz) {
            Object object = this.aaK.remove(string);
            if (object instanceof Intent) {
                return (Intent)object;
            }
            if (object instanceof String) {
                throw new IOException((String)object);
            }
            String string2 = String.valueOf(object);
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(12 + String.valueOf(string2).length()).append("No response ").append(string2).toString());
            throw new IOException("TIMEOUT");
        }
    }
}

