/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdInternalReceiver;
import com.google.firebase.iid.zzb;
import com.google.firebase.iid.zzd;
import com.google.firebase.iid.zze;
import com.google.firebase.iid.zzf;
import com.google.firebase.iid.zzg;
import java.io.IOException;

public class FirebaseInstanceIdService
extends zzb {
    private static BroadcastReceiver bhu;
    private static final Object bhv;
    private static boolean bhw;
    private boolean bhx = false;

    @Override
    public boolean zzag(Intent intent) {
        this.bhx = Log.isLoggable((String)"FirebaseInstanceId", (int)3);
        if (intent.getStringExtra("error") != null || intent.getStringExtra("registration_id") != null) {
            String string = this.zzai(intent);
            if (this.bhx) {
                String string2 = String.valueOf(string);
                Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Register result in service ".concat(string2) : new String("Register result in service ")));
            }
            this.zztu(string).I().zzv(intent);
            return true;
        }
        return false;
    }

    @Override
    public void zzm(Intent intent) {
        String string = intent.getAction();
        if (string == null) {
            string = "";
        }
        switch (string) {
            case "ACTION_TOKEN_REFRESH_RETRY": {
                this.zza(intent, false);
                return;
            }
        }
        this.zzah(intent);
    }

    @Override
    protected Intent zzae(Intent intent) {
        return FirebaseInstanceIdInternalReceiver.F();
    }

    public void zzah(Intent intent) {
        String string = this.zzai(intent);
        zzd zzd2 = this.zztu(string);
        String string2 = intent.getStringExtra("CMD");
        if (this.bhx) {
            String string3 = String.valueOf(intent.getExtras());
            Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Service command ").append(string).append(" ").append(string2).append(" ").append(string3).toString());
        }
        if (null != intent.getStringExtra("unregistered")) {
            zzd2.H().zzku(string == null ? "" : string);
            zzd2.I().zzv(intent);
            return;
        }
        if ("gcm.googleapis.com/refresh".equals(intent.getStringExtra("from"))) {
            zzd2.H().zzku(string);
            this.zza(intent, false);
            return;
        }
        if ("RST".equals(string2)) {
            zzd2.zzboq();
            this.zza(intent, true);
        } else if ("RST_FULL".equals(string2)) {
            if (!zzd2.H().isEmpty()) {
                zzd2.zzboq();
                zzd2.H().zzbow();
                this.zza(intent, true);
            }
        } else if ("SYNC".equals(string2)) {
            zzd2.H().zzku(string);
            this.zza(intent, false);
        } else if ("PING".equals(string2)) {
            this.zza(zzd2.I(), intent.getExtras());
        }
    }

    private String zzai(Intent intent) {
        String string = intent.getStringExtra("subtype");
        return string == null ? "" : string;
    }

    private zzd zztu(String string) {
        if (string == null) {
            return zzd.zzb((Context)this, null);
        }
        Bundle bundle = new Bundle();
        bundle.putString("subtype", string);
        return zzd.zzb((Context)this, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(Intent intent, boolean bl) {
        Object object = bhv;
        synchronized (object) {
            bhw = false;
        }
        if (zzf.zzdj((Context)this) == null) {
            return;
        }
        object = FirebaseInstanceId.getInstance();
        if (((FirebaseInstanceId)object).C() == null) {
            try {
                String string = ((FirebaseInstanceId)object).D();
                if (string != null) {
                    if (this.bhx) {
                        Log.d((String)"FirebaseInstanceId", (String)"get master token succeeded");
                    }
                    FirebaseInstanceIdService.zza((Context)this, (FirebaseInstanceId)object);
                    this.onTokenRefresh();
                    return;
                }
                this.zzd(intent, "returned token is null");
            }
            catch (IOException iOException) {
                this.zzd(intent, iOException.getMessage());
            }
            catch (SecurityException securityException) {
                Log.e((String)"FirebaseInstanceId", (String)"Unable to get master token", (Throwable)securityException);
                return;
            }
            return;
        }
        zze zze2 = ((FirebaseInstanceId)object).E();
        String string = zze2.J();
        while (string != null) {
            String[] stringArray = string.split("!");
            if (stringArray.length == 2) {
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                try {
                    switch (string2) {
                        case "S": {
                            FirebaseInstanceId.getInstance().zzts(string3);
                            if (!this.bhx) break;
                            Log.d((String)"FirebaseInstanceId", (String)"subscribe operation succeeded");
                            break;
                        }
                        case "U": {
                            FirebaseInstanceId.getInstance().zztt(string3);
                            if (!this.bhx) break;
                            Log.d((String)"FirebaseInstanceId", (String)"unsubscribe operation succeeded");
                        }
                    }
                }
                catch (IOException iOException) {
                    this.zzd(intent, iOException.getMessage());
                    return;
                }
            }
            zze2.zztv(string);
            string = zze2.J();
        }
        Log.d((String)"FirebaseInstanceId", (String)"topic sync succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzd(Intent intent, String string) {
        boolean bl = FirebaseInstanceIdService.zzeu((Context)this);
        final int n = this.zzb(intent, bl);
        Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(47 + String.valueOf(string).length()).append("background sync failed: ").append(string).append(", retry in ").append(n).append("s").toString());
        Object object = bhv;
        synchronized (object) {
            this.zzagl(n);
            bhw = true;
        }
        if (!bl) {
            if (this.bhx) {
                Log.d((String)"FirebaseInstanceId", (String)"device not connected. Connectivity change received registered");
            }
            if (bhu == null) {
                bhu = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        if (FirebaseInstanceIdService.zzeu(context)) {
                            if (FirebaseInstanceIdService.this.bhx) {
                                Log.d((String)"FirebaseInstanceId", (String)"connectivity changed. starting background sync.");
                            }
                            FirebaseInstanceIdService.this.getApplicationContext().unregisterReceiver((BroadcastReceiver)this);
                            context.sendBroadcast(FirebaseInstanceIdService.zzagk(n));
                        }
                    }
                };
            }
            this.getApplicationContext().registerReceiver(bhu, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Context context, FirebaseInstanceId firebaseInstanceId) {
        Object object = bhv;
        synchronized (object) {
            if (bhw) {
                return;
            }
        }
        object = firebaseInstanceId.C();
        if (object == null || ((zzg.zza)object).zztz(zzd.afY) || firebaseInstanceId.E().J() != null) {
            FirebaseInstanceIdService.zzet(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zzet(Context context) {
        if (zzf.zzdj(context) == null) {
            return;
        }
        Object object = bhv;
        synchronized (object) {
            if (!bhw) {
                context.sendBroadcast(FirebaseInstanceIdService.zzagk(0));
                bhw = true;
            }
        }
    }

    private static Intent zzagk(int n) {
        Context context = FirebaseApp.getInstance().getApplicationContext();
        Intent intent = new Intent("ACTION_TOKEN_REFRESH_RETRY");
        intent.putExtra("next_retry_delay_in_seconds", n);
        return FirebaseInstanceIdInternalReceiver.zzg(context, intent);
    }

    private void zzagl(int n) {
        AlarmManager alarmManager = (AlarmManager)this.getSystemService("alarm");
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)FirebaseInstanceIdService.zzagk(n * 2), (int)0x10000000);
        alarmManager.set(3, SystemClock.elapsedRealtime() + (long)(n * 1000), pendingIntent);
    }

    private int zzb(Intent intent, boolean bl) {
        int n = intent == null ? 10 : intent.getIntExtra("next_retry_delay_in_seconds", 0);
        if (n < 10 && !bl) {
            n = 30;
        } else if (n < 10) {
            n = 10;
        } else if (n > 28800) {
            n = 28800;
        }
        return n;
    }

    private static boolean zzeu(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    private void zza(zzf zzf2, Bundle bundle) {
        String string = zzf.zzdj((Context)this);
        if (string == null) {
            Log.w((String)"FirebaseInstanceId", (String)"Unable to respond to ping due to missing target package");
            return;
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        intent.setPackage(string);
        intent.putExtras(bundle);
        zzf2.zzs(intent);
        intent.putExtra("google.to", "google.com/iid");
        intent.putExtra("google.message_id", zzf.zzbov());
        this.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    @WorkerThread
    public void onTokenRefresh() {
    }

    static {
        bhv = new Object();
        bhw = false;
    }
}

